#ifndef KP_STATUSBAR_H_
#define KP_STATUSBAR_H_

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "../kptraininglog.h"

#include "kpviewmodel.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define KP_TYPE_STATUSBAR (kp_statusbar_get_type())
#define KP_STATUSBAR(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_STATUSBAR, KPStatusbar))
#define KP_STATUSBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_STATUSBAR, KPStatusbarClass))
#define KP_IS_STATUSBAR(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_STATUSBAR))
#define KP_IS_STATUSBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_STATUSBAR))
#define KP_STATUSBAR_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_STATUSBAR, KPStatusbarClass))

typedef struct KPStatusbar_
{
  GtkHBox         parent;

  gpointer        private_data;
} KPStatusbar;

typedef struct KPStatusbarClass_
{
  GtkHBoxClass    parent;

} KPStatusbarClass;

typedef struct KPStatusbarFieldData_ {
  guint     n;
  gchar    *name;
  gchar    *setting;
} KPStatusbarFieldData;

typedef enum {
  KP_STATUSBAR_F_N_ENTRIES,
  KP_STATUSBAR_F_N_COMMENTS,
  KP_STATUSBAR_F_N_WORKOUTS,
  KP_STATUSBAR_F_T_DISTANCE,
  KP_STATUSBAR_F_T_DURATION,
  KP_STATUSBAR_F_VIEW_TYPE,
  KP_STATUSBAR_F_VIEW,
  KP_STATUSBAR_F_N,
} KPStatusbarFieldType;

GType                 kp_statusbar_get_type           (void);

GtkWidget            *kp_statusbar_new                (KPTrainingLog *log);

void                  kp_statusbar_set_log            (KPStatusbar *bar,
                                                       KPTrainingLog *log);
void                  kp_statusbar_unset_log          (KPStatusbar *bar);

void                  kp_statusbar_set_message        (KPStatusbar *bar,
                                                       const gchar *message);
void                  kp_statusbar_set_view_type      (KPStatusbar *bar,
                                                       KPViewModelType type);
void                  kp_statusbar_set_viewer_name    (KPStatusbar *bar,  
                                                       const gchar *name);
void                  kp_statusbar_set_format_message (KPStatusbar *bar,
                                                       const gchar *format,
                                                       ...);
void                  kp_statusbar_update             (KPStatusbar *bar);

gboolean              kp_statusbar_get_field_status   (KPStatusbarFieldType type);
KPStatusbarFieldData *kp_statusbar_get_field          (guint field);
void                  kp_statusbar_field_free         (KPStatusbarFieldData *data);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* KP_STATUSBAR_H_ */
