#ifndef KP_HTML_UTIL_H_
#define KP_HTML_UTIL_H_

#include <stdio.h>
#include <glib.h>


typedef struct {
  guint  y;          /* Year or 0 */
  guint  m;          /* Month or 0 */
  guint  id;         /* ID or 0 */
  
  gchar *extra_page_names[5];
  gchar *extra_page_uris[5];
} KPHtmlNaviData;

void      kp_html_table_start       (FILE *fp);
void      kp_html_table_head        (FILE *fp, const gchar *title, ...);
void      kp_html_table_cell        (FILE *fp, const gchar *format, ...);
void      kp_html_table_cell_cspan  (FILE *fp, guint cspan, const gchar *format, ...);
void      kp_html_table_cell_full   (FILE *fp, const gchar *klass, 
                                     const gchar *style,
                                     gint colspan,
                                     gint rowspan,
                                     const gchar *format,
                                     ...);
void      kp_html_table_head_cell   (FILE *fp, const gchar *item, ...);
void      kp_html_table_row         (FILE *fp, const gchar *item, ...);
void      kp_html_table_head_row    (FILE *fp, const gchar *item, ...);
void      kp_html_table_row_start   (FILE *fp);
void      kp_html_table_row_end     (FILE *fp);
void      kp_html_table_foot        (FILE *fp);

void      kp_html_h1                (FILE *fp, const gchar *format, ...);
void      kp_html_navi              (FILE *fp, KPHtmlNaviData *data, 
                                     guint y, guint m, guint id);


#endif /* KP_HTML_UTIL_H_ */
