#include <glib.h>

#include "kpsplit.h"


KPSplit *
kp_split_new (void) 
{
  KPSplit *split;
  
  split = g_new (KPSplit, 1);
  split->type = NULL;
  split->n = 0;
  split->distance = 0.0;
  split->duration = 0;
  split->sport = NULL;
  split->comment = NULL;

  return split;
}


KPSplit *
kp_split_new_full (const gchar *type, guint n, gdouble distance, guint duration, 
                   const gchar *sport, const gchar *comment)
{
  KPSplit *split;

  split = kp_split_new ();
  split->n = n;
  split->type = (type) ? g_strdup (type) : NULL;
  split->distance = distance;
  split->duration = duration;
  split->sport = (sport) ? g_strdup (sport) : NULL;
  split->comment = (comment) ? g_strdup (comment) : NULL;

  return split;
}

void
kp_split_free (KPSplit *split)
{
  if (split->type)
    g_free (split->type);
  if (split->sport)
    g_free (split->sport);
  if (split->comment)
    g_free (split->comment);
  g_free (split);
}

xmlNodePtr
kp_split_to_xml (KPSplit *split)
{
  /* TODO */
  return NULL;
}


guint
kp_split_get_pace (KPSplit *split)
{
  guint duration;
  
  g_return_val_if_fail (split != NULL, 0);
  
  if (split->duration > 0 && split->distance > 0.0) {
    duration = (guint) ((gdouble) split->duration / split->distance) / 1000;
    /* Remove .xxx */
    return duration * 1000;
  }

  return 0;
}


gdouble
kp_split_get_speed (KPSplit *split)
{
  gdouble duration;

  g_return_val_if_fail (split != NULL, 0.0);
  
  if (split->duration > 0 && split->distance > 0.0) {
    duration = (gdouble) ((gdouble)split->duration / (gdouble)(60 * 60 * 1000));
    return split->distance / duration;
  }
    
  return 0.0;
}

