#ifndef KP_WORKOUT_H_
#define KP_WORKOUT_H_

#include <glib.h>
#include <glib-object.h>
#include <libxml/tree.h>

#include "kpcalendarentry.h"
#include "kpparamlist.h"
#include "kpparam.h"

#define KP_TYPE_WORKOUT (kp_workout_get_type())
#define KP_WORKOUT(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_WORKOUT, KPWorkout))
#define KP_WORKOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_WORKOUT, KPWorkoutClass))
#define KP_IS_WORKOUT(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_WORKOUT))
#define KP_IS_WORKOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_WORKOUT))
#define KP_WORKOUT_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_WORKOUT, KPWorkoutClass))


typedef struct KPWorkout_
{
  KPCalendarEntry   parent_instance;

  GSList           *sports;
  GHashTable       *params;

  KPParamList      *param_list;
}
KPWorkout;

typedef struct KPWorkoutClass_ {
  KPCalendarEntryClass    parent_class;

  GSList              * (*get_sport_list) (KPWorkout *wo, guint *n);
} KPWorkoutClass;

typedef struct KPWorkoutParam_ {
  gchar *param;
  gchar *value;
} KPWorkoutParam;


GType         kp_workout_get_type                     (void);
 
KPWorkout    *kp_workout_new                          (void);
gboolean      kp_workout_is_valid                     (KPWorkout *wo);
KPWorkout    *kp_workout_copy                         (KPWorkout *wo);
void          kp_workout_set_sport                    (KPWorkout *wo,
                                                       const gchar *sport);
G_CONST_RETURN gchar *
              kp_workout_get_sport                    (KPWorkout *wo);
void          kp_workout_set_comment                  (KPWorkout *wo,
                                                       const gchar *comment);
gchar        *kp_workout_get_comment                  (KPWorkout *wo);
gchar        *kp_workout_get_formatted_date           (KPWorkout *wo);

KPParamList  *kp_workout_get_param_list               (KPWorkout *wo);

/* Obsoleted */
void          kp_workout_print                        (KPWorkout *wo);
gchar        *kp_workout_get_duration_str             (KPWorkout *wo);

#endif
