#include <time.h>

#include "../kpplugin.h"
#include "../kipina-i18n.h"
#include "../gui/kpmainwindow.h"
#include "../gui/kpchart.h"

gboolean loaded = FALSE;

static gboolean
plugin_load(KPPlugin *plugin)
{
  GtkWidget *window;
  GtkWidget *chart;
  gdouble **data_ptr;
  guint i,j;
  gdouble data[4][5] = 
  {
    {  12.2,  23.0,  23.0,  18.4,  20.0 },
    { 118.2,  10.0, 112.1, 118.1, 124.1 },
    {  14.5,  33.0,  22.0,  12.4,  -19.1 },
    { 200.0, 110.0,  90.0,  82.0,  34.0 }
  };

  data_ptr = (gdouble **) g_malloc0 (sizeof (gdouble *) * 4);
  for (i=0; i< 4; i++) {
    data_ptr[i] = (gdouble *) g_malloc0 (sizeof (gdouble) * 5);
    for (j = 0; j < 5; j++)
      data_ptr[i][j] = data[i][j];
  }

  if (loaded)
    return TRUE;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  
  chart = kp_chart_new ();
  kp_chart_set_size (KP_CHART (chart), 4, 5);

  kp_chart_set_title (KP_CHART (chart), "An example chart");
  
  kp_chart_set_group_title (KP_CHART (chart), 0, "Small 1 G");
  kp_chart_set_group_title (KP_CHART (chart), 1, "Big 2 G");
  kp_chart_set_group_title (KP_CHART (chart), 2, "Small 3 G");
  kp_chart_set_group_title (KP_CHART (chart), 3, "Big 4 G");

  kp_chart_set_axis (KP_CHART (chart), 1, 1);
  kp_chart_set_axis (KP_CHART (chart), 2, 1);
  kp_chart_set_axis (KP_CHART (chart), 3, 2);

  kp_chart_set_item_title_int (KP_CHART (chart), 0, 1920);
  kp_chart_set_item_title_int (KP_CHART (chart), 1, 1940);
  kp_chart_set_item_title_int (KP_CHART (chart), 2, 1960);
  kp_chart_set_item_title_int (KP_CHART (chart), 3, 1980);
  kp_chart_set_item_title_int (KP_CHART (chart), 4, 2000);
  
  kp_chart_set (KP_CHART (chart), data_ptr);
  
  gtk_container_add (GTK_CONTAINER (window), chart);

  gtk_widget_show_all (window);
  
  return TRUE;
}

static gboolean
plugin_unload(KPPlugin *plugin)
{
  return TRUE;
}

static KPPluginInfo info =
{
  1,                                                /**< api_version    */
  "chart-test",                                     /**< id             */
  N_("Chart Widget Test Plugin") ,                  /**< name           */
  VERSION,                                          /**< version        */
  N_("Just test some chart widget features."),
  N_(".."),
  "Ville Kangas <ville@mirjami.net>",               /**< author         */
  "http://mirjami.net/~ville/kipina",               /**< homepage       */
  NULL,
  plugin_load,                                      /**< load           */
  plugin_unload,                                    /**< unload         */
  NULL,                                             /**< destroy        */
};

static void
init_plugin(KPPlugin *plugin)
{
}

KP_PLUGIN_INIT("chart-test", init_plugin, info)
