#include <iostream>

#include <time.h>

#include "../kpplugin.h"
#include "../kipina-i18n.h"
#include "../gui/kpmainwindow.h"

GtkWidget     *clock_label;
KPStatusbar   *bar = NULL;


static gboolean
update_clock (KPPlugin *plugin)
{
  gchar buf[255];
  struct tm *tm_ptr;
  time_t tm;

  /* Plugin disabled, stop updating label */
  if (clock_label == NULL) {
    kp_debug ("Return FALSE!");
    bar = NULL;
    return FALSE;
  }
  
  tm = time (NULL);
  tm_ptr = localtime (&tm);
  strftime (buf, sizeof(buf)-1, "%H:%M:%S", (const struct tm *) tm_ptr);
  gtk_label_set_text (GTK_LABEL (clock_label), buf); 
 
  return TRUE;
}


static gboolean
plugin_load(KPPlugin *plugin)
{
  /* Already loaded. */
  if (bar)
    return TRUE;

  bar = kp_main_window_get_status_bar ();

  g_timeout_add (1000, (GSourceFunc) update_clock, plugin);

  clock_label = gtk_label_new ("");
  gtk_box_pack_end (GTK_BOX (bar), clock_label, FALSE, TRUE, 0);
  gtk_widget_show (clock_label);

  /* Update the clock manually first time to prevent 1 sec delay */
  update_clock (plugin);

  std::cout << "Plugin loaded!" << std::endl;

  return TRUE;
}

static gboolean
plugin_unload(KPPlugin *plugin)
{
  gtk_container_remove (GTK_CONTAINER (bar), clock_label);
  clock_label = NULL;
  bar = NULL;

  return TRUE;
}

static KPPluginInfo info =
{
  1,                                                /**< api_version    */
  "clock2",                                         /**< id             */
  N_("Clock Plugin2") ,                             /**< name           */
  VERSION,                                          /**< version        */
  N_("Show clock in the Status bar."),
  N_("Shows a clock and/or date in the status bar."),
  "Ville Kangas <ville@mirjami.net>",               /**< author         */
  "http://mirjami.net/~ville/kipina",               /**< homepage       */
  NULL,
  plugin_load,                                      /**< load           */
  plugin_unload,                                    /**< unload         */
  NULL,                                             /**< destroy        */
};

static void
init_plugin(KPPlugin *plugin)
{
}

extern "C" {
KP_PLUGIN_INIT("clock2", init_plugin, info)
}
