#include <time.h>

#include "../kpplugin.h"
#include "../kputil.h"
#include "../kipina-i18n.h"
#include "../kptraininglog.h"
#include "../gui/kpmainwindow.h"
#include "../gui/kpcontexts.h"
#include "../gui/kpworkouteditor.h"

GtkWidget *clock_label;
GtkWidget *item = NULL;
KPStatusbar *bar;
GtkWidget *mi_test = NULL;

static void
test_menubar (void)
{
  GtkMenu *menu;
  GtkWidget *mi_foo;
  GtkWidget *mi_bar;

  menu = GTK_MENU (gtk_menu_new ());

  mi_foo = gtk_menu_item_new_with_label ("Foo");
  mi_bar = gtk_menu_item_new_with_label ("Bar");

  gtk_menu_shell_append (GTK_MENU_SHELL (menu), mi_foo);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), mi_bar);
  
  gtk_widget_show (mi_foo);
  gtk_widget_show (mi_bar);
}

static void
test_export_menu (void)
{
  GtkWidget *menu_item;

  menu_item = gtk_menu_item_new_with_label ("Export test");
  kp_main_window_add_to_export_menu (GTK_MENU_ITEM (menu_item));
}


static void
make_info_window (GtkMenuItem *item, gpointer data)
{
  KPTrainingLog *log;
  GtkWidget *window;
  GtkWidget *label;
  KPViewModel *model;
  KPView *view;
  gchar *v_str;
  gchar *str;
 
  view = kp_main_window_get_view ();
  model = kp_view_get_current_viewer (view);
  
  v_str = kp_view_model_type_to_string (kp_view_model_get_view_type (model), NULL);
  log = kp_main_window_get_log ();

  if (KP_IS_TRAINING_LOG (log))
    str = g_strdup_printf ("You are using viewer: %s with view type %s.\n"
                           "The log has %d entries.\n",
                           G_OBJECT_TYPE_NAME (model),
                           v_str,
                           kp_training_log_get_size (log));
  else
    str = g_strdup ("The log has no entries.");
 
  label = gtk_label_new (str);
  gtk_widget_show (label);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_container_add (GTK_CONTAINER (window), label);
  gtk_widget_show (window);

  gtk_widget_set_size_request (window, 200, 300);
}


static void
test_import_menu (void)
{
  item = gtk_menu_item_new_with_label ("This is just a test plugin");
  kp_main_window_add_to_import_menu (GTK_MENU_ITEM (item));

  g_signal_connect (G_OBJECT (item), "activate",
                    G_CALLBACK (make_info_window), NULL);
}


static void
workout_info_show (GtkWidget *widget, gpointer data)
{
  GtkWidget *window;
  GtkWidget *editor;
  KPDate date;

  date.d = 31;
  date.m = 10;
  date.y = 2004;

  window = gtk_window_new (GTK_WINDOW_POPUP);

  editor = kp_workout_editor_new (&date, NULL);
  gtk_container_add (GTK_CONTAINER (window), editor);
  
  gtk_widget_show (window);
  gtk_widget_show (editor);
}


 
static gboolean
update_clock (KPPlugin *plugin)
{
  gchar buf[255];
  struct tm *tm_ptr;
  time_t tm;
 
  tm = time (NULL);
  tm_ptr = localtime (&tm);
  strftime (buf, sizeof(buf)-1, "%H:%M:%S", (const struct tm *) tm_ptr);

  if (!clock_label)
    return FALSE;
  
  gtk_label_set_text (GTK_LABEL (clock_label), buf); 
 
  return TRUE;
}

static void
test_contexts (void)
{
  kp_context_add (KP_CONTEXT_WORKOUT, "foo",
                  G_CALLBACK (workout_info_show),
                  GINT_TO_POINTER (23),
                  "runner.xpm");
}

static void
test_clock_in_statusbar (KPPlugin *plugin)
{
  bar = kp_main_window_get_status_bar ();

  g_timeout_add (1000, (GSourceFunc) update_clock, plugin);

  clock_label = gtk_label_new ("");
  gtk_box_pack_end (GTK_BOX (bar), clock_label, FALSE, TRUE, 0);
  gtk_widget_show (clock_label);

  /* Update the clock manually first time to prevent 1 sec delay */
  update_clock (plugin);
}

static gboolean
plugin_load(KPPlugin *plugin)
{
  /* Already loaded. */
  if (item)
    return TRUE;

  test_menubar ();
  test_export_menu ();
  test_import_menu ();
  test_contexts ();
  test_clock_in_statusbar (plugin);
 
  return TRUE;
}

static void
remove_item (GtkWidget *item)
{
  gtk_container_remove (GTK_CONTAINER (gtk_widget_get_parent (item)), item);
}

static gboolean
plugin_unload(KPPlugin *plugin)
{
  kp_debug("simple plugin unloaded.\n");

  remove_item (clock_label);
  remove_item (mi_test);
  remove_item (item);
  
  item = NULL;
  mi_test = NULL;
  
  return TRUE;
}

static KPPluginInfo info =
{
  1,                                                /**< api_version    */
  "simple",                                         /**< id             */
  N_("Simple Plugin"),                              /**< name           */
  VERSION,                                          /**< version        */
  N_("Tests to see that most things are working."),
  N_("Tests to see that most things are working."),
  "Ville Kangas <ville@mirjami.net>",               /**< author         */
  "http://mirjami.net/~ville/kipina",               /**< homepage       */
  "clock",                                          /**< requires       */
  plugin_load,                                      /**< load           */
  plugin_unload,                                    /**< unload         */
  NULL,                                             /**< destroy        */
};

static void
init_plugin(KPPlugin *plugin)
{
}

KP_PLUGIN_INIT("simple", init_plugin, info)
