package kissme.vm.loaders;

import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;

import java.io.InputStream;
import java.io.FileInputStream;
import java.io.File;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipException;

public class FileClassLoader {

  private static String fileSeparator;

  public static byte[] getClassData(String className, String loaderPath) 
  {
    if (fileSeparator == null) {
      fileSeparator = System.getProperty("file.separator");
    }
    
    String pathName = loaderPath.endsWith(fileSeparator) ?
      (loaderPath + className + ".class") :
      (loaderPath + fileSeparator + className + ".class");
    File classFile = new File(pathName);
    if (!classFile.exists()) {
      return null;
    }
    long fileSize = classFile.length();
    if (fileSize == 0) {
      throw new InternalError("Class file is empty: " + classFile);
    }
    else if (fileSize > Integer.MAX_VALUE) {
      throw new InternalError("Class file is too big: " + classFile);
    }
    
    FileInputStream is = null;
    try {
      is = new FileInputStream(classFile);
      byte[] classData = new byte[(int) fileSize];
      int pos = 0;
      int nosRead;
      while (pos < fileSize && 
	     (nosRead = is.read(classData, pos, (int)(fileSize - pos))) > 0) {
	pos += nosRead;
      }
      if (pos < fileSize) {
	throw new InternalError("Premature EOF while reading class data");
      }
      return classData;
    }
    catch (IOException ex) {
      InternalError ex2 =
	new InternalError("IO error while reading class file: " + classFile);
      ex2.initCause(ex);
      throw ex2;
    }
    finally {
      if (is != null) {
	try {
	  is.close();
	}
	catch (IOException ex) { 
	  /* ignore it */
	}
      }
    }
  }

  public static String getResourceUrl(String resource, String loaderPath)
  {
    if (fileSeparator == null) {
      fileSeparator = System.getProperty("file.separator");
    }
    String pathName = loaderPath.endsWith(fileSeparator) ?
      (loaderPath + resource) :
      (loaderPath + fileSeparator + resource);
    
    File resourceFile = new File(pathName);
    if (resourceFile.exists()) {
      return "file:" + pathName;
    }
    else {
      return null;
    }
  }
}
