package hitme.basic.lang;

/**
 * Testing thread lifecycle, sleep and isalive
 */
public class Threads extends hitme.HitMeTest implements Runnable
{
  private int counter = 0;

  public String describe() {
    return "thread lifecycle test";
  }

  public void run() { 
    try {
      for (int i = 0; i < 5; i++) {
	Thread.sleep(1000);
	counter++;
      }
    }
    catch (InterruptedException ex) {
      err(ex);
    }
  }
  
  public void test() {
    Thread t = new Thread(this);
    check(!t.isAlive(), "thread shouldn't be alive yet");
    t.start();
    check(t.isAlive(), "thread should be alive now");
    try {
      Thread.sleep(7000);
    }
    catch (InterruptedException ex) {
      err(ex);
    }
    check(!t.isAlive(), "thread should be dead now");
    check(counter == 5, "thread did not wake up 5 times");
  }
}
