#include "config.h"
/*
 * native stuff for java.lang.UnixProcess
 *
 */

#include <sys/types.h>
#include <sys/wait.h>
       
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include "vm/jni.h"

#ifdef DLOPEN
#include <dlfcn.h>
#endif


#ifdef DEBUG
#include <stdio.h>
#endif

#include "vm/jni.h"
#ifdef PERSIST
#include "vm/rpot.h"
#endif


/* Wait for the process to finish */

jint java_lang_UnixProcess_waitFor(
JNIEnv* env,
jobject obj)
{
    jclass unixPClass = (*env)->GetObjectClass( env, obj );
    jfieldID fid = (*env)->GetFieldID(env, unixPClass, "pid" , "I");

    int status = 0;

    int pid = (*env)->GetIntField(env, obj, fid);

    int options = 0;

    int result = waitpid(pid, &status, options);
    
    if(result)
	{
	    if(WIFEXITED(status))
		return WEXITSTATUS(status);
	}
    else
	{
	    perror("Waiting for child");
	    return 0;
	}
    return 0;
}

