#include <pthread.h>
#include "storemanager.h"
#include "store_communication.h"


/* lock.h

   Describes functions implemented by the locking service. Based on Li and Hudak's paper on "Memory Coherence in Shared Virtual Memory Systems". (from page 235, section 4.4)
*/

/* Attempts to lock an object for reading, will fetch the object if we do not own it or have a fresh copy*/

int LOCK_SERVICE_lock_for_read( long long address, void* buf, int buf_len, struct thread_context* context);
int LOCK_SERVICE_unlock_for_read( long long address, struct thread_context* context);

/* Services someone else's request for a page, if we are not the owner we forward the request to the probable owner */

int LOCK_SERVICE_service_read_request( long long address);

/* Locks a page so that we can write to it */

int LOCK_SERVICE_lock_for_write( long long address, void* data, int data_len);

int LOCK_SERVICE_lock_for_overwrite( long long address, void* data, int data_len, struct thread_context* context);

/* Services someone else's request to write to a page, if we are not the owner we forward the request to the probable owner */

int LOCK_SERVICE_service_write_request( long long address );


/*
   The idea is to implement a distributed lock service, mainly aiming to minimize the number of messages needed to lock a page, and ensuring quick access once a lock has been obtained on a page. 

I describe here the algorithms used for various parts of the process:

p refers to the page being sought, ptable is a table of pages with various information for each

Read fault handler:

lock( ptable[p].lock )
ask ptable[p].prob_owner for read access to p
ptable[p].prob_owner := reply_node (not necessarily the one we contacted)
ptable[p].access := read;
unlock( ptable[p].lock )

Read Server:
if I am owner then BEGIN
lock(ptable[p].lock)
ptable[p].copy_set := ptable[p].copy_set union { request_node }
ptable[p].access = read;
ptable[p].counter := ptable[p].counter + 1;
send p and ptable[p].copy_set
ptable[p].copy_set := {}
ptable[p].prob_owner = request_node;
unlock( ptable[p].lock );
END
ELSE BEGIN

forward request to ptable[p].prob_owner;
ptable[p].prob_owner := request_node;
END

Write fault handler:

lock (ptable[p].lock);
ask ptable[p].prob_owner for write access to p;
invalidate(p);
ptable[p].prob_owner = self;
ptable[p].access = write;
ptable[p].copy_set = {};
unlock( ptable[p].lock);

Write server

If I am owner THEN
lock (ptable[p].lock)
ptable[p].access := nil;
send p, ptable[p].copy`set and ptable[p].counter;
ptable[p].prob_owner = request_node;
unlock ( ptable[p].lock );
END
ELSE BEGIN
forward request to ptable[p].prob_owner;
ptable[p].prob_owner := request_node;
END;

Invalidate(p)
 if( ptable[p].counter > L)
 OR ( size(ptable[p].copy_set > L) THEN
 broadcast invalidation;
ELSE
invalidate according to ptable[p].copy_set:

Invalidate SErver

ptable[p].access := nil;
ptable[p].prob_owner = request_node;

 */






