/* Routines to manage the young heap */

#include "config.h"


#include "vm/garbage/public_methods.h"
#include "vm/garbage/bitfield.h"
#include "vm/garbage/tlh.h"
#include "vm/garbage/youngheap.h"

int YOUNGHEAP_Init(tAllocatorHeap* heap)
{
  //We start off making the entire heap an array of free thread-local-heaps
  int numTLH = 0;
  tThreadLocalHeap* iter;

  numTLH = heap->i32YoungHeapSize / sizeof(tThreadLocalHeap);
  iter = ( ((tThreadLocalHeap*) heap->pi32YoungHeap));
    
  while(--numTLH > 0)
  {
    int i;
    iter->lock_word = 0;
    iter->next = (iter + 1);

    //We mark the entire tlh as unused 
    for(i = 0; i < (sizeof(tThreadLocalHeap) / sizeof(int32)); i++)
    {
      YOUNG_CLEAR_BIT( (((int32*) iter) - heap->pi32YoungHeap) + i);
    }
    iter++;
  }
  iter->next = NULL;

  assert( (void*) (iter + 1) <= (void*) (heap->pi32OldHeap));
  return 0;
}


int YOUNGHEAP_ISHANDLE(tAllocatorHeap* heap, tOBREF h)
{


  return 0;
}
