/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme/teaseme project, which in turn is part of 
 * the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Contains the code for the invoke_???????? opcodes  */


#ifdef not_def
{
  {
    {
#endif
    case invokevirtual:
      {
	int16     i16Temp;
	tMethod*  pstMethodTemp;
	tMethod*  pstMethod;
	int32     i32NativeRet;
	int tmpNumArgs;
	
#ifdef GARBAGE2
	GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
#endif
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
#ifdef DEBUG
	assert(CONSTTAG(pstCurrClass->pstClass, i16Temp) == CONSTANT_Methodref);
#endif
	pstMethodTemp = CONSTGET_MethodVirtual(env, pstCurrClass, i16Temp);

	/* Get / resolve the method in the current class.  We use it to
	   find out how many args the method takes ... so that we can
	   locate the target object.  We also use it to find the method's
	   virtual table index.  (But see below) */
	
        if (pstMethodTemp == NULL) {
	  /* An exception was thrown while resolving the method */
	  tOBREF pstExOb = JNI_getJNIData(sys_current_thread())->pstException;
	  JNI_getJNIData(sys_current_thread())->pstException = NULL;
	  SAVEENV();
	  pstCurrFrame = CatchExternalException(env, pstCurrFrame, pstExOb);
          LOADENV();
	  break;
	}

	if ((pstMethodTemp->u16AccessFlags & ACC_STATIC)) {
	  SAVEENV();
	  pstCurrFrame = 
	    ThrowClassChangeError(env, pstCurrFrame, 
				  "Method %s.%s%s is not meant to be static", 
				  pstMethodTemp->pstClass->uidName,
				  pstMethodTemp->uidName, 
				  pstMethodTemp->uidSignature);
	  LOADENV();
	  break;
	}
	
	tmpNumArgs = pstMethodTemp->u16ArgSize;
	
	if ((tOBREF) *(optop - tmpNumArgs + 1) == NULL) {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	  break;
        }
	
	assert(DEREF((tOBREF) *(optop - tmpNumArgs + 1)) != 0);
	assert(DEREF((tOBREF) *(optop - tmpNumArgs + 1))->pstType);
	assert(DEREF((tOBREF) *(optop - tmpNumArgs + 1))->pstType->pstClass);
	assert(DEREF((tOBREF) *(optop - tmpNumArgs + 1))->pstType->
	       pstClass->ppstVT);

	assert(pstMethodTemp->u16VTIndex != (uint16) -1);

	/* use the reference to find the correct method in the virtual
	   table of the object that is on the stack */
	
	pstMethod = DEREF((tOBREF) *(optop - tmpNumArgs + 1))->
	  pstType->pstClass->ppstVT[pstMethodTemp->u16VTIndex];
	
	assert(pstMethod);
	assert(strcmp(pstMethod->uidName, pstMethodTemp->uidName) == 0);
	assert(strcmp(pstMethod->uidSignature, 
		      pstMethodTemp->uidSignature) == 0);

	if (pstMethod->u16AccessFlags & ACC_STATIC) {
	  SAVEENV();
	  pstCurrFrame = 
	    ThrowClassChangeError(env, pstCurrFrame, 
				  "method %s.%s%s is not meant to be static", 
				  pstMethod->pstClass->uidName, 
				  pstMethod->uidName, 
				  pstMethod->uidSignature);
	  LOADENV();
	  break;
	}
	
#ifdef RESURRECT_QUICK
	/* Replace the instruction with the _quick alternative */
	pbPC[-3] = invokevirtual_quick;
	pbPC[-2] = pstMethod->u16VTIndex;
	pbPC[-1] = tmpNumArgs; /*number of args*/
#endif
	
	
	if (pstMethod->u16AccessFlags & ACC_NATIVE) {
	  traceCall("native %s.%s (at %s: %i)", 
		    pstMethod->pstClass->uidName, pstMethod->uidName, 
		    pstCurrClass->uidName,
		    INTERP_FigureOutLineNumber(pstCurrFrame));
	  
	  SAVEENV();
	  i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethod);
	  if (i32NativeRet == -1) {
	    pstCurrFrame = CatchException(env, pstCurrFrame);
	  }
	  LOADENV();
	}
	else {
	  traceCall("%s.%s (at %s: %i)", pstMethod->pstClass->uidName, 
		    pstMethod->uidName, pstCurrClass->uidName,
		    INTERP_FigureOutLineNumber(pstCurrFrame));
	  
	  SAVEENV();
	  pstCurrFrame = 
	    PushStackFrame(pstMethod, 
			   (tOBREF) *(optop - tmpNumArgs + 1),
			   pstCurrFrame);
	  LOADENV();
	  if (pstCurrFrame->pstCurrMethod->u16AccessFlags & ACC_SYNCHRONISED) {
	    traceLock("Entering monitor on object %p (%s) from thread %x", 
		      pstCurrFrame->pstCurrObject, 
		      DEREF(pstCurrFrame->pstCurrObject)->pstType->uidName,
		      (int) pthread_self());
	    
	    if (pstCurrFrame->pstCurrObject == NULL) {
	      SAVEENV();
	      pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	      LOADENV();
	    }
	    else {
	      THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
	    }
	  }
        }
	break;
      } //end invoke_virtual
      
#ifdef RESURRECT_QUICK
    case invokevirtual_quick:
      {
	int16         i16VTIndex;
	int32         i32NativeRet;
	int16         i16ArgSize;
	tClassLoaderTuple*       pstClassTemp;
	tMethod*	    pstMethodTemp;
	
#ifdef GARBAGE2
	GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
#endif
	
	/* ### watch out for sign extension!!!! */
	i16VTIndex = (*pbPC++);  /* VT index */
	i16ArgSize = (*pbPC++);  /* no. args */
	
	
	
	if ((tOBREF) *(optop + 1 - i16ArgSize) == NULL) {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	  
	  //should we break here?
	  break;
	}
	
	/* Get the method from the VT */
	assert(GARBAGE_InHeap(env, (tOBREF) *(optop + 1 - i16ArgSize)) == 1);
	
	pstClassTemp = (DEREF((tOBREF) (*(optop + 1 - i16ArgSize))))->pstType;
	
#ifdef DEBUG_CLASS_FOR_GC
	assert(pstClassTemp->magic1 == MAGIC1);
	assert(pstClassTemp->magic2 == MAGIC2);
	assert(pstClassTemp->magic3 == MAGIC3);
#endif
	
	pstMethodTemp = pstClassTemp->pstClass->ppstVT[i16VTIndex];
	
	traceCall("q%s.%s (at %s: %i)", pstMethodTemp->pstClass->uidName, 
		  pstMethodTemp->uidName, pstCurrClass->uidName,
		  INTERP_FigureOutLineNumber(pstCurrFrame));
	
	/* Get the current class from the method */
	pstClassTemp = pstMethodTemp->pstClass;
	
	if (pstMethodTemp->u16AccessFlags & ACC_NATIVE) {
	  SAVEENV();
	  i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	  if (i32NativeRet == -1) {
	    pstCurrFrame = CatchException(env, pstCurrFrame);
	  }
	  LOADENV();
	}
	else {
	  SAVEENV();
	  pstCurrFrame = 
	    PushStackFrame(pstMethodTemp, 
			   (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1),
			   pstCurrFrame);
	  LOADENV();
	  
#ifdef DEBUG_TRACE
	  iIndent++;
#endif
	  
	  if (iMultiThread) {
	    if (pstCurrFrame->pstCurrMethod->u16AccessFlags &
		ACC_SYNCHRONISED) {
	      if (pstCurrFrame->pstCurrObject == NULL) {
		SAVEENV();
		pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
		LOADENV();
	      }
	      else {
		THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
	      }
	    }
	  }
	  else
	    {
#ifdef MDEBUG
	      eprintf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
	    }
	}
	break;
      }
#endif /* RES_QUICK */
      
    case invokespecial:  // AKA invokenonvirtual
      {
	int16         i16Temp;
	tMethod*      pstMethodTemp;
	int32         i32NativeRet;
#ifdef QUICK2
	int16         i16CurrCTIndex;
	int16         i16MethodIndex;
	tClass*       pstClassTemp;
#endif
	
#ifdef GARBAGE2
	GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
#endif
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
#ifdef DEBUG
	assert(CONSTTAG(pstCurrClass->pstClass, i16Temp) == CONSTANT_Methodref);
#endif
	
	pstMethodTemp = CONSTGET_MethodNonVirtual(env, pstCurrClass, i16Temp);
	
	if (!(pstMethodTemp)) {
	  /* An exception was thrown while resolving the method */
	  tOBREF pstExOb = JNI_getJNIData(sys_current_thread())->pstException;
	  JNI_getJNIData(sys_current_thread())->pstException = NULL;
	  SAVEENV();
	  pstCurrFrame = CatchExternalException(env, pstCurrFrame, pstExOb);
          LOADENV();
	  break;
	}
	
	if (pstMethodTemp->u16AccessFlags & ACC_STATIC) {
	  SAVEENV();
	  pstCurrFrame =
	    ThrowClassChangeError(env, pstCurrFrame, 
				  "method %s.%s%s is meant to be static",
				  pstMethodTemp->pstClass->uidName, 
				  pstMethodTemp->uidName,
				  pstMethodTemp->uidSignature);
	  LOADENV();
	  break;
	}
	
#ifdef RESURRECT_QUICK
#ifdef QUICK2
	pstClassTemp = pstMethodTemp->pstClass;
	
	/* Search for it in the Class Table */
	for (i16CurrCTIndex = 0; 
	     i16CurrCTIndex < pstCurrClass->u16CTSize;
	     i16CurrCTIndex++) {
	  if (pstCurrClass->ppstCT[i16CurrCTIndex] == pstClassTemp) {
	    break;
	  }
        }
	/* If we still haven't found it, then add it to the CT - but
           only up to 256 */
	if ((i16CurrCTIndex == pstCurrClass->u16CTSize) && 
	    (i16CurrCTIndex < 256)) {
  	  /* Entry is not yet valid - make a new entry in the CT */
	  pstCurrClass->ppstCT[pstCurrClass->u16CTSize++] = pstClassTemp;
        }
#ifndef USEOSKIT
	assert(pstClassTemp == pstCurrClass->ppstCT[i16CurrCTIndex]);
#endif
	/* We now have everything we need - pstMethodTemp will tell us where
	   it is in the methods array, and i16CurrCTIndex is the CT index of
	   the class */
	i16MethodIndex = (pstMethodTemp - pstClassTemp->pstMethods);
	/* so now create a _quick instruction */
	assert(i16MethodIndex < 256);
	assert(i16CurrCTIndex < 256);
	
	pbPC[-2] = i16MethodIndex;  /* method index */
	/* check to see if class is current class */
	if (pstClassTemp == pstCurrClass) {
	  pbPC[-3] = invokenonvirtualcurrclass_quick;
        }
	else {
	  pbPC[-3] = invokenonvirtual_quick;
	  pbPC[-1] = i16CurrCTIndex;
        }
#else
	/* overwrite instruction with _quick instruction */
	pbPC[-3] = invokespecial_quick;
	/* The CP slot was automatically overwritten with pstMethodTemp */
	/* CONSTSET(pstCurrClass, i16Temp, pstMethodTemp);*/
#endif /* QUICK2 */
#endif /* RES_QUICK */
	
	if ((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1) == NULL) {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
        }
	
	if (pstMethodTemp->u16AccessFlags & ACC_NATIVE) {
	  SAVEENV();
	  i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	  if (i32NativeRet == -1) {
	    pstCurrFrame = CatchException(env, pstCurrFrame);
	  }
	  LOADENV();
        }
	else { //not native
	  SAVEENV();
	  pstCurrFrame = 
	    PushStackFrame(pstMethodTemp, 
			   (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1),
			   pstCurrFrame);
	  LOADENV();
	  if (iMultiThread) {
	    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & 
		ACC_SYNCHRONISED) {
	      if (pstCurrFrame->pstCurrObject == NULL) {
		SAVEENV();
		pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
		LOADENV();
	      }
	      else {
		THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
	      }
	    }
	  }
	  else
	    {
#ifdef MDEBUG
	      eprintf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
	    }
        }
	break;
      }
      
#ifdef RESURRECT_QUICK
#ifdef QUICK2
    case invokenonvirtualcurrclass_quick:
      {
	int32        i32NativeRet;
	int16        i16MethodIndex;
	tMethod*     pstMethodTemp;
	
	i16MethodIndex = (*pbPC++);    /* method index */
	pbPC++;
	
	pstMethodTemp = &(pstCurrClass->pstMethods[i16MethodIndex]);
	
	if ((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1) == NULL) {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
        }
	
	if (pstMethodTemp->u16AccessFlags & ACC_NATIVE) {
	  SAVEENV();
	  i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	  if (i32NativeRet == -1) {
	    pstCurrFrame = CatchException(env,pstCurrFrame);
	  }
	  LOADENV();
        }
	else {
	  SAVEENV();
	  pstCurrFrame =
	    PushStackFrame(pstMethodTemp, 
			   (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1), 
			   pstCurrFrame);
	  LOADENV();
	  
#ifdef DEBUG_TRACE
	  iIndent++;
#endif
	  
	  if (iMultiThread) {
	    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & 
		ACC_SYNCHRONISED) {
	      if (pstCurrFrame->pstCurrObject == NULL) {
		SAVEENV();
		pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
		LOADENV();
	      }
	      else {
		THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
	      }
	    }
	  }
	  else {
#ifdef MDEBUG
	    eprintf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
	  }
        }
	break;
      }
      
    case invokenonvirtual_quick:
      {
	int32        i32NativeRet;
	int16        i16MethodIndex;
	int16        i16ClassIndex;
	tClass*      pstClassTemp;
	tMethod* pstMethodTemp;
	
#ifdef GARBAGE2
	GARBAGE_EnterGCPoint(pthread_self());
#endif
	
	i16MethodIndex = (*pbPC++);    /* method index */
	i16ClassIndex = (*pbPC++);    /* class table index */
	
	pstClassTemp = pstCurrClass->ppstCT[i16ClassIndex];
	pstMethodTemp = &(pstClassTemp->pstMethods[i16MethodIndex]);
	
	if ((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1) == NULL) {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
        }
	
	if (pstMethodTemp->u16AccessFlags & ACC_NATIVE) {
	  SAVEENV();
	  i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	  if (i32NativeRet == -1) {
	    pstCurrFrame = CatchException(env,pstCurrFrame);
	  }
	  LOADENV();
        }
	else {
	  traceCall("%s.%s (at %s: %i)", pstMethodTemp->pstClass->uidName,
		    pstMethodTemp->uidName, pstCurrClass->uidName,
		    INTERP_FigureOutLineNumber(pstCurrFrame));
	  
	  SAVEENV();
	  pstCurrFrame = 
	    PushStackFrame(pstMethodTemp, 
			   (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1), 
			   pstCurrFrame);
	  LOADENV();
	  
#ifdef DEBUG_TRACE
	  iIndent++;
#endif
	  
	  if (iMultiThread) {
	    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & 
		ACC_SYNCHRONISED) {
	      if (pstCurrFrame->pstCurrObject == NULL) {
		SAVEENV();
		pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
		LOADENV();
	      }
	      else {
		THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
	      }
	    }
	  }
	  else
	    {
#ifdef MDEBUG
	      eprintf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
	    }
        }
	break;
      }
#else
      //Here we go
    case invokespecial_quick:
      {
	int16        i16Temp;
	int32        i32NativeRet;
	tMethod* pstMethodTemp;
	
#ifdef GARBAGE2
	GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
#endif
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
	pstMethodTemp = (tMethod*) CONSTGET(pstCurrClass->pstClass, i16Temp);
	
	if ((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1) == NULL) {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
        }
	
	if (pstMethodTemp->u16AccessFlags & ACC_NATIVE) {
	  SAVEENV();
	  i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	  if (i32NativeRet == -1) {
	    pstCurrFrame = CatchException(env,pstCurrFrame);
	  }
	  LOADENV();
        }
	else {
	  SAVEENV();
	  pstCurrFrame = 
	    PushStackFrame(pstMethodTemp, 
			   (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1),
			   pstCurrFrame);
	  LOADENV();
	  
#ifdef DEBUG_TRACE
	  iIndent++;
#endif
	  if (iMultiThread) {
	    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & 
		ACC_SYNCHRONISED) {
	      if (pstCurrFrame->pstCurrObject == NULL) {
		SAVEENV();
		pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
		LOADENV();
	      }
	      else {
		THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
	      }
	    }
	  }
	  else {
#ifdef MDEBUG
	    eprintf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
	  }
        }
	break;
      }
#endif /* QUICK2 */
#endif /* RES_QUICK */
      
    case invokestatic:
      {
	int16         i16Temp;
	tMethod*      pstMethodTemp;
	int32         i32NativeRet;
#ifdef QUICK2
	int16         i16CurrCTIndex;
	int16         i16MethodIndex;
	tClass*       pstClassTemp;
#endif
	
#ifdef GARBAGE2
	GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
#endif
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
#ifdef DEBUG
	assert(CONSTTAG(pstCurrClass->pstClass, i16Temp) == CONSTANT_Methodref);
#endif
	
	pstMethodTemp = CONSTGET_MethodStatic(env, pstCurrClass, i16Temp);
	
	if (!(pstMethodTemp)) {
	  /* An exception was thrown while resolving the method */
	  tOBREF pstExOb = JNI_getJNIData(sys_current_thread())->pstException;
	  JNI_getJNIData(sys_current_thread())->pstException = NULL;
	  SAVEENV();
	  pstCurrFrame = CatchExternalException(env, pstCurrFrame, pstExOb);
          LOADENV();
	  break;
	}
	
	if (!(pstMethodTemp->u16AccessFlags & ACC_STATIC)) {
	  SAVEENV();
	  pstCurrFrame = 
	    ThrowClassChangeError(env, pstCurrFrame,
				  "method %s.%s%s is meant to be static",
				  pstMethodTemp->pstClass->uidName,
				  pstMethodTemp->uidName,
				  pstMethodTemp->uidSignature);
	  LOADENV();
	  break;
	}
	
#ifdef DEBUG
	assert(pstMethodTemp->u16AccessFlags & ACC_STATIC);
#endif
	
	traceCall("~%s.%s (at %s: %i)", pstMethodTemp->pstClass->uidName,
		  pstMethodTemp->uidName, pstCurrClass->uidName,
		  INTERP_FigureOutLineNumber(pstCurrFrame));
	
#ifdef QUICK
#ifdef QUICK2
	pstClassTemp = pstMethodTemp->pstClass;
	
	/* Search for it in the CT */
	for (i16CurrCTIndex = 0; 
	     i16CurrCTIndex < pstCurrClass->u16CTSize;
	     i16CurrCTIndex++) {
	  if (pstCurrClass->ppstCT[i16CurrCTIndex] == pstClassTemp) {
	    break;
	  }
	}
	/* If we still haven't found it, then add it to the CT - but
           only up to 256 */
	if ((i16CurrCTIndex == pstCurrClass->u16CTSize) && 
	    (i16CurrCTIndex < 256)) {
	  /* Entry is not yet valid - make a new entry in the CT */
	  pstCurrClass->ppstCT[pstCurrClass->u16CTSize++] = pstClassTemp;
	}
	assert(pstClassTemp == pstCurrClass->ppstCT[i16CurrCTIndex]);
	
	/* We now have everything we need - pstMethodTemp will tell us
       where it is in the methods array, and i16CurrCTIndex is the CT
       index of the class */
	i16MethodIndex = (pstMethodTemp - pstClassTemp->pstMethods);
	/* so now create a _quick instruction */
	assert(i16MethodIndex < 256);
	assert(i16CurrCTIndex < 256);
	
	pbPC[-2] = i16MethodIndex;  /* method index */
	/* check to see if class is current class */
	if (pstClassTemp == pstCurrClass) {
	  pbPC[-3] = invokestaticcurrclass_quick;
        }
	else {
	  pbPC[-3] = invokestatic_quick;
	  pbPC[-1] = i16CurrCTIndex;
        }
#else
	pbPC[-3] = invokestatic_quick;
	/*        CONSTSET(pstCurrClass, i16Temp, pstMethodTemp);*/
#endif /* QUICK2 */
#endif /* QUICK */
	
	// XXX - I think the following is redundant ... we've already 
	// checked that pstMethodTemp is non-NULL.  Besides the exception
	// throwing is incorrect:  scc 2003-02-07
	if (pstMethodTemp == NULL) {
	  tOBREF pstExOb;
	  
	  pstExOb = JNI_getJNIData(sys_current_thread())->pstException;
	  if (pstExOb) {
	    /* pstCurrFrame->pstException = pstExOb; XXX is this necessary ? */
	    SAVEENV();
	    pstCurrFrame = CatchExceptionHelper(env, pstCurrFrame, pstExOb); 
	    LOADENV();
	    break;
	  }
	  else {
	    SAVEENV();
	    pstCurrFrame = 
	      ThrowNoSuchMethodError(env, pstCurrFrame,
				     "cannot find a static method for "
				     "this class");
	    LOADENV();
	    break;
	  }
	}

	if (pstMethodTemp->u16AccessFlags & ACC_NATIVE) {
	  traceCall("~native %s.%s (at %s: %i)",
		    pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName, 
		    pstCurrClass->uidName,
		    INTERP_FigureOutLineNumber(pstCurrFrame));
	  SAVEENV();
	  i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);

	  if (i32NativeRet == -1) {	    
#ifdef DEBUG_EXCEPTIONS
	    eprintf("INTERP: Calling catch exception from within invokestatic\n");
	    eprintf("INTERP: The method is ~%s.%s\n", 
		    pstMethodTemp->pstClass->uidName, pstMethodTemp->uidName);
	    eprintf("INTERP: The current frame is %x, with exception %x\n",
		    pstCurrFrame, pstCurrFrame->pstException); 
	    
#endif
	    pstCurrFrame = CatchException(env, pstCurrFrame);
	  }
	  LOADENV();
        }
	else {
	  SAVEENV();
	  pstCurrFrame = PushStackFrame(pstMethodTemp, NULL, pstCurrFrame);
	  LOADENV();
	  if (iMultiThread) {
	    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & 
		ACC_SYNCHRONISED) {
	      jclass sclass = CLASS_GetClassFromStruct(env, pstCurrFrame->pstCurrClass);
	      assert(sclass);
	      THREAD_SynchroniseEnter(sclass);
	    }
	  }
	  else {
#ifdef MDEBUG
	    eprintf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
	  }
        }
	break;
      }
      
#ifdef QUICK
#ifdef QUICK2
    case invokestaticcurrclass_quick:
      {
	int32         i32NativeRet;
	int16         i16MethodIndex;
	tMethod*	    pstMethodTemp;
	
	i16MethodIndex = (*pbPC++);    /* method index */
	pbPC++;
	
	pstMethodTemp = &(pstCurrClass->pstMethods[i16MethodIndex]);
	
	if (pstMethodTemp->u16AccessFlags & ACC_NATIVE) {
	  SAVEENV();
	  i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	  if (i32NativeRet == -1) {
	    pstCurrFrame = CatchException(env, pstCurrFrame);
	  }
	  LOADENV();
	}
	else {
	  SAVEENV();
	  pstCurrFrame = PushStackFrame(pstMethodTemp, NULL, pstCurrFrame);
	  LOADENV();
	  
	  if (iMultiThread) {
	    if (pstCurrFrame->pstCurrMethod->u16AccessFlags &
		ACC_SYNCHRONISED) {
	      if (pstCurrFrame->pstCurrObject == NULL) {
		SAVEENV();
		pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
		LOADENV();
	      }
	      else {
		THREAD_SynchroniseEnter(CLASS_GetClassFromStruct(env, pstCurrFrame->pstCurrClass));
	      }
	    }
	  }
	  else {
#ifdef MDEBUG
	    eprintf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
	  }
	  
#ifdef DEBUG_TRACE
	  iIndent++;
#endif
        }
	break;
      }
      
    case invokestatic_quick:
      {
	int32         i32NativeRet;
	int16         i16MethodIndex;
	int16         i16ClassIndex;
	tClass*       pstClassTemp;
	tMethod*      pstMethodTemp;
	
	i16MethodIndex = (*pbPC++);    /* method index */
	i16ClassIndex = (*pbPC++);    /* class table index */
	
	pstClassTemp = pstCurrClass->ppstCT[i16ClassIndex];
	pstMethodTemp = &pstClassTemp->pstMethods[i16MethodIndex];
	
	if (pstMethodTemp->u16AccessFlags & ACC_NATIVE) {
	  SAVEENV();
	  i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	  if (i32NativeRet == -1) {
	    pstCurrFrame = CatchException(env, pstCurrFrame);
	  }
	  LOADENV();
	}
	else {
	  SAVEENV();
	  pstCurrFrame = PushStackFrame(pstMethodTemp, NULL, pstCurrFrame);
	  LOADENV();
	  
	  if (iMultiThread) {
	    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & 
		ACC_SYNCHRONISED) {
	      if (pstCurrFrame->pstCurrObject == NULL) {
		SAVEENV();
		pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
		LOADENV();
	      }
	      else {
		THREAD_SynchroniseEnter(CLASS_GetClassFromStruct(env, pstCurrFrame->pstCurrClass));
	      }
	    }
	  }
	  else
	    {
#ifdef MDEBUG
	      eprintf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
	    }
	  
#ifdef DEBUG_TRACE
	  iIndent++;
#endif
        }
	break;
      }
      
#else
      
    case invokestatic_quick:
      {
	int16         i16Temp;
	int32         i32NativeRet;
	tMethod*	pstMethodTemp;
	
#ifdef GARBAGE2
	GARBAGE_EnterGCPoint(pthread_self());
#endif
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
	pstMethodTemp = (tMethod*) CONSTGET(pstCurrClass, i16Temp);
	
	if (pstMethodTemp->u16AccessFlags & ACC_NATIVE) {
	  SAVEENV();
	  i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	  if (i32NativeRet == -1) {
	    pstCurrFrame = CatchException(env, pstCurrFrame);
	  }
	  LOADENV();
	}
	else {
	  SAVEENV();
	  pstCurrFrame = PushStackFrame(pstMethodTemp, NULL, pstCurrFrame);
	  LOADENV();
	  
	  if (iMultiThread) {
	    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & 
		ACC_SYNCHRONISED) {
	      if(pstCurrFrame->pstCurrObject == NULL) {
		SAVEENV();
		pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
		LOADENV();
	      }
	      else {
		THREAD_SynchroniseEnter(CLASS_GetClassFromStruct(env, pstCurrFrame->pstCurrClass));
	      }
	    }
	  }
	  else {
#ifdef MDEBUG
	    eprintf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
	  }
	  
#ifdef DEBUG_TRACE
	  iIndent++;
#endif
        }
	break;
      }
#endif /* QUICK2 */
#endif /* QUICK */
      
    case invokeinterface:
      {
#ifdef TEASEME
	int	     iIsIPC;    //is this an ipc call?
	tAllocatorHeap*	     pstNewHeap = NULL;//heap for new context
#endif
	
	int16        i16Temp;
	tMethod*     pstRightMethod = NULL;
	tMethod*     pstFirstMethod;
	tClassLoaderTuple*      pstClassTemp;
	int32        i32NativeRet;
	uint16       u16ArgLen;
	uint16       u16VTGuess;
	
#ifdef GARBAGE2
	GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
#endif
	
#ifdef TEASEME
	iIsIPC = 0;    
#endif
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
	assert(CONSTTAG(pstCurrClass->pstClass, i16Temp) ==
	       CONSTANT_InterfaceMethodref);
	
	/* get argument length */
	u16ArgLen = (*pbPC++);
	pbPC++;             /* reserved field according to spec */
	
	if ((tOBREF) *(optop - u16ArgLen + 1) == NULL) {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	  
	  break;
        }
	
        /* get method normally */
        pstFirstMethod = CONSTGET_MethodInterface(env, pstCurrClass,
						  i16Temp, optop, u16ArgLen);

	if (pstFirstMethod == NULL) {
	  /* An exception was thrown while resolving the method */
	  tOBREF pstExOb = JNI_getJNIData(sys_current_thread())->pstException;
	  JNI_getJNIData(sys_current_thread())->pstException = NULL;
	  SAVEENV();
	  pstCurrFrame = CatchExternalException(env, pstCurrFrame, pstExOb);
          LOADENV();
	  break;  
	}
	
	/* XXX figure out what to do here
	   if(!(pstFirstMethod->u16AccessFlags & ACC_INTERFACE)) {
	     SAVEENV();
	     pstCurrFrame = 
	       ThrowClassChange(env, pstCurrFrame,
	                        "method %s.%s%s is meant to be an interface",
				pstFirstMethod->pstClass->uidName, 
				pstFirstMethod->uidName, 
				pstFirstMethod->uidSignature);
	     LOADENV();
	     break;
	   }
	*/
	
        u16VTGuess = pstFirstMethod->u16VTIndex;
	
        pstClassTemp = DEREF((tOBREF) *(optop - u16ArgLen + 1))->pstType;
	
#ifdef TEASEME
	//Check if we have to do a context switch
	if (pstFirstMethod->u16AccessFlags & ACC_IPC_METHOD) {
	  tOBREF targetObject;
	  tClassLoaderTuple* baseClass;
#ifdef SHOW_CONTEXT_SWITCH
	  eprintf("doing context switch\n");
#endif
	  
	  // the target object must be an instance of
	  // "teaseme/system/ipc_interfaces/JOSServer"
	  targetObject = (tOBREF) *(optop - u16ArgLen + 1);
	  baseClass = 
	    CLASSFILE_FindOrLoad(env, 
				 "teaseme/system/ipc_interfaces/JOSServer", 
				 NULL); //~XXX fixpstClassType); 

	  if (INTERP_CheckCast(env, baseClass, pstClassTemp)) {
	    int i = 0;
	    int numArgs;
	    //We first extract the process pointer
	    tOBREF josProcess;
	    tField* field;
	    
	    field = CLASSFILE_InstFieldOffset(env, pstClassTemp, "process");
	    
	    //Now get the process object 
	    josProcess = (tOBREF) DEREF(targetObject)->
	      pi32Vars[field->u16Offset];
	    
	    if (josProcess == NULL) {
#ifdef SHOW_CONTEXT_SWITCH
	      eprintf("JOSProcess object was null in ipc_method\n");
#endif
	      SAVEENV();
	      pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	      LOADENV();
	      break;
	    }
	    field = CLASSFILE_InstFieldOffset(env, DEREF(josProcess)->pstType,
					      "_heap");
	    iIsIPC = 1;
	    
	    //now we have to extract the heap pointer from the targetObject
	    pstNewHeap = (void*) DEREF(josProcess)->pi32Vars[field->u16Offset];
	    
	    numArgs = CLASSFILE_CalcNumArguments(pstFirstMethod->uidSignature);
	    //Now create external references for all the non-primitive
	    //parameters
	    for (i = 1; i < numArgs; i++) { //we skip the first ref
	      int slotOffset;
	      int isRef = CLASSFILE_IsArgumentRef(pstFirstMethod->uidSignature,
						  i, &slotOffset);
	      assert((isRef == 0) || (isRef == 1));
	      if (isRef == 1) {
		tOBREF ref = (tOBREF) (optop - u16ArgLen + 1)[slotOffset];
		if (ref != NULL) {
#ifdef SHOW_CONTEXT_SWITCH
		  eprintf("Adding ref to %p (originating from %p)\n", 
			  ref, pstNewHeap);
#endif
		  JOSPROCESS_addExternalRef(pstCurrFrame->pstHeap, ref,
					    pstNewHeap);
		}
	      }
	    }
	  }
	  else {
	    //throw an exception or something
	    eprintf("******|||||||||||||************* error in ipc_call ************|||||||||||||||***********\n");
	  }
	}
	else {
#ifdef SHOW_CONTEXT_SWITCH
	  eprintf("%s is not IPC\n", pstFirstMethod->pstClass->uidName);
#endif
	}
#endif
	
        /* must check to see if method that we looked up is actually the
           same method that we need, i.e. check to see if the method at the
           recorded VT index is the same as the one at that index of the
           needed class's VT */
	if (pstFirstMethod->u16VTIndex < pstClassTemp->pstClass->u16VTSize) {
	  /* check to see if the method at the guess index has the correct name
	     and signature */
	  if ((uidcmp(pstClassTemp->pstClass->ppstVT[u16VTGuess]->uidName, 
		      pstFirstMethod->uidName) == 0) &&
	      (uidcmp(pstClassTemp->pstClass->ppstVT[u16VTGuess]->uidSignature,
		      pstFirstMethod->uidSignature) == 0)) {
	    pstRightMethod = pstClassTemp->pstClass->ppstVT[u16VTGuess];
	  }
	  else {
	    pstRightMethod = NULL;
	  }
	}
	
        /* find the correct method if we don't have it already */
        while (pstRightMethod == NULL) {
#ifdef SHOW_CONTEXT_SWITCH
	  eprintf("Getting method interface (finding correct method %s)\n", 
		  pstFirstMethod->uidName);
#endif
	  pstRightMethod =
	    CLASSFILE_UidFindMethod(env, pstClassTemp, pstFirstMethod->uidName, 
				    pstFirstMethod->uidSignature);
	  if (pstRightMethod == NULL) {
	    /* check if we've still got more superclasses to check */
	    if (pstClassTemp->pstClass->pstSuperClass == NULL) {
	      panic("InvokeInterface: method reference not resolved %s.%s(%s)"
		    " %s", 
		    pstFirstMethod->pstClass->uidName,
		    pstFirstMethod->uidName, pstFirstMethod->uidSignature,
		    pstClassTemp->uidName); ///XXX throw exception
	      break;
	    }
	    /* go to superclass */
	    pstClassTemp = pstClassTemp->pstClass->pstSuperClass;
	  }
        }
	
	traceCall("*%s.%s (at %s: %i)", pstClassTemp->uidName, 
		  pstRightMethod->uidName, pstCurrClass->uidName,
		  INTERP_FigureOutLineNumber(pstCurrFrame));

#ifdef QUICK
        /* Change this to a _quick instruction with a guess. */
	pbPC[-5] = invokeinterface_quick;
        pbPC[-1] = pstRightMethod->u16VTIndex;
#endif
	
        if ((tOBREF) *(optop - pstFirstMethod->u16ArgSize + 1) == NULL) {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
        }
	
	if (pstRightMethod->u16AccessFlags & ACC_NATIVE) {
	  SAVEENV();
	  i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstRightMethod);
	  if (i32NativeRet == -1) {
	    pstCurrFrame = CatchException(env, pstCurrFrame);
	  }
	  LOADENV();
        }
	else {
	  SAVEENV();
	  pstCurrFrame = 
	    PushStackFrame(pstRightMethod, 
			   (tOBREF) *(optop - pstRightMethod->u16ArgSize + 1),
			   pstCurrFrame);
	  
#ifdef TEASEME
	  if (iIsIPC) {
	    //Do the context switch
	    pstCurrFrame->pstHeap = pstNewHeap;
	    //we must also make external refs to any refs passed in this call
	    //XXX
	  }
#endif
	  LOADENV();
	  if (iMultiThread) {
	    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & 
		ACC_SYNCHRONISED) {
	      if (pstCurrFrame->pstCurrObject == NULL) {
		SAVEENV();
		pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
		LOADENV();
	      }
	      else {
		THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
	      }
	    }
	  }
	  else {
#ifdef MDEBUG
	    printf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
	  }
	}
	break;
      }
      
    case invokeinterface_noguess:
      {
	int16        i16Temp;
	tMethod*     pstMethodTemp;
	tMethod*     pstRightMethod;
	tClassLoaderTuple*      pstClassTemp;
	int32        i32NativeRet;
	uint16       u16ArgLen;
	
#ifdef GARBAGE2
	GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
#endif
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
#ifdef DEBUG
	assert(CONSTTAG(pstCurrClass->pstClass, i16Temp) == 
	       CONSTANT_InterfaceMethodref);
#endif
	
	/* get argument length */
	u16ArgLen = (*pbPC++);
	pbPC++;             /* reserved field according to spec */
	
	/* get method normally */
	pstMethodTemp = CONSTGET_MethodInterface(env, pstCurrClass, 
						 i16Temp, optop, u16ArgLen);

	if (pstMethodTemp == NULL) {
	  /* An exception was thrown while resolving the method */
	  tOBREF pstExOb = JNI_getJNIData(sys_current_thread())->pstException;
	  JNI_getJNIData(sys_current_thread())->pstException = NULL;
	  SAVEENV();
	  pstCurrFrame = CatchExternalException(env, pstCurrFrame, pstExOb);
          LOADENV();
	  break;  
	}
	
	/* find the correct method */
	pstRightMethod = NULL;
	pstClassTemp = DEREF((tOBREF) *(optop - u16ArgLen + 1))->pstType;
	while (pstRightMethod == NULL) {
          pstRightMethod = 
	    CLASSFILE_UidFindMethod(env, pstClassTemp, pstMethodTemp->uidName, 
				    pstMethodTemp->uidSignature);
          if (pstRightMethod == NULL) {
            /* check if we've still got more superclasses to check */
            if (pstClassTemp->pstClass->pstSuperClass == NULL) {
              panic0("InvokeInterface: method reference not resolved");
              break;
            }
            /* go to superclass */
            pstClassTemp = pstClassTemp->pstClass->pstSuperClass;
          }
        }
	
        if ((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1) == NULL) {
          SAVEENV();
          pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
          // XXX - why is this commented out??
          // XXX - is it because there is a missing 'break' ???
	  /*          LOADENV();*/
        }
	
	if (pstRightMethod->u16AccessFlags & ACC_NATIVE) {
	  SAVEENV();
	  i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	  if (i32NativeRet == -1) {
	    pstCurrFrame = CatchException(env, pstCurrFrame);
	  }
	  LOADENV();
	}
	else {
	  SAVEENV();
	  pstCurrFrame = 
	    PushStackFrame(pstRightMethod,
			   (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1),
			   pstCurrFrame);
	  LOADENV();
	  if (iMultiThread) {
	    if (pstCurrFrame->pstCurrMethod->u16AccessFlags & 
		ACC_SYNCHRONISED) {
	      if (pstCurrFrame->pstCurrObject == NULL) {
		SAVEENV();
		pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
		LOADENV();
	      }
	      else {
		THREAD_SynchroniseEnter(pstCurrFrame->pstCurrObject);
	      }
	    }
	  }
	  else {
#ifdef MDEBUG
	    printf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
          }
        }
	break;
      }
      
#ifdef QUICK
    case invokeinterface_quick:
      {
#error not yet
	int16        i16Temp;
	int16        i16ArgSize;
	int16        i16VTGuess;
	int32        i32NativeRet;
	tClass*      pstClassTemp;
	tMethod*     pstMethodTemp;
	tMethod*     pstFirstMethod;
	
#ifdef GARBAGE2
	GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
#endif
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
	assert(CONSTTAG(pstCurrClass, i16Temp) == CONSTANT_InterfaceMethodref);
	
	/* get argument length */
	i16ArgSize = (*pbPC++);
	i16VTGuess = (*pbPC++);  /* Guess. For us this is a VT index. */
	
        /* get method */
        pstFirstMethod = CONSTGET_MethodInterface(pstCurrClass, i16Temp, optop,
						  i16ArgSize);

	if (pstFirstMethod == NULL) {
	  /* An exception was thrown while resolving the method */
	  tOBREF pstExOb = JNI_getJNIData(sys_current_thread())->pstException;
	  JNI_getJNIData(sys_current_thread())->pstException = NULL;
	  SAVEENV();
	  pstCurrFrame = CatchExternalException(env, pstCurrFrame, pstExOb);
          LOADENV();
	  break;
	}
	
	/* retrieve class pointer through handle on stack */
	//Jewel sep
	pstClassTemp = (DEREF((tOBREF) (*(optop + 1 - i16ArgSize))))->pstType;
	
	/* First try the guess */
        /* check if it's inside the range of the VT */
	if (i16VTGuess < pstClassTemp->u16VTSize) {
          /* check to see if the method at the guess index has the correct name
             and signature */
	  if ((uidcmp(pstClassTemp->ppstVT[i16VTGuess]->uidName,
		      pstFirstMethod->uidName) == 0) &&
              (uidcmp(pstClassTemp->ppstVT[i16VTGuess]->uidSignature, 
		      pstFirstMethod->uidSignature) == 0)) {
            pstMethodTemp = pstClassTemp->ppstVT[i16VTGuess];
	  }
	  else {
	    pstMethodTemp = NULL;
	  }
	}
	
	/* Recursive search from current class up its hierachy.
           This will not happen if the above guess was correct, since in that
           case pstMethodTemp != NULL */
	
	while (pstMethodTemp == NULL && pstClassTemp != NULL) {
	  pstMethodTemp = CLASSFILE_UidFindMethod(env, pstClassTemp, 
						  pstFirstMethod->uidName,
						  pstFirstMethod->uidSignature);
	  if (pstMethodTemp == NULL) {
            /* check if we have reached the top of the hierarchy */
	    if (pstClassTemp->pstSuperClass == NULL) {
	      pstClassTemp = NULL;
	      break;  /* get out of the while loop */
	    }
	    pstClassTemp = pstClassTemp->pstSuperClass;
	  }
	}
	
        if ((tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1) == NULL) {
          SAVEENV();
          pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
          LOADENV();
        }
	
	if (pstClassTemp && pstMethodTemp) {
	  if (pstMethodTemp->u16AccessFlags & ACC_NATIVE) {
	    SAVEENV();
	    i32NativeRet = JNI_CallNativeMethod(pstCurrFrame, pstMethodTemp);
	    if (i32NativeRet == -1) {
	      pstCurrFrame = CatchException(env, pstCurrFrame);
	    }
	    LOADENV();
	  }
	  else {
	    SAVEENV();
	    pstCurrFrame = 
	      PushStackFrame(pstMethodTemp, 
			     (tOBREF) *(optop - pstMethodTemp->u16ArgSize + 1),
			     pstCurrFrame);
	    LOADENV();
	    
#ifdef DEBUG_TRACE
	    iIndent++;
#endif
	    
	    if (iMultiThread) {
	      if (pstCurrFrame->pstCurrMethod->u16AccessFlags & 
		  ACC_SYNCHRONISED) {
		if (pstCurrFrame->pstCurrObject == NULL) {
		  SAVEENV();
		  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
		  LOADENV();
		}
		else {
		  THREAD_SynchroniseEnter(CLASS_GetClassFromStruct(env, pstCurrFrame->pstCurrClass));
		}
	      }
	    }
	    else {
#ifdef MDEBUG
	      eprintf("Warning - Monitor Enter in single-threaded mode.\n");
#endif
	    }
	  }
	}
	else {
	  panic("Interface method %s.%s(%s) not resolved "
		"(most derived class: %s)", 
		pstClassTemp->uidName, pstFirstMethod->uidName, 
		pstFirstMethod->uidSignature, pstClassTemp->uidName);
	}
	break;
      }
#endif /* QUICK */
