/*
 * Copyright (C) 2003, Stephen Crawley
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include "vm/invocation.h"
#include "vm/jni_data.h"
#include "vm/kni.h"
#include "vm/kni_methods.h"

static const struct JNIInvokeInterface functionTable =
{
  NULL, 
  NULL,
  NULL,
  INVOC_DestroyJavaVM,
  INVOC_AttachCurrentThread,
  INVOC_DetachCurrentThread,
  INVOC_GetEnv,
  INVOC_AttachCurrentThreadAsDaemon
};


static const struct JavaVMData javaVMData = {
  &functionTable
};


/* Get the default JavaVM object */
JavaVM *INVOC_GetJavaVM()
{
  return (JavaVM *)(&javaVMData);
}

jint INVOC_DestroyJavaVM(JavaVM *vm) 
{
  panic("DestroyJavaVM not implemented");
  return -1;
}

jint INVOC_AttachCurrentThread(JavaVM *vm, void **penv, void *args)
{
  panic("AttachCurrentThread not implemented");
  return -1;
}

jint INVOC_DetachCurrentThread(JavaVM *vm)
{
  panic("DetachCurrentThread not implemented");
  return -1;
}

jint INVOC_GetEnv(JavaVM *vm, void **env, jint version)
{
  switch (version) {
  case JNI_VERSION_1_1:
  case JNI_VERSION_1_2:
    *((tJNIData **) env) = JNI_getJNIDataOrNull(sys_current_thread());
    return (*env == NULL) ? JNI_EDETACHED : JNI_OK;

  case JNI_VERSION_1_4:
    *env = NULL;
    return JNI_EVERSION;

  case KNI_VERSION_1_0:
    *((KNIApi **) env) = KNI_getKNIApiPtr();
    return JNI_OK;

  default:
    *env = NULL;
    return JNI_EVERSION;
  }
}

jint INVOC_AttachCurrentThreadAsDaemon(JavaVM *vm, void **penv, void *args)
{
  panic("AttachCurrentThreadAsDaemon not implemented");
  return -1;  
}


