#ifndef __STRUCT_TCODE_H__
#define __STRUCT_TCODE_H__

/*
 * @doc TYPE
 * @struct
 * This structure stores all the information needed about code in a method.
 *
 */

struct tcode
{
#ifdef CLASSPERSIST
  PID pid;
#endif
  uint16  u16MaxStack;     /* @field Maximum size of operand stack */
  uint16  u16MaxLocals;    /* @field Maximum number of local variables */
  uint32 u32CodeLength;  /* @field Length of byte code */
  byte*  pbCode;         /* @field Pointer to actual byte code */
  uint16 u16ExceptionTableLength;             /* @field Number of exceptions */
  tExceptionInfo* pstExceptionTable;          /* @field Exception info */
  tLineNumberTable* pstLineNumberTable;       /* @field Line number info */
  tLocalVariableTable* pstLocalVariableTable; /* @field Local variable info */
};

#endif
