# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

class MainWindow < KDE::MainWindow
  slots 'show_pref()', 'login()', 'show_thread()', 'copy()'

  attr_reader :url_line

  def initialize(parent)
    super(parent)

    main_widget = Qt::Widget.new(self)

    main_layout = Qt::VBoxLayout.new(main_widget)
    @url_line = Qt::LineEdit.new(main_widget)
    connect(@url_line, SIGNAL("returnPressed()"), self, SLOT("show_thread()"))
    main_layout.addWidget(@url_line)

    hsplit = Qt::Splitter.new(main_widget)
    main_layout.addWidget(hsplit)

    @board_list_view = BoardListView.new(hsplit)

    vsplit = Qt::Splitter.new(Qt::Splitter::Vertical, hsplit)

    @board_tab_widget = BoardTabWidget.new(vsplit)
    ViewMediator.board_tab_widget = @board_tab_widget

    @thread_tab_widget = ThreadTabWidget.new(vsplit)
    ViewMediator.thread_tab_widget = @thread_tab_widget

    setCentralWidget(main_widget)

    setup_menu

    statusBar.show
  end

  def setup_menu
    menu_bar = menuBar()
    file_menu = Qt::PopupMenu.new(self)
    menu_bar.insertItem("&File", file_menu)
    file_menu.insertItem("Load Board List", @board_list_view,
                         SLOT("load_board_list()"))
    file_menu.insertItem("Login", self,
                         SLOT("login()"))
    quit_action = KDE::StdAction::quit($app, SLOT("quit()"), actionCollection)
    quit_action.plug(file_menu)

    edit_menu = Qt::PopupMenu.new(self)
    menu_bar.insertItem("&Edit", edit_menu)

    copy_action = KDE::StdAction::copy(self, SLOT("copy()"), actionCollection)
    copy_action.plug(edit_menu)

    setting_menu = Qt::PopupMenu.new(self)
    menu_bar.insertItem("&Setting", setting_menu)
    setting_menu.insertItem("Setting Kita", self,
                            SLOT("show_pref()"))

    help_menu = Qt::PopupMenu.new(self)
    menu_bar.insertItem("&Help", help_menu)
  end

  def show_pref
    dialog = PreferenceDialog.new(self)
    dialog.show
  end

  def login
    config = Config.instance
    user_id = config.user_id
    password = config.password

    account = Account.instance
    account.login(user_id, password)
  end

  def show_thread
    url = @url_line.text
    return unless url

    if Util.thread_url?(url) then
      dat_url = Util.thread_url_to_dat_url(url)
      ViewMediator.show_thread(dat_url)
    elsif Util.board_url?(url) then
      ViewMediator.show_board(url)
    end
  end

  def copy
    ViewMediator.copy
  end
end

