Kivy
====

Innovative User Interfaces Made Easy.

- Website: http://kivy.org/
- Documentation: http://kivy.org/docs/

[![Kivy's Coverage](https://coveralls.io/repos/kivy/kivy/badge.png?branch=master)](https://coveralls.io/r/kivy/kivy?branch=master)
[![Kivy's Trending](https://d2weczhvl823v0.cloudfront.net/kivy/kivy/trend.png)](https://bitdeli.com/free)


Introduction
------------

Kivy is a Python library for development of multi-touch enabled media rich
applications. The aim is to allow for quick and easy interaction design and
rapid prototyping, while making your code reusable and deployable.

Kivy is written in Python and Cython, based on OpenGL ES 2, supports various
input devices and have an extensive widgets library. With the same codebase,
you can target Windows, OSX, Linux, Android and iOS. All our widgets are built
with multitouch support.

Kivy is MIT licensed, actively developed by a great community, as well as all
the projects managed by the Kivy organisation.

Installation, Documentation, Examples
-------------------------------------

Extensive installation instructions as well as tutorials and general
documentation, including an API reference can be found at: http://kivy.org/docs/

An offline version in PDF format is also available.
Kivy ships with a bunch of examples that can be found in the examples/ folder.


Support
-------

If you need assistance, you can ask for help on our mailing list:

* Google Group : http://groups.google.com/group/kivy-users
* Email        : kivy-users@googlegroups.com

We also have an IRC channel (expect responses mostly in the day hours of CET):

* Server  : irc.freenode.net
* Channel : #kivy

Others projects
---------------

Have a look at our complementary projects:

- [Buildozer](http://github.com/kivy/buildozer): A robot that will do
  everything needed to package your application for iOS and Android. Ask him,
  wait, it's done.
- [Plyer](http://github.com/kivy/plyer): Library for accessing features of your
  hardware such as Accelerometer, Camera, 
- [Pyjnius](http://github.com/kivy/pyjnius): Access dynamically to Java/Android
  API from Python, easy!
- [Pyobjus](http://github.com/kivy/pyobjus): Access dynamically to
  Objective-C/iOS API from Python (wip)
- [Python for Android](http://github.com/kivy/python-for-android): Toolchain
  for building and packaging Kivy application to Android APK.
- [Kivy iOS](http://github.com/kivy/kivy-ios): Toolchain for building and
  packaging Kivy application to iOS IPA.
- [Audiostream](http://github.com/kivy/audiostream): Library to access directly
  on the Microphone and Speaker, for iOS and Android.
- [Garden](http://github.com/kivy-garden): Explore the User's widgets libraries



Licenses
--------

- Kivy is licensed under the terms of the MIT, check the LICENSE file.
- The provided fonts DroidSans.ttf and DroidSansMono.ttf are licensed under
  the terms of the Apache 2.0 License. The license can be found at
  http://www.apache.org/licenses/LICENSE-2.0
- The current UI design has been adapted from Moblintouch theme's SVGs, licensed
  under the terms of the LGPL 2.1.


