/***************************************************************************
                          boldlistboxitem.h  -  description
                             -------------------
    begin                : Sun Oct 12 2003
    copyright            : (C) 2003 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BOLDLISTBOXITEM_H
#define BOLDLISTBOXITEM_H

#include <qlistbox.h>

/**Listbox item that can optionally display its text in bold
  *@author Leonid Zeitlin
  */

class BoldListBoxItem : public QListBoxPixmap  {
private:
  bool m_bold;
protected:
  virtual void paint (QPainter *painter);
public: 
	BoldListBoxItem(QListBox *listbox, const QPixmap &pix, const QString &text,
	  bool bold = false);
	~BoldListBoxItem();
	bool bold() { return m_bold; }
	void setBold(bool bold) { m_bold = bold; }
};

#endif
