/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _SIGTOOL_H_
#define _SIGTOOL_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>



class KPrinter;
class KToggleAction;
class KURL;
class QLineEdit;
class QComboBox;
class QCheckBox;
class QListBox;
class QPushButton;
class QLabel;
class KProcess;
class KConfig;
class KURLRequester;


/**
 * This class serves as the main window for Sigtool.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Sigtool :  public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Sigtool(QWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~Sigtool();

    /**
     * Use this method to load whatever file/URL you have
     */
    void  setDirName(QString);

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(KConfig *);


private slots:
/*    void fileNew();
    void fileOpen();
    void fileSave();
    void fileSaveAs();
    void filePrint();
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void newToolbarConfig();
*/
    //void changeStatusbar(const QString& text);
    //void changeCaption(const QString& text);

private:
    void setupAccel();
    void setupActions();

private:
    //SigtoolView *m_view;

  /*  KPrinter   *m_printer;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;*/


signals:
    void itemSelected(QString abs_filename, int line);

public slots:

private slots:
    void configureKMail();
    void manualKMail();
    void manualXimian();
    void manual();
    void dobuttons();
private:

    QLineEdit *template_edit;
    QComboBox *files_combo, *pattern_combo/*, *dir_combo*/;
    KURLRequester *dir_combo;
    QCheckBox *recursive_box;
    QListBox *resultbox;
    QPushButton *search_button, *manual_button;
    QLabel *status_label, *matches_label;
    KProcess *childproc;
    QString buf;
    KConfig *config;
    QStringList lastSearchItems;
    QStringList lastSearchPaths;
    QComboBox *check_combo;
    QLabel *notes_label;
};

#endif // _Sigtool_H_
