/**************************************************************************/
/*  Klavaro - a flexible touch typing tutor                               */
/*  Copyright (C) 2005 - 2008  Felipe Castro                              */
/*                                                                        */
/*  This program is free software, licensed under the terms of the GNU    */
/*  General Public License as published by the Free Software Foundation,  */
/*  which is also included in this package, in a file named "COPYING".    */
/**************************************************************************/

#define TEXTMAXLEN 8000

void callbacks_shield_set (gboolean state);

void on_window_main_destroy (GtkObject * object, gpointer user_data);

void on_button_help_clicked (GtkButton * button, gpointer user_data);

void on_button_about_clicked (GtkButton * button, gpointer user_data);

void on_button_exit_clicked (GtkButton * button, gpointer user_data);

void on_button_keyboard_clicked (GtkButton * button, gpointer user_data);

void on_button_change_language_clicked (GtkButton * button, gpointer user_data);

void on_button_intro_clicked (GtkButton * button, gpointer user_data);

void on_button_basic_clicked (GtkButton * button, gpointer user_data);

void on_button_adapt_clicked (GtkButton * button, gpointer user_data);

void on_button_velo_clicked (GtkButton * button, gpointer user_data);

void on_button_fluid_clicked (GtkButton * button, gpointer user_data);

void on_checkbutton_0_toggled (GtkToggleButton * togglebutton, gpointer user_data);
void on_radiobutton_1_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_radiobutton_2_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_radiobutton_3_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_radiobutton_4_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_text_info_realize (GtkWidget * widget, gpointer user_data);

void on_dialog_info_destroy (GtkObject * object, gpointer user_data);

void on_dialog_info_response (GtkDialog * dialog, gint response_id, gpointer user_data);

void on_window_keyboard_destroy (GtkObject * object, gpointer user_data);

gboolean on_window_keyboard_delete_event (GtkWidget * widget, GdkEvent * event, gpointer user_data);

void
on_entry_kb_main_insert_text (GtkEditable * editable,
			      gchar * new_text, gint new_text_length, gpointer position,
			      gpointer user_data);

void
on_entry_kb_user_insert_text (GtkEditable * editable,
			      gchar * new_text, gint new_text_length, gpointer position,
			      gpointer user_data);

void on_button_kb_save_clicked (GtkButton * button, gpointer user_data);

void on_button_kb_remove_clicked (GtkButton * button, gpointer user_data);

void on_button_keyboard_select_clicked (GtkButton * button, gpointer user_data);

void on_button_keyboard_cancel_clicked (GtkButton * button, gpointer user_data);

void on_notebook_kb_switch_page (GtkNotebook * notebook, GtkNotebookPage * page, guint page_num,
				 gpointer user_data);

void on_toggle_shift1_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_toggle_shift2_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_virtual_key_clicked (GtkButton * button, gpointer user_data);

void on_button_keyboard_close_clicked (GtkButton * button, gpointer user_data);

void
on_entry_popup_key_insert_text (GtkEditable * editable,
				gchar * new_text, gint new_text_length, gpointer position,
				gpointer user_data);

void on_button_popup_cancel_clicked (GtkButton * button, gpointer user_data);

void on_button_msg_save_clicked (GtkButton * button, gpointer user_data);

void on_window_tutor_destroy (GtkObject * object, gpointer user_data);

void on_text_tutor_realize (GtkWidget * widget, gpointer user_data);

void on_spinbutton_lesson_value_changed (GtkSpinButton * spinbutton, gpointer user_data);

void on_button_revert_lesson_clicked (GtkButton * button, gpointer user_data);

void on_button_reset_lesson_clicked (GtkButton * button, gpointer user_data);

void on_button_tutor_other_clicked (GtkButton * button, gpointer user_data);

void on_button_tutor_stat_clicked (GtkButton * button, gpointer user_data);

void on_button_tutor_top10_clicked (GtkButton * button, gpointer user_data);

void on_button_tutor_show_keyb_clicked (GtkButton * button, gpointer user_data);

void on_button_tutor_intro_clicked (GtkButton * button, gpointer user_data);

void on_button_tutor_close_clicked (GtkButton * button, gpointer user_data);

void on_button_tutor_font_clicked (GtkButton * button, gpointer user_data);

void on_togglebutton_edit_basic_lesson_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_entry_custom_basic_lesson_activate (GtkEntry * entry, gpointer user_data);

void on_checkbutton_beep_toggled (GtkToggleButton * togglebutton, gpointer user_data);

gboolean on_entry_mesg_focus_out_event (GtkWidget * widget, GdkEventFocus * event,
					gpointer user_data);

void on_entry_mesg_grab_focus (GtkWidget * widget, gpointer user_data);

void on_entry_mesg_activate (GtkEntry * entry, gpointer user_data);

void on_entry_mesg_delete_text (GtkEditable * editable, gint start_pos, gint end_pos,
				gpointer user_data);

void
on_entry_mesg_insert_text (GtkEditable * editable,
			   gchar * new_text, gint new_text_length, gpointer position,
			   gpointer user_data);

void on_button_tutor_restart_clicked (GtkButton * button, gpointer user_data);

void on_treeview_other_realize (GtkWidget * widget, gpointer user_data);

void on_treeview_other_destroy (GtkObject * object, gpointer user_data);

void on_button_other_apply_clicked (GtkButton * button, gpointer user_data);

void on_button_other_new_clicked (GtkButton * button, gpointer user_data);

void on_button_other_paste_clicked (GtkButton * button, gpointer user_data);

void on_button_other_remove_clicked (GtkButton * button, gpointer user_data);

void on_filechooser_tutor_response (GtkDialog * dialog, gint response_id, gpointer user_data);

void on_filechooser_tutor_destroy (GtkObject * object, gpointer user_data);

void on_frame_stat_realize (GtkWidget * widget, gpointer user_data);

void on_toggle_stat_accur_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_toggle_stat_velo_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_toggle_stat_fluid_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_toggle_stat_score_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_button_stat_close_clicked (GtkButton * button, gpointer user_data);

void on_togglebutton_top10_local_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_button_top10_exclude_clicked (GtkButton * button, gpointer user_data);

void on_button_top10_update_clicked (GtkButton * button, gpointer user_data);

void on_button_top10_publish_clicked (GtkButton * button, gpointer user_data);

void on_checkbutton_top10_default_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_checkbutton_top10_personal_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_checkbutton_top10_manager_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_entry_top10_uphost_changed (GtkEditable * editable, gpointer user_data);

void on_entry_top10_upuser_changed (GtkEditable * editable, gpointer user_data);

void on_entry_top10_uppass_changed (GtkEditable * editable, gpointer user_data);

void on_entry_top10_downhost_changed (GtkEditable * editable, gpointer user_data);

void on_entry_top10_downuser_changed (GtkEditable * editable, gpointer user_data);

void on_entry_top10_downpass_changed (GtkEditable * editable, gpointer user_data);

void on_button_top10_downupdate_clicked (GtkButton * button, gpointer user_data);

void on_button_top10_host_test_clicked (GtkButton * button, gpointer user_data);

void on_togglebutton_top10_external_toggled (GtkToggleButton * togglebutton, gpointer user_data);

void on_button_top10_close_clicked (GtkButton * button, gpointer user_data);

void on_window_top10_destroy (GtkObject * object, gpointer user_data);

void on_dialog_confirm_realize (GtkWidget * widget, gpointer user_data);

void on_button_confirm_yes_clicked (GtkButton * button, gpointer user_data);

void on_button_confirm_no_clicked (GtkButton * button, gpointer user_data);

void on_window_hints_destroy (GtkObject * object, gpointer user_data);

void on_fontselectiondialog_tutor_response (GtkDialog * dialog, gint response_id,
					    gpointer user_data);

void on_fontselectiondialog_tutor_destroy (GtkObject * object, gpointer user_data);

gboolean
on_entry_mesg_drag_drop (GtkWidget * widget,
			 GdkDragContext * drag_context, gint x, gint y, guint time,
			 gpointer user_data);

/* Fim */
