/**************************************************************************/
/*  Klavaro - a flexible touch typing tutor                               */
/*  Copyright (C) 2005 - 2008  Felipe Castro                              */
/*                                                                        */
/*  This program is free software, licensed under the terms of the GNU    */
/*  General Public License as published by the Free Software Foundation,  */
/*  which is also included in this package, in a file named "COPYING".    */
/**************************************************************************/

#include <glib.h>
#include <glib/gstdio.h>

gboolean kh_transfer (const gchar * src_path, const gchar * file);

int
main (int argc, char *argv[])
{
	const gchar src[] = "/tmp/klavaro";
	gboolean fail;

#ifdef G_OS_WIN32
	return -1;
#endif

	if (argc != 2)
		return -1;

	fail = kh_transfer (src, argv[1]);

	return fail;
}

gboolean
kh_transfer (const gchar * src_path, const gchar * file)
{
	const gchar dest_path[] = "/var/games/klavaro";
	gchar *tmp;
	gint ch;
	FILE *fh_src;
	FILE *fh_dest;

	if (!g_file_test (dest_path, G_FILE_TEST_IS_DIR))
		g_error ("The folder '%s' should exist.\n Something is wrong with your instalation of Klavaro.\n Try to reinstall it.\n", dest_path);

	tmp = g_build_filename (src_path, file, NULL);
	fh_src = g_fopen (tmp, "r");
	if (fh_src == NULL)
	{
		g_message ("File not found:\n %s", tmp);
		g_free (tmp);
		return 0;
	}
	g_free (tmp);

	tmp = g_build_filename (dest_path, file, NULL);
	fh_dest = g_fopen (tmp, "w");
	if (fh_dest == NULL)
	{
		g_message ("Can not write:\n %s", tmp);
		g_free (tmp);
		return -1;
	}
	while ((ch = fgetc (fh_src)) != EOF)
		fputc (ch, fh_dest);

	fclose (fh_src);
	fclose (fh_dest);

#ifdef G_OS_UNIX
		g_chmod (tmp, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH);
#endif
	g_free (tmp);

	return 0;
}
