/**************************************************************************/
/*  Klavaro - a flexible touch typing tutor                               */
/*  Copyright (C) 2005 - 2008  Felipe Castro                              */
/*                                                                        */
/*  This program is free software, licensed under the terms of the GNU    */
/*  General Public License as published by the Free Software Foundation,  */
/*  which is also included in this package, in a file named "COPYING".    */
/**************************************************************************/

/*
 * This file contains the set of languages configured for
 * internationalization.
 * The letters in parenthesis must agree with LL_CC,
 * where LL is the language code
 * and CC is the country code.
 * The only one exception is for the generic (and poor)
 * English, which uses the 'C' code.
 * Keep the alphabetic order, because it is put
 * in the interface as done here.
 */

#define LANG_SET \
"বাংলা    (bn_BD)\n" \
"Čeština (cs_CZ)\n" \
"English (C)\n" \
"English UK (en_GB)\n" \
"Español (es_ES)\n" \
"Esperanto (eo)\n" \
"Deutsch (de_DE)\n" \
"Français (fr_FR)\n" \
"Magyar (hu_HU)\n" \
"Nederlands (nl_BE)\n" \
"Nederlands (nl_NL)\n" \
"Polski (pl_PL)\n" \
"Português (pt_BR)\n" \
"Русский (ru_RU)\n" \
"Svenska (sv_SE)\n" \
"اردو (ur_PK)\n" \
"Tiếng Việt (vi_VN)"

#define LANG_NAME_MAX_LEN 50
typedef struct
{
	gchar name[LANG_NAME_MAX_LEN];
	gchar code[6];
	gchar cd[3];
} Lang_Name_Code;

void trans_set_language_env (gchar * code);

void trans_init_lang_name_code (void);

gchar * trans_get_code (gint i);

gboolean trans_lang_is_available (gchar * test);

gboolean trans_lang_has_stopmark (void);

FILE *trans_lang_get_similar_file (const gchar * file_end);

gchar * trans_lang_get_similar_file_name (const gchar * file_end);

void trans_init_language_env (void);

void trans_set_combo_language (void);

gchar *trans_get_current_language (void);

void trans_change_language (void);

gchar *trans_read_text (const gchar *);
