/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */
#ifndef _SENDKEY_H_
#define _SENDKEY_H_

// Get the Display definition
#include <X11/Xlib.h>
#include <string>
using namespace std;
//#include <QHash>

class sendKey
{
	public:
	/**
	 * Default constructor
	 */
		sendKey(Display *disp);

	/**
	 * Destructor
	 */
		virtual ~sendKey();
		
		typedef enum { keyDown, keyUp, keyDownUp } keyDirection;
		typedef struct {
			KeySym normal;
			KeySym shift;
			KeySym altgr;
		} keyValue;

		void		sendChar(char *car); //dispite the * it only send one character
		void		send(KeyCode kc, keyDirection kd = sendKey::keyDownUp);
		char*		keysymToString(KeySym ks);
		keyValue	*getKeyValue(KeyCode kc);
	private:
		typedef struct {
			int	index;
			KeySym	ks;
			KeyCode kc;
			bool	found;
		} keyModifier;

		keyModifier	shift;
		keyModifier	caps;
		keyModifier	ctrl;
		keyModifier	alt;
		keyModifier	numlock;
		keyModifier	altgr;
		bool		useXTest;
		keyValue*	listKeyCode;
		Display		*display;

		bool	initXTest();
		bool	getModifierList();
		bool	getKeyList();
		void	closeXTest();
};

#endif // _SENDKEY_H_
