#include "CKlearControllerTXTMain.h"

CKlearControllerTXTMain::CKlearControllerTXTMain( CKlearAppConfig *config, QWidget* parent, const char* name, WFlags fl ) : CKlearUITXTMain( parent, name, fl )
{
  const QString __FUNC__ = "CKlearControllerTXTMain::CKlearControllerTXTMain()";

  this->digit = 0;
  asciMutex.lock();
  //std::cout << "a lock txtm" << std::endl;
  this->asci = "";
  asciMutex.unlock();
  //std::cout << "a unlock txtm" << std::endl;
  this->pageNumber = "100";
  this->doubleHeight = 1;
  this->counter = 0;
  this->row = 0;
  this->position = -1;
  this->isHoldMosaic = false;
  this->holdMosaic=-1;
  this->element = "";
  this->backgroundColor = Qt::black;
  this->charakterColor = Qt::black;
  this->mosaicColor = Qt::black;

  this->rectHeight=1.0;
  this->rectWidth=1.0;

  this->KlearConfig = config;
  this->TXTDecoder = new CKlearAppTXTDecoder( this->KlearConfig );
  this->TXTStreamer = new CKlearAppTXTStreamer( this->KlearConfig, this->TXTDecoder );

  createWindow();
  this->TXTStreamer->start();
  this->TXTDecoder->pageNumber = this->pageNumber;

  connect( this->TXTDecoder, SIGNAL( changedHeaderInfo() ), this, SLOT( slotGrabSavedHeader() ) );
  connect( this->TXTDecoder, SIGNAL( changedBodyInfo() ), this, SLOT( slotGrabSavedBody() ) );
}

CKlearControllerTXTMain::~CKlearControllerTXTMain()
{
  const QString __FUNC__ = "CKlearControllerTXTMain::~CKlearControllerTXTMain()";

  delete this->TXTDecoder;
  delete this->TXTStreamer;
  delete this->KlearConfig;
}

void CKlearControllerTXTMain::paintEvent(QPaintEvent *e)
{
    const QString __FUNC__ = "CKlearControllerTXTMain::paintEvent(  )";

    paintTXTPageNumber();
    paintTXTHeader();
    paintTXTBody();
}

void CKlearControllerTXTMain::createWindow()
{
  const QString __FUNC__ = "CKlearControllerTXTMain::createTXTPainter(  )";

  this->setCaption( "Klear - Teletext: " + this->KlearConfig->getCurrentChannel() );
  this->setFixedSize( 680, 525 );

  getTXTFont();
}

QString CKlearControllerTXTMain::getPageNumber()
{
  const QString __FUNC__ = "CKlearControllerTXTMain::getPageNumber()";

  return this->pageNumber;
}

void CKlearControllerTXTMain::slotGrabSavedHeader()
{
  const QString __FUNC__ = "CKlearControllerTXTMain::slotGrabSavedHeader()";
  paintTXTHeader( );
}

void CKlearControllerTXTMain::slotGrabSavedBody()
{
  const QString __FUNC__ = "CKlearControllerTXTMain::slotGrabSavedBody()";

  this->counter = 3;
  paintTXTBody(  );
}

void CKlearControllerTXTMain::paintTXTHeader(  )
{
  this->TXTDecoder->bodyMutex.lock();
  QPainter *p = new QPainter(this);
  const QString __FUNC__ = "CKlearControllerTXTMain::paintTXTHeader( )";
  setDefaultProperties();

  for( int i = counter; i < 32; i++ )
  {
    std::cout << "in for" << std::endl;
    this->TXTDecoder->headerMutex.lock();
    setCharakterColor( this->TXTDecoder->TXTHeaderData[ i ] );
    setMosaicColor( this->TXTDecoder->TXTHeaderData[ i ] );
    setLatinNationalOption( this->TXTDecoder->TXTHeaderData[ i ] );
    this->TXTDecoder->headerMutex.unlock();
    p->fillRect( getRectWidth() * ( i + 8 ), 0, getRectWidth(), getRectHeight(),  getBackgroundColor() );
    p->setPen( getCharakterColor() );
    p->setFont( getTXTFont() );
    std::cout << "set font" << std::endl;
    asciMutex.lock();
    std::cout << (getRectWidth()*(i+8)) << " "<< getRectHeight()<< " " << asci << std::endl;
    p->drawText( getRectWidth() * ( i + 8 ), 0, getRectWidth(), getRectHeight(), Qt::AlignCenter, this->asci );
    asciMutex.unlock();
    std::cout << "end for" << std::endl;
  }
  delete p;
  this->TXTDecoder->bodyMutex.unlock();
}

void CKlearControllerTXTMain::paintTXTBody ()
{
  this->TXTDecoder->bodyMutex.lock();
  QPainter *p = new QPainter(this);
  const QString __FUNC__ = "CKlearControllerTXTMain::paintTXTBody( )";
  setDefaultProperties();
  this->setPaletteBackgroundColor (Qt::black);
  for( int column = 0; column < 3; column++ )
  {
    asciMutex.lock();
    this->asci = this->pageNumber.at( column );
    asciMutex.unlock();

    p->fillRect( getRectWidth() * ( column + 8 ), 0, getRectWidth(), getRectHeight(),  getBackgroundColor() );
    p->setPen( getCharakterColor() );
    p->setFont( getTXTFont() );
    std::cout << "body font" << std::endl;
    asciMutex.lock();
    p->drawText( getRectWidth() * ( column + 8 ), 0, getRectWidth(), getRectHeight(), Qt::AlignCenter, this->asci );
    asciMutex.unlock();
    std::cout << " body draw" << std::endl;
  }

  this->position = 1;
  this->row = 0;

  while( this->position != 25 )
  {
    setDefaultProperties();
    setDoubleHeight( this->row );
    for ( int column = 0; column < 40; column++ )
    {
      std::cout << "in for body " << std::endl;
      if( this->TXTDecoder->TXTBodyData[ this->row ][ column ] >= 0 && this->TXTDecoder->TXTBodyData[ this->row ][ column ] <= 7 || this->TXTDecoder->TXTBodyData[ this->row ][ column ] == 28 )
      {
          if(isHoldMosaic)
          {
              drawMosaic(column);
              setCharakterColor( this->TXTDecoder->TXTBodyData[ this->row ][ column ] );
          }
           else
          {
              setCharakterColor( this->TXTDecoder->TXTBodyData[ this->row ][ column ] );
              p->fillRect( getRectWidth() * column, getRectHeight() * this->position, getRectWidth(), getRectHeight() * this->doubleHeight, getBackgroundColor() );
          }

      }
      else if ( this->TXTDecoder->TXTBodyData[ this->row ][ column ] >= 16 && this->TXTDecoder->TXTBodyData[ this->row ][ column ] <= 23 )
      {
          if(isHoldMosaic)
          {
              drawMosaic(column);
              setMosaicColor( this->TXTDecoder->TXTBodyData[ this->row ][ column ] );
          }
          else
          {
              setMosaicColor( this->TXTDecoder->TXTBodyData[ this->row ][ column ] );
              p->fillRect( getRectWidth() * column, getRectHeight() * this->position, getRectWidth(), getRectHeight() * this->doubleHeight, getBackgroundColor() );
          }


      }
      else if ( this->TXTDecoder->TXTBodyData[ this->row ][ column ] == 29 )
      {
          if(isHoldMosaic)
          {
              setBackgroundColor( this->TXTDecoder->TXTBodyData[ this->row ][ column ] );
              drawMosaic(column);
          }
          else
          {
              setBackgroundColor( this->TXTDecoder->TXTBodyData[ this->row ][ column ] );
              p->fillRect( getRectWidth() * column, getRectHeight() * this->position, getRectWidth(), getRectHeight() * this->doubleHeight, getBackgroundColor() );
          }

}
      else if ( this->TXTDecoder->TXTBodyData[ this->row ][ column ] == 30 )
      {
          isHoldMosaic = true;
          holdMosaic = this->TXTDecoder->TXTBodyData[ this->row ][ column - 1 ];
          element = "mosaic";
          drawMosaic(column);
      }
      else if ( element == "char")
      {
          drawChar(column);
      }
      else if ( element == "mosaic")
      {
          drawMosaic(column);
      }
      std::cout << "out for body" << std::endl;
    }

    this->position++;
    this->row++;

    if ( this->doubleHeight == 2 )
    {
      this->doubleHeight = 1;
      this->position++;
    }
  }
  delete p;
  this->TXTDecoder->bodyMutex.unlock();
}

void CKlearControllerTXTMain::drawChar(int column)
{
    std::cout << "draw c" << std::endl;
    QPainter *p = new QPainter(this);
    p->fillRect( getRectWidth() * column, getRectHeight() * this->position, getRectWidth(), getRectHeight() * this->doubleHeight, getBackgroundColor() );
    setLatinNationalOption( this->TXTDecoder->TXTBodyData[ this->row ][ column ] );
    p->setPen( getCharakterColor() );
    p->setFont( getTXTFont() );
    asciMutex.lock();
    p->drawText( getRectWidth() * column, getRectHeight() * this->position, getRectWidth(), getRectHeight() * this->doubleHeight, Qt::AlignCenter, this->asci );
    asciMutex.unlock();
    delete p;
}

void CKlearControllerTXTMain::drawMosaic(int column)
{
    std::cout << "draw m" << std::endl;
    QPainter *p = new QPainter(this);
        p->fillRect( getRectWidth() * column, getRectHeight() * this->position, getRectWidth(), getRectHeight() * this->doubleHeight, getBackgroundColor() );

        if ( isHoldMosaic )
          setBinary( holdMosaic );
        else
        {
          setBinary( this->TXTDecoder->TXTBodyData[ this->row ][ column ] );
        }

        int pixelWidth = getRectWidth() / 2;
        int pixelHeight = getRectHeight() / 3;

        if ( pixelWidth % 2 == 0 )
          pixelWidth += 1;

        if ( pixelHeight % 3 == 0 )
          pixelHeight += 1;

        // unten rechts
        if( this->binary[ 0 ] == 1 )
          p->fillRect( getRectWidth() * column + pixelWidth, getRectHeight() * this->position + ( 2 * pixelHeight ), pixelWidth, pixelHeight, getMosaicColor() );
        else
          p->fillRect( getRectWidth() * column + pixelWidth, getRectHeight() * this->position + ( 2 * pixelHeight ), pixelWidth, pixelHeight, getBackgroundColor() );

        // unten links
        if( this->binary[ 2 ] == 1 )
          p->fillRect( getRectWidth() * column, getRectHeight() * this->position  + ( 2 * pixelHeight ), pixelWidth, pixelHeight, getMosaicColor() );
        else
          p->fillRect( getRectWidth() * column, getRectHeight() * this->position  + ( 2 * pixelHeight ), pixelWidth, pixelHeight, getBackgroundColor() );

        // mitte rechts
        if( this->binary[ 3 ] == 1 )
          p->fillRect( getRectWidth() * column + pixelWidth, getRectHeight() * this->position + pixelHeight, pixelWidth, pixelHeight, getMosaicColor() );
        else
          p->fillRect( getRectWidth() * column + pixelWidth, getRectHeight() * this->position + pixelHeight, pixelWidth, pixelHeight, getBackgroundColor() );

        // mitte links
        if( this->binary[ 4 ] == 1 )
          p->fillRect( getRectWidth() * column, getRectHeight() * this->position + pixelHeight, pixelWidth, pixelHeight, getMosaicColor() );
        else
          p->fillRect( getRectWidth() * column, getRectHeight() * this->position + pixelHeight, pixelWidth, pixelHeight, getBackgroundColor() );

        // oben rechts
        if( this->binary[ 5 ] == 1 )
          p->fillRect( getRectWidth() * column + pixelWidth, getRectHeight() * this->position, pixelWidth, pixelHeight, getMosaicColor() );
        else
          p->fillRect( getRectWidth() * column + pixelWidth, getRectHeight() * this->position, pixelWidth, pixelHeight, getBackgroundColor() );

       // oben links
        if( this->binary[ 6 ] == 1 )
          p->fillRect( getRectWidth() * column, getRectHeight() * this->position, pixelWidth, pixelHeight, getMosaicColor() );
        else
          p->fillRect( getRectWidth() * column, getRectHeight() * this->position, pixelWidth, pixelHeight, getBackgroundColor() );
    delete p;
}


void CKlearControllerTXTMain::setBinary( int dezimal )
{
  std::cout << "set b" << std::endl;
  for ( int i = 6; i >= 0; i-- )
  {
    this->binary[ i ] = dezimal % 2;
    dezimal = dezimal / 2;
  }
  /*std::cout << "Binary: ";
  for ( int i = 0; i < 7; i++ )
    std::cout << binary[ i ];30
  std::cout << std::endl;*/
  std::cout << "end b" << std::endl;
}

void CKlearControllerTXTMain::keyPressEvent( QKeyEvent *ke )
{
  const QString __FUNC__ = "CKlearControllerTXTMain::keyPressEvent( QKeyEvent *ke )";

  QString num;
  for ( int i = 0; i <= 9; i++ )
  {
    num = num.setNum( i );
    if( ke->text() == num )
      setTXTPageNumber( num );
  }
}

void CKlearControllerTXTMain::setTXTPageNumber( QString num )
{
  const QString __FUNC__ = "CKlearControllerTXTMain::setTXTNumber( QString num, QPainter *p )";

  this->pageNumber = "";

  if( this->digit == 0 )
  {
    this->number[ 0 ] = num;
    this->number[ 1 ] = "-";
    this->number[ 2 ] = "-";
  }

  if ( this->digit == 1 )
  {
    this->number[ 1 ] = num;
    this->number[ 2 ] = "-";
  }

  if ( this->digit == 2 )
    this->number[ 2 ] = num;

  for ( int i = 0; i < 3; i++ )
    this->pageNumber += this->number[ i ];

  paintTXTPageNumber();

  this->digit++;
  if( this->digit == 3 )
  {
    //std::cout << "Page Number: " << this->pageNumber << std::endl;
    this->TXTDecoder->pageNumber = this->pageNumber;
    this->digit = 0;
    this->counter = 0;
  }
}

void CKlearControllerTXTMain::closeEvent( QCloseEvent *ce )
{
  const QString __FUNC__ = "CKlearControllerTXTMain::closeEvent( QCloseEvent *ce )";

  this->TXTStreamer->setRunning( false );

  while( this->TXTStreamer->running() )
    this->TXTStreamer->wait();

  std::cout << "TXT stopped" << std::endl;

  this->hide();
  this->close();
}


void CKlearControllerTXTMain::setCharakterColor( int hex )
{
  //std::cout << "set cc" << std::endl;
  switch( hex )
  {
    case 0: this->charakterColor = Qt::black; break;
    case 1: this->charakterColor = Qt::red; break;
    case 2: this->charakterColor = Qt::green; break;
    case 3: this->charakterColor = Qt::yellow; break;
    case 4: this->charakterColor = Qt::blue; break;
    case 5: this->charakterColor = Qt::magenta; break;
    case 6: this->charakterColor = Qt::cyan; break;
    case 7: this->charakterColor = Qt::white; break;
  }
  this->element = "char";
  this->isHoldMosaic = false;
}

void CKlearControllerTXTMain::setMosaicColor( int hex )
{
  //std::cout << "set mc" << std::endl;
  switch( hex )
  {
    case 16: this->mosaicColor = Qt::black; break;
    case 17: this->mosaicColor = Qt::red; break;
    case 18: this->mosaicColor = Qt::green; break;
    case 19: this->mosaicColor = Qt::yellow; break;
    case 20: this->mosaicColor = Qt::blue; break;
    case 21: this->mosaicColor = Qt::magenta; break;
    case 22: this->mosaicColor = Qt::cyan; break;
    case 23: this->mosaicColor = Qt::white; break;
  }
  this->element = "mosaic";
  this->isHoldMosaic = false;
}

void CKlearControllerTXTMain::setBackgroundColor( int hex )
{
  //std::cout << "set bc" << std::endl;
  this->backgroundColor = this->charakterColor;
}

void CKlearControllerTXTMain::setLatinNationalOption( int nationalOption )
{
  asciMutex.lock();
  //std::cout << "a lock no" << std::endl;
  switch( nationalOption )
  {
    case 35: this->asci = "#"; break;
    case 36: this->asci = "$"; break;
    case 64: this->asci = ""; break;
    case 91: this->asci = ""; break;
    case 92: this->asci = ""; break;
    case 93: this->asci = ""; break;
    case 94: this->asci = "^"; break;
    case 95: this->asci = "_"; break;
    case 96: this->asci = ""; break;
    case 123: this->asci = ""; break;
    case 124: this->asci = ""; break;
    case 125: this->asci = ""; break;
    case 126: this->asci = ""; break;
    default: this->asci = nationalOption;
  }
  asciMutex.unlock();
}

void CKlearControllerTXTMain::setDoubleHeight( int row )
{
  //this->TXTDecoder->bodyMutex.lock();
  //std::cout << "a lock sdh" << std::endl;
  for ( int i = 0; i < 40; i++ )
    if ( this->TXTDecoder->TXTBodyData[ row ][ i ] == 13 )
      this->doubleHeight = 2;
  //this->TXTDecoder->bodyMutex.unlock();
}

QColor CKlearControllerTXTMain::getCharakterColor()
{
  return this->charakterColor;
}

QColor CKlearControllerTXTMain::getMosaicColor()
{
  return this->mosaicColor;
}

QColor CKlearControllerTXTMain::getBackgroundColor()
{
  return this->backgroundColor;
}

float CKlearControllerTXTMain::getRectHeight()
{
  this->rectHeight = ( float )this->height() / 25;
  return this->rectHeight;
}

float CKlearControllerTXTMain::getRectWidth()
{
  this->rectWidth = ( float )this->width() / 40;
  return this->rectWidth;
}

void CKlearControllerTXTMain::setDefaultProperties()
{
  this->backgroundColor = Qt::black;
  this->charakterColor = Qt::white;
  this->doubleHeight = 1;
  this->element = "char";
}

void CKlearControllerTXTMain::paintTXTPageNumber()
{
  QPainter *p = new QPainter(this);
  for ( int i = 0; i < 2; i++ )
    p->fillRect( getRectWidth() * i , 0, getRectWidth(), getRectHeight(), Qt::black );

  for ( int i = 0; i < 3; i++ )
  {
    p->fillRect( getRectWidth() * ( i + 2 ), 0, getRectWidth(), getRectHeight(), Qt::black );
    p->setPen( Qt::white );
    p->setFont( getTXTFont() );
    p->drawText( getRectWidth() * ( i + 2 ), 0, getRectWidth(), getRectHeight(), Qt::AlignLeft, this->number[ i ] );
  }

  for ( int i = 0; i < 2; i++ )
    p->fillRect( getRectWidth() * ( i + 5 ), 0, getRectWidth(), getRectHeight(), Qt::black );
  delete p;
}

QFont CKlearControllerTXTMain::getTXTFont()
{
  TXTFont.setFamily( "Helvetica" );
  TXTFont.setBold( true );
  TXTFont.setPixelSize( getRectHeight() - 1 );
  return TXTFont;
}