/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "availablegroups.h"
#include <kiconloader.h>
#include <kmessagebox.h>
 
AvailableGroups::AvailableGroups(DbEnv *dbenv, Servers *_servers, QWidget * p) :    parent(p), dbEnv(dbenv) , servers(_servers)
{
	
	dbName="availableGroups";
	groupDb = new Db(dbEnv, 0);
	int ret;
	if ((ret=groupDb->open(NULL, dbName, NULL, DB_BTREE, DB_CREATE | DB_THREAD, 0644)) != 0)
			qDebug("Error opening database: %s", dbEnv->strerror(ret));
	updating=false;
	
	
	
}

AvailableGroups::~ AvailableGroups( )
{
// 	delete m_view;
	groupDb->close(0);
	delete groupDb;
// 	qDebug("GroupList db closed");
}

void AvailableGroups::prepareToClose( )
{
	groupsList.setAutoDelete(true);
	groupsList.clear();
	m_view=0;
}

void AvailableGroups::loadGroups( )
{
	m_view = new KMdiChildView("Available NewsGroups",parent );
	m_view->setIcon(KGlobal::iconLoader()->loadIcon("news_subscribe", KIcon::Small, 0, false));
	(new QVBoxLayout(m_view))->setAutoAdd(true);
	m_filterEdit=new KLineEdit(m_view);
	m_groupList=new KListView(m_view);
	m_groupList->addColumn("Newsgroup");
	m_groupList->addColumn("Articles");
	m_groupList->setAllColumnsShowFocus(true);
	m_groupList->setSelectionMode(QListView::Single);
	m_groupList->setRootIsDecorated(false);
	m_groupList->setItemMargin(3);
	m_groupList->setSorting(0);
	m_groupList->setShowSortIndicator(false);
	connect(m_filterEdit, SIGNAL(returnPressed(const QString& )), this, SLOT(slotActivateFilter(const QString& )));
	
	Servers::iterator it;
	for (it=servers->begin(); it != servers->end(); ++it) 
		m_groupList->addColumn(it.data()->name);
	int Num_Col=2;
	Dbt *key, *data;
	key=new Dbt;
	data=new Dbt;
	Dbc *cursor;
	Group *g;
	groupDb->cursor(NULL, &cursor, 0);
	int ret;
	int count=0;
	KListViewItem *item;
	groupsList.setAutoDelete(false);
// 	QCheckListItem *item;
	
	while ((ret=cursor->get(key, data, DB_NEXT)) != DB_NOTFOUND) {
		g=new Group((char*)data->get_data());
		item=new KListViewItem(m_groupList, g->name, g->description);
		groupsList.insert(g->name, g);
// 		item=new QCheckListItem(m_groupList, g->name, QCheckListItem::CheckBox);
// 		item->setText(1, g->description);
		if (g->subscribed)
			item->setPixmap(0, BarIcon("news_subscribe", KIcon::SizeSmall));
		else item->setPixmap(0, BarIcon("news_unsubscribe", KIcon::SizeSmall));
		
		int i =0;
		
		for (it=servers->begin(); it != servers->end(); ++it) {
			if (g->serverPresence[it.key()] == true)
				item->setPixmap(Num_Col+i, BarIcon("button_ok", KIcon::SizeSmall));
			else item->setPixmap(Num_Col+i, BarIcon("button_cancel", KIcon::SizeSmall));
			++i;
		}
		
		++count;
// 		delete g;
		
		
	}
	qDebug("Groups: %d", count);
	cursor->close();
	delete key;
	delete data;
	connect(m_groupList, SIGNAL(executed(QListViewItem* )), this, SLOT(slotSubscribe(QListViewItem* )));
	
}

char * Group::retrieve( char *i, QString &s )
{
	int strlen;
    int ssize=sizeof(strlen);

    char *temp;
    memcpy(&strlen, i, ssize);

    i+=ssize;
    temp=new char[strlen+1];
    memcpy(temp, i, strlen);
    temp[strlen]='\0';
    s=temp;
    delete temp;
    i+=strlen;
    return i;
}

char * Group::insert( QString s, char *p )
{
	int strlen=s.length();
    int suint = sizeof(strlen);
    memcpy(p, &strlen, suint);

    p+=suint;
    memcpy(p, (const char *)s, strlen);
    p+=strlen;
    return p;
}

int Group::size()
{
	return (name.length() + description.length() + sizeof(bool) + sizeof(int)*3 + serverPresence.count()*(sizeof(int) + sizeof(bool)));
	
}

char * Group::data()
{
	char *p=new char[size()];
	char *i=&p[0];
	
	i=insert(name, i);
	i=insert(description, i);
	
	memcpy(i, &subscribed, sizeof(bool));
	i+=sizeof(bool);
	//Map count
	int count=serverPresence.count();
	memcpy(i, &count, sizeof(int));
	i+=sizeof(int);
	int id;
	bool b;
	QMap<int, bool>::iterator it;
	for (it = serverPresence.begin(); it != serverPresence.end(); ++it) {
		id=it.key();
		b=it.data();
		memcpy(i, &id, sizeof(int));
		i+=sizeof(int);
		memcpy(i, &b, sizeof(bool));
		i+=sizeof(bool);
		
	}
	
	

	
	return p;
}

Group::Group( char *p )
{
	char *i=&p[0];
	i=retrieve(i, name);
	i=retrieve(i, description);
	
	memcpy(&(subscribed), i, sizeof(bool));
	i+=sizeof(bool);
	int count;
	int id;
	bool b;
	memcpy(&count, i, sizeof(int));
	i+=sizeof(int);
	for (int j = 0; j < count; j++) {
		memcpy(&id, i, sizeof(int));
		i+=sizeof(int);
		memcpy(&b, i, sizeof(bool));
		i+=sizeof(bool);
		serverPresence.insert(id, b);
	}
	
}

Group::Group( QString _name, QString desc, int hostId)
{
	description=desc;
	name=_name;
	subscribed=false;
	serverPresence.insert(hostId, true);
	
	
}

void Group::addHost( int hostId )
{
	serverPresence[hostId]=true;
}



void AvailableGroups::slotSubscribe( QListViewItem *item )
{
	//retrieve the group...
	Dbt *key=new Dbt;
	Dbt *data=new Dbt;
	char keymem[KEYMEM_SIZE];
	char datamem[DATAMEM_SIZE];
	
	key->set_data(keymem);
	key->set_ulen(KEYMEM_SIZE);
	key->set_flags(DB_DBT_USERMEM);
	
	data->set_data(datamem);
	data->set_ulen(DATAMEM_SIZE);
	data->set_flags(DB_DBT_USERMEM);
	
	const char *k = item->text(0).latin1();
	memcpy(keymem, k, item->text(0).length());
	key->set_size(item->text(0).length());
	
	
	int ret;
	
	if ((ret=groupDb->get(NULL, key, data, 0)) != 0) {
		qDebug("Error retrieving key");
		return;
	}
		
	g = new Group(datamem);
	//Let groupList handle the subscription
	if (g->subscribed)
		KMessageBox::error(0, i18n("Group is already subscribed"), i18n("Error!"));
	else emit subscribe(g);
	
	delete g;
	delete key;
	delete data;
	
	
	
}


void AvailableGroups::slotActivateFilter( const QString &s )
{
	qDebug("Filtering by string: %s", (const char *) s);
	m_groupList->setEnabled(false);
	m_filterEdit->setEnabled(false);
	m_groupList->clear();
	QDictIterator<Group> it(groupsList);
	Servers::iterator sit;
	KListViewItem *item;
	int Num_Col=2;
	while(it.current()) {
		if (it.currentKey().find(s, 0, false) != -1) {
			item=new KListViewItem(m_groupList, it.current()->name, it.current()->description);
			int i =0;
		
			for (sit=servers->begin(); sit != servers->end(); ++sit) {
				if (it.current()->serverPresence[sit.key()] == true)
					item->setPixmap(Num_Col+i, BarIcon("button_ok", KIcon::SizeSmall));
				else item->setPixmap(Num_Col+i, BarIcon("button_cancel", KIcon::SizeSmall));
				++i;
			}
			if (it.current()->subscribed)
				item->setPixmap(0, BarIcon("news_subscribe", KIcon::SizeSmall));
			else item->setPixmap(0, BarIcon("news_unsubscribe", KIcon::SizeSmall));
			
			
		}
		//if (item->text(0).find(s, 0, false) == -1) {
		//	KListViewItem *temp=item->nextSibling();
			//delete item;
			//item=temp;
			
		//} else item=item->nextSibling();
		++it;
	}
	m_groupList->setEnabled(true);
	m_filterEdit->setEnabled(true);
	
}

void AvailableGroups::slotUnsubscribe( QString gName)
{
	
	Dbt *key=new Dbt;
	Dbt *data=new Dbt;
	char keymem[KEYMEM_SIZE];
	char datamem[DATAMEM_SIZE];
	
	key->set_data(keymem);
	key->set_ulen(KEYMEM_SIZE);
	key->set_flags(DB_DBT_USERMEM);
	
	data->set_data(datamem);
	data->set_ulen(DATAMEM_SIZE);
	data->set_flags(DB_DBT_USERMEM);
	const char *k = (const char *) gName;
	memcpy(keymem, k, gName.length());
	key->set_size(gName.length());
	int ret=groupDb->get(NULL, key, data, 0);
	if (ret != 0) {
		qDebug("Error retrieving group: %d", ret);
		return;
	}
	
	Group *g=new Group(datamem);
	g->subscribed=false;
	char *p=g->data();
	memcpy(datamem, p, g->size());
	data->set_size(g->size());
	delete p;
	ret=groupDb->put(NULL, key, data, 0);
	if (ret != 0)
		qDebug("Error saving group: %d", ret);
	else groupDb->sync(0);
	
	
	
}

void AvailableGroups::slotDeleteServer( int serverId)
{
	Dbt key, data;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	Dbc *cursor;
	int ret;
	groupDb->cursor(0, &cursor, DB_WRITECURSOR);
		
	while ((ret=cursor->get(&key, &data, DB_NEXT)) != DB_NOTFOUND) {
		g=new Group((char*)data.get_data());
		
		g->serverPresence.remove(serverId);
		//resave the group...
		const char *p=g->data();
		memset(&data, 0, sizeof(data));
		data.set_data((void*)p);
		data.set_size(g->size());
		if (g->serverPresence.isEmpty()) {
			ret=cursor->del(0);
			if (ret != 0)
				qDebug("Cannot delete group record!");
		} else if ((ret=cursor->put(0, &data, DB_CURRENT)) !=0)
			qDebug("cannot update group record! Error: %s", dbEnv->strerror(ret) );
		
		delete p;
		
		

		
		
	}
	cursor->close();
	
}


void AvailableGroups::slotSubscribed( Group * g)
{
	//Save the group as subscribed
	qDebug("Ok, subscribed");
	
	Dbt *key=new Dbt;
	Dbt *data=new Dbt;
	char keymem[KEYMEM_SIZE];
	char datamem[DATAMEM_SIZE];
	
	key->set_data(keymem);
	key->set_ulen(KEYMEM_SIZE);
	key->set_flags(DB_DBT_USERMEM);
	
	data->set_data(datamem);
	data->set_ulen(DATAMEM_SIZE);
	data->set_flags(DB_DBT_USERMEM);
	
	//Item is the "selected"....
	QListViewItem *item=m_groupList->selectedItem();	
	item->setPixmap(0, BarIcon("news_subscribe", KIcon::SizeSmall));
// 	qDebug("subscribed: %d", g->subscribed);
	const char *k=(const char *) g->name;
	memcpy(keymem, k, g->name.length());
	key->set_size(g->name.length());
	
	
	g->subscribed=true;
	char *p=g->data();
	memcpy(datamem, p, g->size());
	data->set_size(g->size());
	delete p;
	
	int ret=groupDb->put(NULL, key, data, 0);
	if (ret != 0)
		qDebug("Error saving group");
	else groupDb->sync(0);
	
	delete key;
	delete data;	
		
		
	
}
