/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "prefdialog.h"
#include <kmessagebox.h>
#include <qradiobutton.h>

#include <qcheckbox.h>
#include "prefgeneral.h"
#include "prefdecode.h"
#include "prefview.h"
#include "prefheader.h"
#include <qcheckbox.h>


PrefDialog::PrefDialog(QWidget *parent, const char *name)
        : KDialogBase(IconList, i18n("Preferences"), Ok|Cancel, Ok, parent, name, parent, name) 
{
	// adding page "General options"
    QFrame *frame = addPage(i18n("General"), i18n("General options"),
        KGlobal::iconLoader()->loadIcon("kfm",KIcon::Panel,KIcon::SizeMedium,false) );
    QVBoxLayout *frameLayout = new QVBoxLayout( frame, 0, 0 );
    prefGeneral = new PrefGeneral(frame);
    frameLayout->addWidget(prefGeneral);
	
	frame = addPage(i18n("Decode"), i18n("Decoding options"), KGlobal::iconLoader()->loadIcon("decode", KIcon::Panel, KIcon::SizeMedium, false));
	frameLayout=new QVBoxLayout(frame, 0, 0);
	prefDecode=new PrefDecode(frame);
	frameLayout->addWidget(prefDecode);
	
	frame=addPage(i18n("Header List"), i18n("Headerlist options"), KGlobal::iconLoader()->loadIcon("edit", KIcon::Panel, KIcon::SizeMedium, false));
	frameLayout=new QVBoxLayout(frame, 0, 0);
	prefHeader=new PrefHeader(frame);
	frameLayout->addWidget(prefHeader);
	
	frame=addPage(i18n("View"), i18n("Viewing options"), KGlobal::iconLoader()->loadIcon("viewmag1", KIcon::Panel, KIcon::SizeMedium, false));
	frameLayout=new QVBoxLayout(frame, 0, 0);
	prefView=new PrefView(frame);
	frameLayout->addWidget(prefView);

	


}


PrefDialog::~PrefDialog() {}

void PrefDialog::accept( )
{
	if (prefGeneral->dbDir().isEmpty() || prefGeneral->tmpDir().isEmpty() ||	prefGeneral->decodeDir().isEmpty()) {
		KMessageBox::error(this, i18n("Invalid Directory"), i18n("Error"));
		
	} else if (!checkAndCreateDir(prefGeneral->dbDir()) || ! checkAndCreateDir(prefGeneral->decodeDir()) ||
				! checkAndCreateDir(prefGeneral->tmpDir())) {
			KMessageBox::error(this, i18n("Could not create directory"), i18n("Error"));
	
	} else {
		//write configuration
		Config().configured=true;
		Config().dbDir=QDir::cleanDirPath(prefGeneral->dbDir());
		Config().tmpDir=QDir::cleanDirPath(prefGeneral->tmpDir());
		Config().decodeDir=QDir::cleanDirPath(prefGeneral->decodeDir());
		
		//Decoding options
		Config().useUU=prefDecode->uuBtn->isChecked();
		Config().overwriteExisting=prefDecode->overwriteBtn->isChecked();
		Config().deleteFailed=prefDecode->deleteBtn->isChecked();
		

		//View
		Config().activateTab=prefView->activateBtn->isChecked();
		Config().singleViewTab=prefView->oneTabBtn->isChecked();
		
		if ( prefView->deleteBtn->isChecked()) {
			Config().dViewed=Configuration::Yes;
		}
		else if (prefView->keepBtn->isChecked()) {
			Config().dViewed=Configuration::No;
		} else {
			Config().dViewed=Configuration::Ask;

		}
		
		//now create/delete the viewer tab based on the configuration...
		
		

		Config().showFrom=prefHeader->fromCheck->isChecked();
		Config().showDetails=prefHeader->detailsCheck->isChecked();
		Config().allowExpansion=prefHeader->expandCheck->isChecked();
		Config().showDate = prefHeader->dateCheck->isChecked();
		Config().alwaysDoubleClick=prefHeader->viewCheck->isChecked();
		Config().keepListSettings=prefHeader->memCheck->isChecked();
		
		if (prefHeader->markBtn->isChecked())
			Config().markOpt=Configuration::Yes;
		else if (prefHeader->askBtn->isChecked())
			Config().markOpt=Configuration::Ask;
		else Config().markOpt = Configuration::No;

		Config().write();
		QDialog::accept();
		
	}
	
}

void PrefDialog::reject( )
{
	qDebug("Rejected");
	if (Config().configured == true)
		QDialog::reject();
	else KMessageBox::error(this, i18n("Invalid configuration"), i18n("Error"));
}

//recursive

bool PrefDialog::mkDeepDir( QString dirName )
{
	QDir d;
	
	QString newDir=dirName.mid(0, dirName.findRev('/'));
// 	qDebug("Dir: %s", newDir.latin1());
	if (d.exists(newDir)) 
		return true;
	if (mkDeepDir(newDir)) {
// 		qDebug("create dir: %s", (const char *) newDir);
		if (d.mkdir(newDir))
			return true;
		else return false;
	} else return false;
	
}

bool PrefDialog::checkAndCreateDir( QString dirName )
{
	QString dir=QDir::cleanDirPath(dirName);
	dir+='/';
		if (QDir::isRelativePath(dir) ) {
			KMessageBox::error(this, i18n("Please enter only absolute paths"), i18n("Error"));
			return false;
		}
		if (!mkDeepDir(dir))
			return false;
		else { 
		//check if the dir is writable
			QFileInfo fi(dir);
			if (fi.isWritable())
				return true;
			else return false;
		
		}
		
}

void PrefDialog::slotCancel( )
{
	if (Config().configured == true)
		QDialog::reject();
	else KMessageBox::error(this, i18n("Sorry, you have to provide a valid configuration"), i18n("Invalid configuration"));
	
}


#include "prefdialog.moc"
