# This spec file was generated using Kpp
# If you find any problems with this spec file please report
# the error to ian geiser <geiseri@msoe.edu>

%define extension tar.gz
%define name klibido
%define version 0.2.4.1
%define release 1
%define summary A KDE nntp file grabber
%define workdir %{name}-%{version}
%define prefix `kde-config --prefix`
%define vendor Alessandro Bonometti <bauno@inwind.it>
%define url http://klibido.sourceforge.net
%define source %{name}-%{version}.%{extension}


Summary:   %{summary}
Name:      %{name} 
Version:   %{version}
Release:   %{release}
Copyright: GPL
Vendor:    %{vendor}
Url:       %{url}

Packager:  Alessandro Bonometti <bauno@inwind.it>
Group:     Utilities
Source:    %{source}
BuildRoot: /var/tmp/%{name}-%{version}-buildroot
Requires: db4 >= 4 , kdelibs >= 3.2 , qt >= 3.2 , uudeview >= 0.5.20
BuildRequires: db4-devel >= 4, kdelibs-devel >= 3.2, qt-devel >= 3.2, uudeview-devel >= 0.5.20


%description
KLibido (KDE Linux Binaries Downloader) is a KDE program to download and 
decode binary articles using the nntp protocol (i.e.: usenet).
Main features:
- Multiple servers support, with priorities and balancing
- Multiple download threads per server
- Automatically decoding of articles via the UULib library
- Embedded view of files via kparts
- Download queue management
- newzbin (.nzb) support


%prep
rm -rf $RPM_BUILD_ROOT

%setup -n %{workdir}
#CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./configure \
#                --prefix=%{prefix} \
#                $LOCALFLAGS

./configure --prefix=%{prefix} --disable-debug

%build
# Setup for parallel builds
numprocs=`egrep -c ^cpu[0-9]+ /proc/stat || :`
if [ "$numprocs" = "0" ]; then
  numprocs=1
fi

make -j$numprocs

%install
make install DESTDIR=$RPM_BUILD_ROOT

cd $RPM_BUILD_ROOT
/usr/lib/rpm/brp-compress
find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' > ${RPM_BUILD_DIR}/%{workdir}/file.list.%{name}
find . -type f | sed 's,^\.,\%attr(-\,root\,root) ,' >> ${RPM_BUILD_DIR}/%{workdir}/file.list.%{name}
find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >> ${RPM_BUILD_DIR}/%{workdir}/file.list.%{name}


%clean
rm -rf $RPM_BUILD_ROOT/*
rm -rf $RPM_BUILD_DIR/%{workdir}

%files -f file.list.%{name}
%doc AUTHORS COPYING ChangeLog NEWS README TODO

%changelog
* Tue Sep 12 2005 Alessandro Bonometti <bauno@inwind.it>
- Release 0.2.4.1
- FIX: Newzbin download caused an "out-of-space" error
- FIX: Server speed after pausing/resuming the queue now works
- Smal compile fixes

* Wed Sep 7 2005 Alessandro Bonometti  <bauno@inwind.it>
- Release 0.2.4
- NEW: Partial loading of headers during loading, to speed up the opening of
the headerlists
- New option: delete articles older than "n" days
- New action: context menu to manually delete headers from the group databases command-line
  option to automatically load (--reload-queue, -r) or discard (--discard queue, -d) the download queue
- Aggregate server speed
- New widgets in the statusbar to show the total speed of the servers
- New option: Filter headers by regular expression
- Incorporate patch #1275361 by Gonéri le Bouder (thanks!) that allows cancel of configuration 
  and makes some additional checks on the dir/dbs when starting
- NEW: added a "window" menu to switch between windows, close the active window 
  and "close with options", overriding default options (i.e.: close a group without 
  marking as read, close a view tab without deleting the file...)
- NEW: Added context menu on tabs.
- NEW: Added article numbers in groups in the "Available groups" list. To load them, 
  reload the list with server->"get list of groups..."
- NEW: Moved saving/updating of queued items into a separate thread (this has greatly 
  improved GUI responsiveness while downloading)
- FIX: Incorporated the "please subscribe me!" patch
- FIX: It's now possible to cancel paused items
- FIX: Fixed huge memory leak while downloading (sorry guys)
- FIX: Fixed a crash with very long (>100,000 items) headerlists (thanks to Randy Pearson)
- FIX: Fix requeue/multiple servers bug (#1275365)

* Mon May 10 2005 Alessandro Bonometti <bauno@inwind.it>
- Release 0.2.3
- NEW: Berkeley Db 4.3 support
- NEW: Cache for Db updates
- NEW: Preload of headers during expiring
- FIX: UULib sometimes saved only the first part of the posts
- FIX: Internal decoder didn't decode non-multipart articles
- FIX: some articles weren't correctly expired.

* Fri Mar 18 2005 Alessandro Bonometti <bauno@inwind.it>
- Release 0.2.2.2
- FIX: on fresh installs, KLibido crashed after configuration dialog (thanks to Gonéri le Bouder who
  found this bug)

* Wed Mar 16 2005 Alessandro Bonometti <bauno@inwind.it>
- Release 0.2.2.1
- Removed debian/ dir
- FIX: memory leak in NzbForm()
- FIX: wrong version in klibidoui.rc

* Sun Mar 13 2005 Alessandro Bonometti <bauno@inwind.it>
- Release 0.2.2
- NEW behavior: single-tab view: articles can be viewed in single, always-opened tab, to avoid cluttering.
- NEW option: delete/don't delete viewed file (without asking) when closing a view tab.
- NEW option: mark/don't mark articles as read (without asking) when closing an article list.
- NEW action: "update selected with options..." allow to download only the last "n" headers of a group
- New behavior: during group updates, if the download timeouts, the downloaded headers are inserted in
  the group, and the update is automatically requeued (from where it stopped). This should solve the
  problems some users were having downloading very large groups on some servers.
- NEW action: file->download .nzb. The parsing code was stolen (with permission :) from David Pye's Knzb. 
- NEW action: "Update current group" updates the group in the currently active tab. This is now the big
  blue down arrow in the toolbar. "Update selected newsgroups" is still available from the context menu
  of the group list.
- Renamed a couple of files to allow compiling on osX (see the howto on the webPage)
- NEW decoder: I stole the yy/uu decoding code from David Pye's Knzb, made some
  modifications/enhancements and included it in this release of KLibido
- Misc bugfixes

* Tue Mar 01 2005 Alessandro Bonometti <bauno@inwind.it>
- Release 0.2.1.1
- FIX: KLibido didn't delete temporary files for newsgroup updates
- FIX: Couldn't compile with KDE 3.2
- FIX: removed some debug messages

* Tue Feb 22 2005 Alessandro Bonometti <bauno@inwind.it>
- Release 0.2.1
- New option: always double click to view article (this overrides the global KDE setting).
- New option: remember filter settings for headerLists.
- New options: enable/disable subject expansion and colums in headerlists.
- Try to avoid jumping around the headerlist when marking articles as read and filtering 
  them out of the list.
- New action: compact databases
- Misc cosmetic changes
- New option: always double click to view article (this overrides the global KDE setting).
- New option: remember filter settings for headerLists.
- New options: enable/disable subject expansion and colums in headerlists.
- Try to avoid jumping around the headerlist when marking articles as read and filtering 
  them out of the list.
- New action: compact databases
- Misc cosmetic changes

* Tue Nov 17 2004 Alessandro Bonometti <bauno@inwind.it>
- Release 0.2.0
- Save progress of download queue across restarts/crashes
- Added a shortcut manager and some default shortcuts
- Double clicking on a header views the corresponding article
- Added support for group categories and group aliases
- Download queue balancing
- Write/out of space errors handling
- Reworked download threads' code
- Other small (and not-so-small) bugfixes

* Wed Oct 27 2004 Alessandro Bonometti <bauno@inwind.it>
- Release 0.12
- Ask to fallback to plain text if trying to view an unknown file type
- Added specfile and debian/ dir to source distribution
- Added "download to directory..." to download selected articles to a specified dir
- Various fixes to source code and include files. Now KLibido should compile correctly with KDE 3.2/Qt 3.2 or greater. KDE 3.1 is unsupported since it doesn't have the KMdi classes
- Solved a decoding problems with some UUencoded multi-part articles (thanks to Matthew Mueller, author of nget)
- Other small bugfixes
- Added doc directory

* Thu Sep 02 2004 Alessandro Bonometti <bauno@inwind.it>
- First test release
