/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GLOBALS_H
#define GLOBALS_H
 
#include <db_cxx.h>
#include <errno.h>
#include <qstring.h>
#include <qmap.h>
#include <qstring.h>
#include <kcursor.h>
#include <kdebug.h>

#define PAGE_SIZE 32768
#define CACHE_SIZE 4000000
#define KEYMEM_SIZE 10000
#define DATAMEM_SIZE 10000

#define GROUPDB_VERSION 4
#define HEADERDB_VERSION 5
#define AVAILABLEGROUPSDB_VERSION 1
#define SERVERDB_VERSION 1
#define INDEXDB_VERSION 0

//Bdb versioning macros...from the source of Bogofilter. Thanks to Matthias Andree <matthias.andree[at]gmx.de>
//for allowing me to steal these :-]

#define DB_AT_LEAST(maj, min)   ((DB_VERSION_MAJOR > (maj)) || ((DB_VERSION_MAJOR == (maj)) && (DB_VERSION_MINOR >=       (min))))
#define DB_AT_MOST(maj, min)    ((DB_VERSION_MAJOR < (maj)) || ((DB_VERSION_MAJOR == (maj)) && (DB_VERSION_MINOR <=       (min))))
#define DB_EQUAL(maj, min)      ((DB_VERSION_MAJOR == (maj)) && (DB_VERSION_MINOR == (min)))



class KListViewItem;
class QTimer;
static const int szInt = sizeof(int);




struct NntpHost {
    QString hostName;
	QString name;
    int port;
    QString userName;
    QString pass;
    int timeout;
	int id;
	int priority;
	int threadTimeout;
	int retries;
	int maxThreads;
	bool enabled;
	KListViewItem *item;
	unsigned long long size;
	
	int workingThreads;
	int speed;
};


class Configuration {
	public: 
		
		void read();
		void write() const;
		enum DeleteViewedFile {Ask=0, Yes, No};
		//General options
		bool configured;
		QString dbDir;
		QString decodeDir;
		QString tmpDir;
		
		//Decoding options
		bool overwriteExisting;
		bool deleteFailed;
		bool useUU;
		
		//View options.
		int dViewed;
		bool singleViewTab;
		bool activateTab;
		

		//HeaderList options
		bool showFrom;
		bool showDetails;
		bool showDate;
		bool allowExpansion;
		bool alwaysDoubleClick;
		bool keepListSettings;
		int markOpt;
		
		
	private:
		Configuration();
		Configuration(const Configuration&);
		
		friend Configuration& Config();
};

Configuration& Config();


typedef QMap<int, NntpHost*> Servers;

bool dirCreated();
bool checkAndCreateDir( QString dirName );
bool mkDeepDir( QString dirName );
NntpHost *loadHost( char *p, int version = SERVERDB_VERSION );
char* insert(QString s, char* p);
char* retrieve(char* i,QString &s);
int size( NntpHost *nh );
char * saveHost( NntpHost *nh );


#endif
