/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef HEADERLIST_H
#define HEADERLIST_H

#include "NewsGroupForm.h"
#include "newsgroup.h"
#include "hlistviewitem.h"
#include <klineedit.h>
#include <kstatusbar.h>
#include <kmdichildview.h>
#include <qtoolbutton.h>
#include "downloadselect.h"
#include <qcheckbox.h>

class QRegExp;


class NewHeaderList: public KMdiChildView
{
	Q_OBJECT
	void loadGroup(Db* db);
	
  	NewsGroup *ng;
  	Servers *servers;
	QToolButton *m_clearButton, *m_enterButton;
	QCheckBox *regExpCheck;
	KLineEdit *m_filterEdit;
	KListView *m_headerList;
  	QDict<BHListViewItem> hiddenItems;
	void markSelectedAs(int);
	bool showOnlyNew, showOnlyComplete;
	void filter(const QString &);
	void filter(const QRegExp &rx);
// 	BHListViewItem *hideItem(BHListViewItem *);
	void markAllAsRead(Db*);
	void markGroupAsRead();
	
	//New SmallBinHeader
	SmallBinHeader *getSmallBinHeader(char *p);
	
	//Keep these options here because these *need* to be synchronized with the bhlistviewitem...
	bool allowExpansion;
	bool showFrom;
	bool showDetails;
	bool showDate;
	
	
  
public:
	NewHeaderList(NewsGroup *_ng, Servers *_servers, QString caption, QWidget* parent=0);
	~NewHeaderList();
	bool prepareToClose(bool confirmation=true);
 	bool onlyNew() {return showOnlyNew;};
	bool onlyComplete() {return showOnlyComplete;}
	void reload();
	void closeAndMark();
	void closeAndNoMark();
	NewsGroup *getNg() {return ng;}
	virtual void closeEvent(QCloseEvent *e);
  
	private slots:
		void slotClearButtonClicked();
		void slotEnterButtonClicked();



public slots:
	void slotContextMenu( QListViewItem *, const QPoint & p);
	void slotViewArticle();
	void slotDownloadSelected(bool first=false, bool view=false, QString dir=QString::null);
	void slotDownloadSelectedFirst();
	void slotMarkSelectedAsRead();
	void slotDelSelected();
	void slotDownloadToDir();
	void slotMarkSelectedAsUnread();
	void slotShowOnlyComplete();
	void slotShowOnlyNew();
	void slotDownloadToFirst(QString, bool);
	
	
	
  /*$PUBLIC_SLOTS$*/

protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
// 	void slotActivateFilter(const QString&);
	void slotItemExecuted();
	
signals:
	void articlePopup(const QPoint &);
	void downloadPost(BinHeader*, NewsGroup*, bool first, bool view, QString);
	void viewPost(BinHeader*, NewsGroup*);
	void updateFinished(NewsGroup*);
	void sigSaveSettings(NewsGroup *, bool, bool);
	
};

#endif

