/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "klibido.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("KDE Linux Binaries Downloader");

static const char version[] = "0.2.4.1";

bool g_qResume = 0;
bool g_qDiscard = 0;



static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
	{"r", 0, 0},
	{"resume-queue", I18N_NOOP("Resume the download queue without asking"), 0},
	{"d", 0, 0},
	{"discard-queue", I18N_NOOP("Discard the download queue without asking"), 0},
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
	
    KAboutData about("klibido", I18N_NOOP("KLibido"), version, description,
					 KAboutData::License_GPL, "(C) 2004 Alessandro \"Bauno\" Bonometti", "A KDE Usenet binaries downloader", "http://klibido.sourceforge.net", "bauno@inwind.it");
	
    about.addAuthor( "Alessandro \"Bauno\" Bonometti", 0, "bauno@inwind.it" );
	about.addCredit("David Pye", "nzb parsing, yy/uu decoders", "dmp[at]davidmpye.dyndns.org", "http://dmp.org.uk/");
	about.addCredit("Andrea Gelmini", "suggestions and beta testing", "andrea.gelmini@linux.it", "http://www.gelma.net");
	about.addCredit("Andreas Nicolai", "KConfig tutorial", "ghorwin[at]users.sourceforge.net", "http://www.kdevelop.org/3.0/doc/tutorial_settings/");
	about.addCredit("Sleepycat", "Berkeley Db", 0, "http://www.sleepycat.com");
	about.addCredit("Frank Pilhofer", "UUDeview library", 0, "http://www.fpx.de/fp/Software/UUDeview/");
	
//     KCmdLineArgs::init(argc, argv, appName, programName, description, version);
	KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    klibido *mainWin = 0;

    if (app.isRestored())
    {
        RESTORE(klibido);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

		if (args->isSet("resume-queue"))
			g_qResume = 1;
		else if (args->isSet("discard-queue"))
			g_qDiscard = 1;
		
        mainWin = new klibido();
        app.setMainWidget( mainWin );
        mainWin->show();
		
        args->clear();
    }

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

