/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
// #include <kresolver.h>

#include "nntpthreadsocket.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <assert.h>
#include <netdb.h>
#include <sys/poll.h>
#include "queueparts.h"



char * NntpThreadSocket::m_findEndLine( char * start, char * end )
{
      for (char *p=start; p < end; p++) {
        if (p[0] == '\r')
            if (p[1] == '\n' && p+1 < end)
            return p;
    }
    return NULL;
}


QString NntpThreadSocket::createDateTime( QStringList dateTime) {

    int i=(dateTime[0].at(dateTime[0].length()-1) == ',') ? 1:0;

    
    QDate d=QDate::fromString(" " + dateTime[i+1] + " " + dateTime[i] +" " + dateTime[i+2]);

    
    QTime t=QTime::fromString(dateTime[i+3]);
    
    QDateTime dt(d, t);


    
    return dt.toString();


}



bool NntpThreadSocket::waitLine( )
{
	while (!m_findEndLine(buffer, watermark)) {
		int count =0;
		bytes=kes->waitForMore(2000);
		
		while ( ((bytes=kes->waitForMore(1000)) <=0) && !cancel ) {
			if ( (count >= timeout) || (bytes == -1) && !cancel) {
	// 			qDebug("Timeout or error waiting for line");
				//TODO: set the error!
				error=Comm_Err;
				errorString="Timeout or error waiting for data";
				reset();
						
				return false;
			}
			count++;
		} 
		if (!cancel) { 
			
			// Guard aganist very long article lines (> 100KB!) that exceeds
			// the allocated buffer space and expand if needed
			// Patch provided by Randy Pearson - Thank dude! :)
		
			if (bufferSize - (watermark-buffer) == 0)
			{
				qDebug("Warning: Buffer is full. Expanding to %d bytes", bufferSize*2);
				char * newbuff= new char[bufferSize*2];
				memcpy(newbuff, buffer, bufferSize);
				watermark=newbuff+bufferSize;
				delete [] buffer;
				buffer = newbuff;
				bufferSize *= 2;
			}
			
			bytes=kes->readBlock(watermark, bufferSize-(watermark-buffer));
			
			watermark+=bytes;
		} else {
			//reset the socket...
			qDebug("waitLine(): Cancel!");
			reset();
			return false;
		}
	}
	
	
	
	
	
	return true;
}

int NntpThreadSocket::m_handleError( int expected, QString received )
{
	switch (expected) {
        case NntpThreadSocket::pass:
            errorString=received;
            return NntpThreadSocket::Auth_Err;
        case NntpThreadSocket::group:
            errorString=received;
			if (received.left(3).toInt() == 411)
            	return NntpThreadSocket::NoSuchGroup_Err;
			else return NntpThreadSocket::Other_Err;
        case NntpThreadSocket::article:
		case NntpThreadSocket::body:
            errorString=received;
			if (received.left(3).toInt() == NoSuchArticle_Err || \
						 received.left(3).toInt() == NoSuchMid_Err)
            	return NntpThreadSocket::NoSuchArticle_Err;
			else return NntpThreadSocket::Other_Err;
		case NntpThreadSocket::xover:
			if (received.left(3).toInt() == 501)
				qDebug("501 error to xover command!");
			return NntpThreadSocket::Comm_Err;
        default: 
            errorString=received;
            return NntpThreadSocket::Other_Err;
    }

}

bool NntpThreadSocket::m_sendCmd( QString& cmd, int response )
{
	/*
	//BEGIN DEBUG
	if (qId == 1) {
		errorString = "No such article error";
		error = NntpThreadSocket::NoSuchArticle_Err;
		return false;
	}
	//END DEBUG
	*/
    QString s;
    error=NntpThreadSocket::No_Err;
	
	if (kes->bytesAvailable() > 0)
		kes->readBlock(line, lineBufSize);
	
	//Invalidate contents of the buffer...
	watermark=buffer;
// 	qDebug("Emptyied buffer");
	
    kes->writeBlock(cmd.latin1(), cmd.length());
	
	//Now I can check if the socket is valid...
	//I know, it's terrible, but its the only way I've found...
	
	if (!kes->isValid()) {
		qDebug("m_sendCmd: Invalid socket");
		isLoggedIn=false; 
		if (!m_connect())
			return false;
		else kes->writeBlock(cmd.latin1(), cmd.length());
	}
	
		
	
	if (!waitLine())
		return false;
	
    m_readLine();
	s=line;
	if (response == s.left(3).toInt()) {
// 		qDebug("Command ok");
		return true;
    }else { //set the error
		
		error=m_handleError(response, s);
// 		qDebug("m_sendCmd(): Got this invalid response from server: %s", (const char *) s);
		kdDebug() << "m_sendCmd(): Invalid response from server " << nHost->hostName \
				<< ": " << s << endl;
		
		//empty buffer
		watermark=buffer;
        return false;
	}
       
}


bool NntpThreadSocket::m_connect( )
{

	error=NntpThreadSocket::No_Err;
	if (isLoggedIn==true)
		return true;

    
    
	/*
	//print *status of the socket
	if (addrList.isEmpty()) {
		//Populate address list..
		qDebug("Resolving: %s", (const char *) nHost->hostName);
// 		QPtrList<KAddressInfo> kaddrList=KExtendedSocket::lookup(nHost->hostName,0);
		KNetwork::KResolverResults kaddrList=KNetwork::KResolver::resolve(nHost->hostName, 0);
		
		
// 		kaddrList.setAutoDelete(true);
		
// 		qDebug("Resolve list count: %d", kaddrList.count());
		KNetwork::KResolverEntry addr;
		QValueList<KNetwork::KResolverEntry>::iterator it;
		for (it=kaddrList.begin(); it != kaddrList.end() ; ++it) {
// 			const KSocketAddress *sockAddr=addr->address();
// 			qDebug("NodeName: %s", (const char *) (*it).address().nodeName() );
			addrList.append((*it).address().nodeName());
	}
	}
	//Get first address
// 	ha.setAddress(addrList[0]);
		if (addrList.isEmpty()) {
			qDebug("Cannot resolve hostname");
			errorString="Cannot resolve hostName";
			return false;
			}
		ha.setAddress(addrList[0]);
	*/
	hostent *he=gethostbyname(nHost->hostName );
	if (!he) {
		qDebug("Cannot resolve hostname");
		errorString="Cannot resolve " + nHost->hostName;
		error=NntpThreadSocket::Comm_Err;
		reset();
		return false;
	}
	QString address=QString::number( (unsigned char) he->h_addr[0]);
	QString s;
	
	for (int i = 1; i < he->h_length; i++) {
		address+='.' + QString::number( (unsigned char) he->h_addr[i]);
		}
	
// 	qDebug("Address: %s", (const char *) address);
	ha.setAddress(address);
	
	/*
	//Debug!--------------------
	qDebug("Connecting");
	char dLine[1000];
	kes->connect(ha, nHost->port);
	//Now remote end close the socket...
	s="quit\r\n";
	int ret;
	ret=kes->writeBlock(s.latin1(), s.length());
	qDebug("Ret after quit command: %d", ret);
	qDebug("Now the remote end closed the connection. *status of the socket:");
	//Now the socket is closed...
	sleep(2);
	qDebug("bytesAvailable(): %d", kes->bytesAvailable());
	qDebug("isValid(): %d", kes->isValid());
	qDebug("ReadBlock(): %d", kes->readBlock(dLine, 1000));
// 	qDebug("WriteBlock(): %d", kes->writeBlock(s.latin1(), s.length()));
	qDebug("bytesAvailable(): %d", kes->bytesAvailable());
	
	qDebug("isValid(): %d", kes->isValid());
	return false;
	
	//End debug!
	*/
	
	
	
	if (!kes->isValid()) {
		//socket is not valid, probably a timeout
		qDebug("Invalid socket");
		reset();
		
		
	} 
	/*
	if (!kes->isOpen()) {
		
		while(kes->readBlock(line, lineBufSize) > 0)
							
		isLoggedIn=false;
	} 
	*/
	
	
	
	
	newsGroup="";
	watermark=buffer;
    
	//redundant?
	
// 	qDebug("Not connected, connecting...");
	/*
	int conStatus;
	conStatus=kes->connect(ha, nHost->port);
	if (!conStatus) {
		qDebug("System error: %d", kes->error());
			qDebug("Error or timeout occurred");
// 			qDebug("Socket Status: %d", kes->socketStatus());
			delete kes;
			kes = new QSocketDevice(QSocketDevice::Stream,QSocketDevice::IPv4,0);
			kes->setBlocking(true);
			isLoggedIn=false;
			watermark=buffer;
		switch(conStatus) {
			case -3:
				error=NntpThreadSocket::timeoutErr;
				errorString="Timeout";
				return false;
			default:
				error=NntpThreadSocket::Comm_Err;
				errorString="Could not connect";
// 				qDebug("Error: %d", conStatus);
				error=NntpThreadSocket::Comm_Err;

				return false;
			}
	}*/
	//New, experimental connection code...
	if (! myConnect(ha, nHost->port) ) {
		qDebug("Cannot connect");
		return false;
	}
	
	kes->setBlocking(true);
		
// 		qDebug("Connected, going on");
       	
		if (!waitLine()) {
// 			qDebug("Error connecting!!");
			
			return false;	
			
		}
// 		qDebug("Line found");
		m_readLine();
		s=line;
// 		qDebug("Got this line: %s", (const char *) s);
		if ( (s.left(3).toInt() != NntpThreadSocket::ready) &&
					(s.left(3).toInt() != NntpThreadSocket::readyNoPost) ) {
			qDebug("Bad response code. Response: %d", s.left(3).toInt());
			error=NntpThreadSocket::Comm_Err;
			kes->close();
			delete kes;
			kes = new QSocketDevice(QSocketDevice::Stream);
			kes->setBlocking(true);
			isLoggedIn=false;
			watermark=buffer;
			newsGroup="";
			errorString=s;
            return false;
        }
	    if (nHost->userName == "") {
//             qDebug("Username NULL, connection finished");
			isLoggedIn=true;
            return true;
        }
        cmd="authinfo user " + nHost->userName + "\r\n";
// 		qDebug("Sending user");
        if (!m_sendCmd(cmd, NntpThreadSocket::user )) {
            qDebug("Bad response to the \"user\" cmd");
			kes->close();
			delete kes;
			kes = new QSocketDevice(QSocketDevice::Stream);
			kes->setBlocking(true);
			isLoggedIn=false;
			watermark=buffer;
			newsGroup="";
            return false;
        }
       cmd="authinfo pass " + nHost->pass + "\r\n";
// 	   qDebug("Sending password");
       if (!(m_sendCmd(cmd, NntpThreadSocket::pass ))) {
           qDebug("Authentication failed");
           qDebug("Error is: %d", error);
           qDebug("Response from server: %s", (const char *) errorString);
		   //disconnected
		   reset();
		   
           return false;
       }
       
       isLoggedIn=true;
// 	   qDebug("Logged in");
	   
       return true;

}


/*
bool NntpThreadSocket::getXover( QString group)
{
	QString s;
    if (!m_connect()) {
		qDebug("getXover(): can't connect");
        return false;
	}
	
    error=NntpThreadSocket::No_Err;
    cmd = "group " + group + "\r\n";
    
	if (!m_sendCmd(cmd, NntpThreadSocket::group))
		return false;	
	
	s=line;	
    qDebug("Line: %s", line);
	//parse fills articles, lowW and highW variables...
	parse(QStringList::split(" ", s, true));
	
	if (!(job->ng->low.contains(nHost->id)))
    	job->ng->low.insert(nHost->id, 0);  //new server for this group, zero low and high
    if (!(job->ng->high.contains(nHost->id)))
		job->ng->high.insert(nHost->id, 0);
    

            // Now grab the articles from the old hiww to the new highw...
	if ((job->ng->high[nHost->id]) != 0) {
    	articles=highWatermark - job->ng->high[nHost->id]+1;
		
	}
	qDebug("HighWatermark: %d; host->high: %d", highWatermark, job->ng->high[nHost->id]);
	qDebug("lowWatermark: %d, host->low: %d", lowWatermark, job->ng->low[nHost->id]);
	
	if (job->ng->low[nHost->id] == 0)
		job->ng->low[nHost->id] = lowWatermark;
	key=new Dbt;
	keymem=new uchar[KEYMEM_SIZE];
	key->set_data(keymem);
	key->set_ulen(KEYMEM_SIZE);
	key->set_flags(DB_DBT_USERMEM);
	
	data=new Dbt;
	datamem=new uchar[DATAMEM_SIZE];
	data->set_data(datamem);
	data->set_ulen(DATAMEM_SIZE);
	data->set_flags(DB_DBT_USERMEM);
	
	groupArticles=job->ng->totalArticles;
	if (job->ng->low[nHost->id] < lowWatermark) {
		qDebug("Expiring group %s", (const char *) job->ng->getName() );
		NntpThreadEvent *ce=new NntpThreadEvent(job, NntpThreadSocket::Expiring, 1);
		QApplication::postEvent(parent,ce);
    	expire(job->ng, nHost->id, lowWatermark);
    	job->ng->low[nHost->id]=lowWatermark;
		qDebug("Expired group %s", (const char *) job->ng->getName());
		ce=new NntpThreadEvent(job, NntpThreadSocket::Expiring, 0);
    	QApplication::postEvent(parent, ce);
		
	}else qDebug("No expire necessary");
	
	
	
	qDebug("Articles: %d", articles);
	
    
    step=articles/100;
    lines=0;
    if (step == 0)
    	step=1;
	        
	
	if (job->ng->high[nHost->id] >=highWatermark) {
		qDebug("No update necessary");
		return true;
	}
	//Check first line
	
	int tret;
	
	cmd="xover " + QString::number(job->ng->high[nHost->id]+1) + "-" + QString::number(highWatermark) + "\r\n";
	qDebug("Sent xover: %s", (const char *) cmd);
	if (!m_sendCmd(cmd, NntpThreadSocket::xover))
		return false;
	else qDebug("xover command: %s", line);

	qDebug("Entering main loop...");
	while (!(*cancel) && line[0] != '.') {
		if (!waitLine())
			return false;
		
		
		
		while (m_readLine()) {
			if (line[0] == '.')
				break;
			else {
				//This shold be a function....m_parseXoverLine() or something similar...
				
// 				s=line;
        		*curbytes += strlen(line);
        		lines++;
                if ((lines % step) == 0)  {
					NntpThreadEvent *ce=new NntpThreadEvent(job, NntpThreadSocket::Working, lines, articles);
            		QApplication::postEvent(parent,ce);
				}
				
        		


				Header *h=new Header(line);
				
				
                if ((tret=dbBinHeaderPut(db, h, nHost)) != 0 && tret != DB_KEYEXIST) {
        		    qDebug("NntpThread::getXover(): Exit from insert: %d", tret);
            		if (tret == DB_RUNRECOVERY ) {
						qDebug("Panic return! Run db recovery on %s", (const char *) job->ng->ngName);

					}
					
		        } else { //Update high watermark...
					
					job->ng->high[nHost->id] = h->m_num;
					

					
				}
				delete h;
				
			}
		
		
		}
	}

	
	Dbt groupkey, groupdata;
	memset(&groupkey, 0, sizeof(groupkey));
	memset(&groupdata, 0,  sizeof(groupdata));
	job->ng->totalArticles=groupArticles;
	
	char *tempng=job->ng->data();
	groupdata.set_data(tempng);
	groupdata.set_size(job->ng->getRecordSize());
	const char *tempkey=(const char *) job->ng->ngName;
	groupkey.set_data((void*)tempkey);
	groupkey.set_size(job->ng->ngName.length());
	if ((tret=job->gdb->put(NULL, &groupkey, &groupdata, 0)) != 0)
		qDebug("Error updating newsgroup: %d", tret);
	delete tempng;
	
	job->gdb->sync(0);
	
	
	
	db->sync(0);
	
	delete key;
	delete data;
	delete datamem;
	delete keymem;
	
	
	if ((*cancel)) {
		//delete the socket & empty the buffer...
		kes->close();
		delete kes;
		kes = new QSocketDevice(QSocketDevice::Stream,QSocketDevice::IPv4,0);
		isLoggedIn=false;
		watermark=buffer; //buffer emptyied :)
		kes->setBlocking(true);
		return false;
	} else return true;
	

	
}*/

/*

bool NntpThreadSocket::getXover( QString group)
{
	QString s;
    if (!m_connect()) {
		qDebug("getXover(): can't connect");
        return false;
	}
	
    error=NntpThreadSocket::No_Err;
    cmd = "group " + group + "\r\n";
    
	if (!m_sendCmd(cmd, NntpThreadSocket::group))
		return false;	
	
	s=line;	
    qDebug("Line: %s", line);
	//parse fills articles, lowW and highW variables...
	parse(QStringList::split(" ", s, true));
	
	if (!(job->ng->low.contains(nHost->id)))
    	job->ng->low.insert(nHost->id, 0);  //new server for this group, zero low and high
    if (!(job->ng->high.contains(nHost->id)))
		job->ng->high.insert(nHost->id, 0);
    

            // Now grab the articles from the old hiww to the new highw...
	if ((job->ng->high[nHost->id]) != 0) {
    	articles=highWatermark - job->ng->high[nHost->id]+1;
		
	}
	qDebug("HighWatermark: %d; host->high: %d", highWatermark, job->ng->high[nHost->id]);
	qDebug("lowWatermark: %d, host->low: %d", lowWatermark, job->ng->low[nHost->id]);
	
	if (job->ng->low[nHost->id] == 0)
		job->ng->low[nHost->id] = lowWatermark;
	
	key=new Dbt;
	keymem=new uchar[KEYMEM_SIZE];
	key->set_data(keymem);
	key->set_ulen(KEYMEM_SIZE);
	key->set_flags(DB_DBT_USERMEM);
	
	data=new Dbt;
	datamem=new uchar[DATAMEM_SIZE];
	data->set_data(datamem);
	data->set_ulen(DATAMEM_SIZE);
	data->set_flags(DB_DBT_USERMEM);
	
	groupArticles=job->ng->totalArticles;
	if (job->ng->low[nHost->id] < lowWatermark) {
		qDebug("Expiring group %s", (const char *) job->ng->getName() );
		NntpThreadEvent *ce=new NntpThreadEvent(job, NntpThreadSocket::Expiring, 1);
		QApplication::postEvent(parent,ce);
    	expire(job->ng, nHost->id, lowWatermark);
    	job->ng->low[nHost->id]=lowWatermark;
		qDebug("Expired group %s", (const char *) job->ng->getName());
		ce=new NntpThreadEvent(job, NntpThreadSocket::Expiring, 0);
    	QApplication::postEvent(parent, ce);
		
	}else qDebug("No expire necessary");
	
	
	
	qDebug("Articles: %d", articles);
	
    
    step=articles/100;
    lines=0;
    if (step == 0)
    	step=1;
	        
	
	if (job->ng->high[nHost->id] >=highWatermark) {
		qDebug("No update necessary");
		return true;
	}
	//Check first line
	
	int tret;
	
	cmd="xover " + QString::number(job->ng->high[nHost->id]+1) + "-" + QString::number(highWatermark) + "\r\n";
	qDebug("Sent xover: %s", (const char *) cmd);
	if (!m_sendCmd(cmd, NntpThreadSocket::xover))
		return false;
	else qDebug("xover command: %s", line);

	qDebug("Entering main loop...");
	while (!(*cancel) && line[0] != '.') {
		if (!waitLine())
			return false;
		
		
		
		while (m_readLine()) {
			if (line[0] == '.')
				break;
			else {
				//This shold be a function....m_parseXoverLine() or something similar...
				
// 				s=line;
        		*curbytes += strlen(line);
        		lines++;
                if ((lines % step) == 0)  {
					NntpThreadEvent *ce=new NntpThreadEvent(job, NntpThreadSocket::Working, lines, articles);
            		QApplication::postEvent(parent,ce);
				}
				
        		


				Header *h=new Header(line);
				
				
                if ((tret=dbBinHeaderPut(db, h, nHost)) != 0 && tret != DB_KEYEXIST) {
        		    qDebug("NntpThread::getXover(): Exit from insert: %d", tret);
            		if (tret == DB_RUNRECOVERY ) {
						qDebug("Panic return! Run db recovery on %s", (const char *) job->ng->ngName);

					}
					
		        } else { //Update high watermark...
					
					job->ng->high[nHost->id] = h->m_num;
					

					
				}
				delete h;
				
			}
		
		
		}
	}

	
	Dbt groupkey, groupdata;
	memset(&groupkey, 0, sizeof(groupkey));
	memset(&groupdata, 0,  sizeof(groupdata));
	job->ng->totalArticles=groupArticles;
	
	char *tempng=job->ng->data();
	groupdata.set_data(tempng);
	groupdata.set_size(job->ng->getRecordSize());
	const char *tempkey=(const char *) job->ng->ngName;
	groupkey.set_data((void*)tempkey);
	groupkey.set_size(job->ng->ngName.length());
	if ((tret=job->gdb->put(NULL, &groupkey, &groupdata, 0)) != 0)
		qDebug("Error updating newsgroup: %d", tret);
	delete tempng;
	
	job->gdb->sync(0);

	
	
	db->sync(0);
	
	delete key;
	delete data;
	delete datamem;
	delete keymem;
	
	
	if ((*cancel)) {
		//delete the socket & empty the buffer...
		kes->close();
		delete kes;
		kes = new QSocketDevice(QSocketDevice::Stream,QSocketDevice::IPv4,0);
		isLoggedIn=false;
		watermark=buffer; //buffer emptyied :)
		kes->setBlocking(true);
		return false;
	} else return true;
	

	
}*/


//New version of getXover(), this time we save the headers to a temporary file, 
//then pass the file to a thread that updates the databases...
//this is the last try!

bool NntpThreadSocket::getXover( QString group)
{
	QString s;
    if (!m_connect()) {
		qDebug("getXover(): can't connect to  %s", (const char *) nHost->name  );
        return false;
	}
	
    error=NntpThreadSocket::No_Err;
    cmd = "group " + group + "\r\n";
    
	if (!m_sendCmd(cmd, NntpThreadSocket::group))
		return false;	
	
	s=line;	
//     qDebug("Line: %s", line);
	//parse fills articles, lowW and highW variables...
	parse(QStringList::split(" ", s, true));
// 	qDebug("group low: %d; group high: %d; articles: %d", lowWatermark, highWatermark, highWatermark - lowWatermark);
	kdDebug() << "Highwatermark: " << highWatermark << " Lowwatermark: " << lowWatermark << endl;
	
	if (!(job->ng->low.contains(nHost->id)))
    	job->ng->low.insert(nHost->id, 0);  //new server for this group, zero low and high
    if (!(job->ng->high.contains(nHost->id)))
		job->ng->high.insert(nHost->id, 0);
	//save old low watermark
#if INDEXDB_VERSION != 0
	job->ng->oldLow[nHost->id]=job->ng->low[nHost->id];
#endif

            // Now grab the articles from the old hiww to the new highw...
	if (job->artSize == 0) {
		if ((job->ng->high[nHost->id]) != 0) {
			articles=highWatermark - job->ng->high[nHost->id]+1;	
		
		} else {
			articles = highWatermark - lowWatermark + 1;
			job->ng->high[nHost->id]=lowWatermark;
		
		}
		job->ng->low[nHost->id]=lowWatermark;
	} else {
		//Grab only last "artSize" articles...
		
		
		if ( (highWatermark - job->artSize)  > job->ng->high[nHost->id] )
			job->ng->high[nHost->id]= highWatermark - job->artSize;
		if ( ( highWatermark - job->artSize) > lowWatermark)
			job->ng->low[nHost->id] = highWatermark - job->artSize;
		else job->ng->low[nHost->id]=lowWatermark;
		
		articles=highWatermark - job->ng->high[nHost->id]+1;
		
		
	}
	
	groupArticles=job->ng->totalArticles;
	/*
	//BEGIN DEBUG
	job->ng->low[nHost->id]=28829971;
	return true;
	//END DEBUG
	*/
	
	
	step=articles/100;
    lines=0;
    if (step == 0)
    	step=1;
	        
	
	if (job->ng->high[nHost->id] >=highWatermark) {
		qDebug("No update necessary");
		return true;
	}
	//Check first line
	
	
	
	cmd="xover " + QString::number(job->ng->high[nHost->id]+1) + "-" + QString::number(highWatermark) + "\r\n";
	kdDebug() << "Getting articles " << job->ng->high[nHost->id]+1 << '-' << highWatermark << endl;
	
	if (!m_sendCmd(cmd, NntpThreadSocket::xover))
		return false;
// 	qDebug("Sent xover: %s", (const char *) cmd);

// 	else qDebug("xover command: %s", line);
// 	int debugCount=0;
// 	qDebug("Entering main loop...");
	
	while (line[0] != '.') {
		if (!waitLine())
			return false;
		
		
		
		while (m_readLine()) {
			if (line[0] == '.') {
// 				qDebug("End found");

				break;
				
			}
			else {
				//This shold be a function....m_parseXoverLine() or something similar...

// 				s=line;
        		*curbytes += strlen(line);
        		lines++;
				job->artSize=lines;
                if ((lines % step) == 0)  {
					NntpThreadEvent *ce=new NntpThreadEvent(job, NntpThreadSocket::Working, lines, articles);
            		QApplication::postEvent(parent,ce);
				}
				
				if ( ( (saveFile->writeBlock(line, strlen(line) )) == -1) || \
								  ( saveFile->putch('\n') == -1)  ) {
						//Write error...urgh! :)
					error=Write_Err;
					errorString="I/O error. Disk full?";
					reset();
					return false;
				} 
				/*
				debugCount++;
				if (debugCount >= 100) {
					error=Write_Err;
					errorString="I/O error. Disk Full?";
					reset();
					return false;
			}*/
				
				
			}
		
		
		}
	}
	//artSize is not used in updItem->use it to pass to updateDbThread the total number of lines to insert
// 	job->artSize=lines;
// 	qDebug("Grabbed %d lines, should have grabbed %d", lines, articles );
// 	qDebug("Stopped at %s", line);
	


	
	
	
	if (cancel) {
		//delete the socket & empty the buffer...
		reset();
		return false;
	} else return true;
	

	
}



void NntpThreadSocket::parse( QStringList qs) {
    articles=qs[1].toInt();
    lowWatermark=qs[2].toInt();
    highWatermark=qs[3].toInt();


}



void NntpThreadSocket::expire( NewsGroup * ng, int hostId, int lw ) {
    Dbc *cursor;
//     ng->getDb()->cursor(0, &cursor, DB_WRITECURSOR);
	if ((ng->getDb()->cursor(0, &cursor, DB_WRITECURSOR)) != 0)
		qDebug("Error creating cursor!");
    BinHeader *bh;
    int count =0, ret;
	
	while((ret=cursor->get
				(key, data, DB_NEXT)) != DB_NOTFOUND) {
		
		if (ret == ENOMEM) {
			//grow array
			
			//check for key overflow (never seen it)
			if (key->get_size() > KEYMEM_SIZE)
				qDebug("ERROR!!!!!!");
			datamemSize=data->get_size()+1000;
			
			
			delete datamem;
			datamem=new uchar[datamemSize];
			data->set_ulen(datamemSize);
			data->set_data(datamem);
			data->set_flags(DB_DBT_USERMEM);
// 			delete temp;
// 			qDebug("expire(): Array growed");
			ret=cursor->get(key, data, DB_NEXT);
			if (ret!=0) {
				qDebug("Error after growing!!");
				break;
			} 
			
		} else if (ret != 0) {
			qDebug("Error retrieving record: %d", ret);
			break;
		}
		
		count++;
		bh=new BinHeader(datamem);
// 		bh=new BinHeader((uchar*)data->get_data());
		
		if (bh->expire(hostId, lw)) {
			
			if ((ret=cursor->del(0))!=0)
				qDebug("Error deleting from db: %d", ret);
			else groupArticles--;
			
		} else {
			
			uchar *p=bh->data();
			if (bh->getRecordSize() > data->get_ulen()) {
				//Should never happen at this point, cause expire shrinks the record...but oh, well! :)
				//Grow the data array...
// 				qDebug("Growing the data memory array...");
				
				datamemSize=bh->getRecordSize()+1000;
				
				delete datamem;
				datamem=new uchar[datamemSize];
				data->set_ulen(datamemSize);
				data->set_data(datamem);
				data->set_flags(DB_DBT_USERMEM);
				
				
// 				free(data->get_data());
// 				data->set_data(malloc(datamemSize));
// 				data->set_ulen(datamemSize);
				
				
// 				qDebug("Array growed");
	
	
			}
			
			memcpy(data->get_data(), p, bh->getRecordSize());
			
			data->set_size(bh->getRecordSize());
			
			if ((ret=cursor->put(NULL, data, DB_CURRENT))!=0)
				qDebug("Error updating post: %d", ret);
			// 			else qDebug("Error! %d", ret);
			delete p;
			
		}

		delete bh;
		
// 		free(data->get_data());
		// 		if (count == 2) break;
	} 
	

    // Begin pasted code
    cursor->close();
	
    qDebug("Elements in DB: %d", count);






}



//Version with stack variables
/*
void NntpThreadSocket::expire( NewsGroup * ng, int hostId, int lw ) {
    Dbc *cursor;

	if ((ng->getDb()->cursor(0, &cursor, DB_WRITECURSOR))!= 0) {
		qDebug("Error creating cursor!!");
		return;
	}
    BinHeader *bh;
    int count =0, ret;
	Dbt expkey, expdata;
	
	
	
	while((ret=cursor->get
				(&expkey, &expdata, DB_NEXT)) != DB_NOTFOUND) {
		
		if (ret != 0) {
			qDebug("Error retrieving record: %d", ret);
			break;
		}
		
		count++;
		bh=new BinHeader((uchar*) expdata.get_data());
// 		bh=new BinHeader((uchar*)data->get_data());
		
		if (bh->expire(hostId, lw)) {
			
			if ((ret=cursor->del(0))!=0)
				qDebug("Error deleting from db: %d", ret);
			else groupArticles--;
			
			groupArticles--;
		} else {
			
			uchar *p=bh->data();
			memset(&expdata, 0, sizeof(expdata));
			expdata.set_data(p);
			expdata.set_size(bh->getRecordSize());
			
			if ((ret=cursor->put(NULL, &expdata, DB_CURRENT))!=0)
				qDebug("Error updating post: %d", ret);
			// 			else qDebug("Error! %d", ret);
			delete p;
			
		}

		delete bh;
		
	} 
	

    // Begin pasted code
    if (cursor->close() != 0)
		qDebug("Error closing cursor!");

	
    qDebug("Elements in DB: %d", count);






}
*/

//Version with stack variables
/*

int NntpThreadSocket::dbBinHeaderPut( Db * db, Header * h, NntpHost * nh ) {
    int ret;

	Dbt key, data;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	data.set_flags(DB_DBT_MALLOC);
    BinHeader *bh;
    QRegExp rx("\\((\\d+)/(\\d+)\\)");
	
    
    int index = rx.search(h->m_subj, 0);
    if (index != -1) {	//probably a binheader, now add to the list, or add the corresponding part
        // check for existence
        QString ts=h->m_subj.left(index).simplifyWhiteSpace(); //this is our subject/index
        
        //build the key
        QString index=ts+h->m_from; //Now our index is: subj+from

        const char *k=(const char *) index;
        key.set_data((void*)k);
        key.set_size(index.length());
		
		ret=db->get(NULL, &key, &data, 0);
		
		
        if ((ret == 0)) {
            //key exists, add part and save binheader again
			
            bh=new BinHeader((uchar*) data.get_data());
			free(data.get_data());
			
            
            if (bh->addPart(rx.cap(1).toInt(), h, nh)) { //Part is not a duplicate, inserted
                uchar *p = bh->data();
				
               
				memset(&data, 0, sizeof(data));
				
                data.set_size(bh->getRecordSize());
				data.set_data(p);
                if ((ret=db->put(NULL, &key, &data, 0)) != 0) {
					qDebug("Error inserting header");
				}
                // 					qDebug("Updated header inserted");
                // 				else qDebug("Error updating record");
                delete p;


            } //else { //part is a duplicate, do not insert? Or insert only if bin is different? Hmmm
//                 qDebug("Got a duplicate part!");
            //}
            delete bh;
			
			
            return ret;

            //debug: exit first time you make this cycle



        }
        else if (ret==DB_NOTFOUND) {
            //key doesn't exist, create header and save it
            //             				qDebug("Header does not exist, creating it");
			
            bh=new BinHeader;
			groupArticles++;
            bh->setSubj(ts);
			

            bh->setFrom(h->m_from);
            bh->setStatus(BinHeader::bh_new);



            if (h->m_date.isNull()) {
                qDebug("Date is null!!!");
                // 				qDebug("Header: %s", (const char *) h->m_subj);
                // 				qDebug("Number: %s", (const char *) h->m_num);
            } else
                bh->setDate(createDateTime(QStringList::split(" ", h->m_date, true)));

            // 			qDebug("DateTime is: %s", (const char *) bh->getDate());
            //             				qDebug("Header subj: %s", (const char *) ts);
            bh->setNumParts(rx.cap(2).toInt());
            //             				qDebug("Parts: %d", rx.cap(2).toInt());
            bh->addPart(rx.cap(1).toInt(), h, nh);

            //             				qDebug("Part in question: %d", rx.cap(1).toInt());
            uchar *p=bh->data();
            //             				qDebug("Binheader size: %d", bh->getRecordSize());

            //             				bh->printServerPart();
			
			memset(&data, 0, sizeof(data));
            data.set_size(bh->getRecordSize());
			data.set_data(p);

            ret=db->put(NULL, &key, &data, 0);


            delete bh;
            delete p;
// 			free(data->get_data());
			
            return ret;

        
        } else {
			qDebug("Other error: %d", ret);
			return ret;
		}






    }
	return 0;








}

*/



int NntpThreadSocket::dbBinHeaderPut( Db * db, Header * h, NntpHost * nh ) {
    int ret;


    BinHeader *bh;
    QRegExp rx("\\((\\d+)/(\\d+)\\)");
	
    
    int index = rx.search(h->m_subj, 0);
    if (index != -1) {	//probably a binheader, now add to the list, or add the corresponding part
        // check for existence
        QString ts=h->m_subj.left(index).simplifyWhiteSpace(); //this is our subject/index
        
        //build the key
        QString index=ts+h->m_from; //Now our index is: subj+from

        const char *k=(const char *) index;
        memcpy(keymem, k, index.length());
        key->set_size(index.length());
		
		ret=db->get(NULL, key, data, 0);
		
		
		if (ret == ENOMEM) {
// 			qDebug("dbBinHeaderPut(): Growing array");
			//grow data array and repeat the get
// 			uchar *temp=datamem;
			datamemSize=data->get_size()+1000;
			delete datamem;
			datamem=new uchar[datamemSize];
			data->set_ulen(datamemSize);
			data->set_data(datamem);
			data->set_flags(DB_DBT_USERMEM);
// 			delete temp;
// 			qDebug("dbBinHeaderPut(): Array growed");
			ret=db->get(NULL, key, data, 0);
			if (ret != 0 && ret != DB_NOTFOUND)
				qDebug("dbBinHeaderPut(): Could not get after array growth!: %d", ret);
			
		}
		
        if ((ret == 0)) {
            //key exists, add part and save binheader again
			
            bh=new BinHeader(datamem);
			
			
            
            if (bh->addPart(rx.cap(1).toInt(), h, nh)) { //Part is not a duplicate, inserted
                uchar *p = bh->data();
				
               
                if (bh->getRecordSize() > data->get_ulen()) {
                    //Grow the data array...
//                     qDebug("Growing the put data memory array...");
//                     uchar *temp=datamem;
					datamemSize=bh->getRecordSize();
					delete datamem;
                    datamem=new uchar[datamemSize];
                    data->set_ulen(datamemSize);
                    data->set_data(datamem);
					data->set_flags(DB_DBT_USERMEM);
// 					delete temp;
					
// 					free(data->get_data());
// 					data->set_data(malloc(datamemSize));
// 					data->set_ulen(datamemSize);
// 					qDebug("Array growed");


                }
				
				memcpy(datamem, p, bh->getRecordSize());
// 				memcpy(data->get_data(), p, bh->getRecordSize());

                // 					qDebug("Size after: %d", bh->getRecordSize());
                data->set_size(bh->getRecordSize());
                if ((ret=db->put(NULL, key, data, 0)) != 0) {
					qDebug("Error inserting header");
				}
                // 					qDebug("Updated header inserted");
                // 				else qDebug("Error updating record");
                delete p;


            } //else { //part is a duplicate, do not insert? Or insert only if bin is different? Hmmm
//                 qDebug("Got a duplicate part!");
            //}
            delete bh;
			
			
            return ret;

            //debug: exit first time you make this cycle



        }
        else if (ret==DB_NOTFOUND) {
            //key doesn't exist, create header and save it
            //             				qDebug("Header does not exist, creating it");
			
            bh=new BinHeader;
			groupArticles++;
            bh->setSubj(ts);
			

            bh->setFrom(h->m_from);
            bh->setStatus(BinHeader::bh_new);



            if (h->m_date.isNull()) {
                qDebug("Date is null!!!");
                // 				qDebug("Header: %s", (const char *) h->m_subj);
                // 				qDebug("Number: %s", (const char *) h->m_num);
            } else
                bh->setDate(createDateTime(QStringList::split(" ", h->m_date, true)));

            // 			qDebug("DateTime is: %s", (const char *) bh->getDate());
            //             				qDebug("Header subj: %s", (const char *) ts);
            bh->setNumParts(rx.cap(2).toInt());
            //             				qDebug("Parts: %d", rx.cap(2).toInt());
            bh->addPart(rx.cap(1).toInt(), h, nh);

            //             				qDebug("Part in question: %d", rx.cap(1).toInt());
            uchar *p=bh->data();
            //             				qDebug("Binheader size: %d", bh->getRecordSize());

            //             				bh->printServerPart();

			if (bh->getRecordSize() > data->get_ulen()) {
				
				datamemSize=bh->getRecordSize()+1000;
				delete datamem;
				datamem=new uchar[datamemSize];
				data->set_data(datamem);
				data->set_ulen(datamemSize);
				data->set_flags(DB_DBT_USERMEM);
				
// 				if (data->get_data() != NULL)
// 					free(data->get_data());
// 				data->set_data(malloc(datamemSize));
// 				data->set_ulen(datamemSize);
				
			
			}
            
            memcpy(data->get_data(), p, bh->getRecordSize());
			
            data->set_size(bh->getRecordSize());


            ret=db->put(NULL, key, data, 0);


            delete bh;
            delete p;
// 			free(data->get_data());
			
            return ret;

        } else if (ret == ENOMEM) {
            qDebug("ENOMEM Error!");
            qDebug("Requested size was: %d", data->get_size());
            qDebug("Host: %s", (const char *) nh->hostName);
            qDebug("NewsGroup: %s", (const char *) job->ng->ngName);
            qDebug("Dumping header:");
            qDebug("Article number: %d", h->m_num);
            qDebug("Subject: %s", (const char *) h->m_subj);
            // 			data=new char[11000];


            return ret; //Error???
        } else {
			qDebug("Other error: %d", ret);
			return ret;
		}






    }
	return 0;








}

void NntpThreadSocket::run( )
{
// 	qDebug("Starting thread %d,%d", qId,threadId);
	NntpThreadEvent *ce=0;
	//While there are jobs in the queue, process jobs :)
	
// 	while ( (*status != Paused) && (job=findFreeJob() )) {
	ce=new NntpThreadEvent(qId, threadId, NntpThreadSocket::StartedWorking);
	QApplication::postEvent(parent, ce);
// 	qDebug("%d, %d: sent startedworking message", qId, threadId);
	while (true) {
// 		qDebug("qID: %d, tID: %d", qId, threadId);
		
		
		statusLock.lock();
		
		if (pause) {
			status=Paused;
			pause=false;
		}
		queueLock->lock();
		if ( (*pendingOperations) != 0) {
			//Override paused state!
			(*pendingOperations)--;
			status=Delayed_Delete;
			queueLock->unlock();
			statusLock.unlock();
			break;
		}
		queueLock->unlock();
		
		//Out of the "if" cause I want job assigned, for checking on exit.
		
		
		if ( (status != Working) || !(job=findFreeJob()) ) {
			statusLock.unlock();
			break;
			
		}
		
		statusLock.unlock();
		
		
		if (!addJob()) {
			// Write errors are considered non-fatal for the article...they're mostly out-of space errors.
			// the queue is paused, and the user's responsibility to restart it, possibly after making 
			// room on the filesystem :)
			qDebug("Addjob Failed!");
			ce=new NntpThreadEvent(job, Write_Err);
			
			queueLock->lock();
			job->status=Job::Queued_Job;
			queueLock->unlock();
			statusLock.lock();
			//thread is in paused state
			status=PausedOnError;
			statusLock.unlock();
			break;
			
			
		}
		
		
		ce=new NntpThreadEvent(job, NntpThreadSocket::Start);
		QApplication::postEvent(parent, ce);
		
		switch (job->jobType) {
			case Job::UpdHead:
				
			
				if (getXover(newsGroup)) {
// 					qDebug("GetXover ok");	
					queueLock->lock();
					job->status=Job::Finished_Job;
					queueLock->unlock();
					ce=new NntpThreadEvent(job, NntpThreadSocket::DownloadFinished);
					
				
				
				} else {
					if (cancel) {
						kdDebug() << "GetXover canceled\n";
						queueLock->lock();
						job->status = Job::Canceled_Job;
						queueLock->unlock();						
						ce=new NntpThreadEvent(job, NntpThreadSocket::DownloadCanceled );
						statusLock.lock();
						cancel=false;
						statusLock.unlock();

						
					} else {
						qDebug("Error: %d", error);
						ce = new NntpThreadEvent(job, NntpThreadSocket::DownloadError);
						ce->err=error;
						if (error == NntpThreadSocket::NoSuchGroup_Err \
						   || error == Write_Err) {
							//Fail job
							queueLock->lock();
							job->status=Job::Failed_Job;
							job->error=errorString;
							queueLock->unlock();
							
							
						   } else { //CommError...
							   //Now we want to add the downloaded articles to 
							   //the db, and requeue the job...
							//Pause thread
							   //3lc: dont' want to change the state and requeue the job
							   //before updating the db
							   qDebug("Comm error while updating...");
							   
// 							queueLock->lock();
// 							job->status=Job::Finished_Job;
// 							queueLock->unlock();
							statusLock.lock();
							//thread is in paused state
							status=PausedOnError;
							statusLock.unlock();
						}
					
					
					}
					
				
				}
				saveFile->close();
				delete saveFile;
				saveFile=0;
				QApplication::postEvent(parent, ce);
				break;
			case Job::GetPost:
				// 			while (retries > 0) {	
// 				qDebug("Post job");
// 				qDebug("newsgroup: %s", (const char *) job->ng->ngName);
// 				qDebug("qId: %d, threadId: %d, itemId: %d", qId, threadId, job->qItemId);
				if (getArticle() ) {
// 					qDebug("Got article");
					ce=new NntpThreadEvent(job, NntpThreadSocket::Finished);
					queueLock->lock();
					job->status=Job::Finished_Job;
					queueLock->unlock();
	// 				QApplication::postEvent(parent, ce);
// 					break;
					
				} else {
					
					if (cancel) {
						//Job canceled
// 						*status=NntpThreadSocket::Ready;
						ce=new NntpThreadEvent(job, NntpThreadSocket::Canceled);

						kdDebug() << "Canceled " << job->qId << "," << job->threadId << endl;
						queueLock->lock();
						job->status = Job::Canceled_Job;
						queueLock->unlock();
						cancel=false;
						
// 						break;
						
					} else {
// 						qDebug("Error: %d, String: %s", error, (const char *) errorString);
// 						ce=new NntpThreadEvent(job, NntpThreadSocket::Err);
// 						job->error=errorString;
// 						retries--;
// 						if (retries == 0  || error == 423 ) {
// 						if (error != 423) {
							
						ce=new NntpThreadEvent(job, NntpThreadSocket::Err);
						queueLock->lock();
						job->error=errorString;
						queueLock->unlock();
						ce->err=error;
						
							//Ugly, should only pause the Thread class, but oh, well...
						
						if (error == NoSuchArticle_Err) {
							
							kdDebug() << "run(): no such article\n";
							queueLock->lock();
							//Try (default: 2 tries)
							//Astraweb often returns "no such article", 
							if (job->tries > 0) {
								job->tries--;
								kdDebug() << "NntpThreadSocket::run(): retry: " \
									<<	job->tries << endl;
								job->status=Job::Queued_Job;
								ce->err=No_Err;
								
							}else {
								//Job/article failed...do not retry!
								job->status=Job::Failed_Job;
// 								ce=new NntpThreadEvent(job, NntpThreadSocket::Err);
								job->error=errorString;
// 								ce->err=error;
							}
							queueLock->unlock();
														
							
						} else {
							//Pause the thread and reset the status of the job...
							//The thread has to be restarted by the QMgr, after
							// the proper time has passed
// 							qDebug("Other error: %d", ce->err);
							statusLock.lock();
							status=PausedOnError;
							statusLock.unlock();
							queueLock->lock();
							job->status=Job::Queued_Job;
							queueLock->unlock();
							
						}
							
							
						
					}
				}
				saveFile->close();
				delete saveFile;
				saveFile=0;
				QApplication::postEvent(parent, ce);
				break;	


			case Job::GetList:
// 			qDebug("Ok, job starting");
				if (getListOfGroups()) {
					queueLock->lock();
					job->status=Job::Finished_Job;
					job->ag->stopUpdating();
					queueLock->unlock();
					ce=new NntpThreadEvent(job, NntpThreadSocket::Finished);
				} else {
					if (cancel) {
						ce = new NntpThreadEvent(job, NntpThreadSocket::Canceled);
						cancel=false;
						queueLock->lock();
						job->ag->stopUpdating();
						queueLock->unlock();
					} else {
						ce = new NntpThreadEvent(job, NntpThreadSocket::Err);
						queueLock->lock();
						job->error=errorString;
						job->status=Job::Failed_Job;
						job->ag->stopUpdating();
						queueLock->unlock();
					}
					
				}
				QApplication::postEvent(parent, ce);
				break;
			default:
				qDebug("NntpThreadSocket::run(): unknown job type!");
		}
		
	}
	//Exited. Why?
	qDebug("about to exit run() on thread %d,%d", qId, threadId);
// 	statusLock.lock();
	//I can finally base this on the status *only* - much cleaner
	
	switch (status) {
		case Paused:
// 			qDebug("You paused me");
			ce = new NntpThreadEvent(NULL, Paused, threadId, qId);
			break;
		case PausedOnError:
			ce = new NntpThreadEvent(NULL, PausedOnError, threadId, qId);
			break;
		case Delayed_Delete:
			ce = new NntpThreadEvent(NULL, NntpThreadSocket::Delayed_Delete, threadId, qId);
			break;
		case Working:
			status=Ready;
			ce = new NntpThreadEvent(NULL, Ready, threadId, qId);
			//qDebug("%d, %d: sent ready message", qId, threadId);
			break;
		default:
			qDebug("Error: wrong status %d", status);
			
		
	}
		
// 	statusLock.unlock();
	QApplication::postEvent(parent, ce);
}

NntpThreadSocket::~ NntpThreadSocket( )
{
	kes->close();
	delete kes;
	delete [] line;
	delete [] buffer;
	if (saveFile)
		delete saveFile;
	
	
	
}

void NntpThreadSocket::setQueue(QValueList<int> *tq, QMap<int, QItem*> *q, QMutex *qLock, int* po) {
	threadQueue=tq;
	queue=q;
	queueLock=qLock;
	pendingOperations=po;
}

void NntpThreadSocket::setId(int q, int t) {
	qId=q;
	threadId=t;
}

NntpThreadSocket::NntpThreadSocket(QWidget *w, uint *cb)
{
	//Socket...
// 	qDebug("Constructor");
	cancel=false;
	pause=false;
	status=Ready;
	
	
	lineBufSize=1000;
    line=new char[lineBufSize];
	bufferSize=100000;
	buffer=new char[bufferSize];
	watermark=buffer;
// 	kes = new KExtendedSocket();
	kes = new QSocketDevice(QSocketDevice::Stream);
	kes->setBlocking(true);
    error=NntpThreadSocket::No_Err;
	
	isLoggedIn=false;
	newsGroup="";
	//Thread...
    parent=w;
    curbytes=cb;
//     retries=0;
    nHost=0;
	saveFile=0;
	datamemSize=DATAMEM_SIZE;
// 	keymemSize=KEYMEM_SIZE;

//     cancel=false;
	
	
	

	
}

bool NntpThreadSocket::addJob()
{
	
// 	qDebug("Entering NntpThreadSocket::addJob()");
    
    
    if (nHost == 0) {
		nHost=job->nh; //Redundant, but oh, well :)
		error=NntpThreadSocket::No_Err;
				
	}
// 	timeout=(nHost->timeout*1000);
	timeout=nHost->timeout;
// 	retries=nHost->tries;
// 	timeout=10;

	




    switch (job->jobType) {
		
    case Job::GetPost:
		db=job->ng->getDb();
		
// 		qDebug("NntpThread::addJob(): adding GetPost job");
//         *status=NntpThreadSocket::NewJob;
// 		qDebug("Savefile: %s", (const char *) job->fName);
        saveFile=new QFile(job->fName);
        if (!saveFile->open(IO_WriteOnly|IO_Truncate)) {
//             qDebug("Failed to open file: %s", (const char *) job->fName);
			error=Write_Err;
			errorString="Cannot open file " + job->fName ;
			return false;
            
        }
//         newsGroup=job->ng->ngName;
		artNum=job->artNum;
		lines=0;
// 		articles=0;
		articles=job->artSize;
		
		//*curbytes=0;
		
        return true;

        break;
    case Job::UpdHead:
		
		saveFile=new QFile(job->fName);
		if (!saveFile->open(IO_WriteOnly|IO_Truncate)) {
			qDebug("Failed to open file: %s", (const char *) job->fName);
            
			//Remember to set the error...what to do if I can't open the file?
			error=Write_Err;
			errorString="Cannot open file " + job->fName ;
			return false;
		}
		db=job->ng->getDb();
		newsGroup=job->ng->ngName;
		lines=0;
		articles=0;

		
        return true;
        break;
	case Job::GetList:
		 
         db=job->ag->getDb();
		 job->ag->startUpdating();
// 		 data=new Dbt;
//          datamem=new uchar[DATAMEM_SIZE];
//          data->set_flags(DB_DBT_USERMEM);
//          data->set_data(datamem);
//          data->set_ulen(DATAMEM_SIZE);
// 		 
// 		 key=new Dbt;
// 		 keymem=new uchar[KEYMEM_SIZE];
// 		 key->set_flags(DB_DBT_USERMEM);
// 		 key->set_data(keymem);
// 		 key->set_ulen(KEYMEM_SIZE);
		 lines=1;
		 articles=1;
		 return true;
		break;
    default:
        return false;
        break;

    }
    return false; //job NOT added;



	
}



bool NntpThreadSocket::m_readLine()
{
	if ((lineEnd=m_findEndLine(buffer, watermark))) {
		
		lineEnd[0]=0;
		lineEnd[1]=0;
		lineEnd+=2;
		lineSize=lineEnd-buffer;
        

		if (lineSize > lineBufSize) {
//     		qDebug("Line Buffer overflow");
// 			qDebug("LineSize: %d", lineSize);
			lineBufSize=lineSize+1000;
			delete [] line;
			line=new char[lineBufSize];
			
			
		}
		memcpy(line, buffer, lineSize);
    	
    	memmove(buffer,lineEnd,watermark-lineEnd);
		
		watermark-=lineSize;
		return true;
	}else return false;
	
	
}

bool NntpThreadSocket::getArticle()
{
// 	qDebug("GetArticle!");
	
	if (!m_connect()) {
		qDebug("getArticle(): can't connect");
        return false;
	}
	error=NntpThreadSocket::No_Err;
	
	if (job->mid == QString::null) {
// 		kdDebug() << "Getting by number\n";
		if (newsGroup != job->ng->ngName) {
			newsGroup=job->ng->ngName;
			cmd = "group " + newsGroup + "\r\n";
	// 		qDebug("Command: %s", cmd.latin1());
			if (!m_sendCmd(cmd, NntpThreadSocket::group))
				return false;	
		}
		
		
		
	// 	qDebug("Getting article #%d", artNum);
		cmd="body " + QString::number(artNum) + "\r\n";
	// 	qDebug("Command: %s", cmd.latin1());
// 		kdDebug() << "Getting article " << artNum << endl;
		if (!m_sendCmd(cmd, NntpThreadSocket::body))
			return false;
	} else {
// 		kdDebug() << "Getting by mid\n";
		
		QString cmd = "body <" + job->mid + ">\r\n";
// 		kdDebug() << "mid: " << job->mid << endl;
// 		kdDebug() << "Sending command: " << cmd << endl;
// 		if (!m_sendCmd(cmd, NntpThreadSocket::article))
		if (!m_sendCmd(cmd, NntpThreadSocket::body))
			return false;
	}
	
	int partialLines=0;
	
	prevTime=QTime::currentTime();
		
	while(!((line[0] == '.') && (line[1] == '\0'))) {
		if (!waitLine())
			return false;
		while (m_readLine()) {
			if (line[0] == '.') {
				if (line[1] == '.') {
					if ( (saveFile->writeBlock(line+1, strlen(line+1) ) == -1) || \
										 (saveFile->writeBlock("\r\n", 2) == -1) ) {
// 										 ( saveFile->putch('\r')  == -1) 
// 								|| (saveFile->putch('\n' ) == -1) )  {
						//Write error...urgh! :)
						error=Write_Err;
						errorString="I/O error";
						reset();
						return false;
					} 
				} else {
					break;
					
					//finished
				}
			} else  {
				/*if (articles==0) {
					QString s=line;
					if (s.left(6) == "Lines:") {
						QStringList qs=QStringList::split(' ', s, true);
						articles=qs[1].toInt();
						if (articles < 100)
							articles=100;
// 						qDebug("Lines: %d", articles);
						lines=0;
					}
				}*/
				if ( (saveFile->writeBlock(line, strlen(line) ) == -1) || \
								  (saveFile->writeBlock("\r\n",2) == -1)  ) {
// 								  ( saveFile->putch('\r') == -1 ) || 
// 								  ( saveFile->putch('\n') == -1 ) ) {
					//Write error...urgh! :)
					error=Write_Err;
					errorString="I/O error";
					reset();
					return false;
					
				}
				
			}
			*curbytes+=strlen(line);
			lines+=strlen(line);
						
			currentTime=QTime::currentTime();
				
			
		}
// 		if ((articles != 0) && (prevTime.secsTo(currentTime) > 1)) {
		if ( prevTime.secsTo(currentTime) > 1) {
			partialLines=lines-partialLines;
			NntpThreadEvent *ce=new NntpThreadEvent(job, NntpThreadSocket::Working, lines, articles, partialLines);
			QApplication::QApplication::postEvent(parent,ce);
			prevTime=QTime::currentTime();
			partialLines=lines;

			}
		
		
	}
	
	//send a "final" progress message, to correctly update the post lines
	partialLines=lines-partialLines;
	NntpThreadEvent *ce=new NntpThreadEvent(job, NntpThreadSocket::Working, lines, articles, partialLines);
	QApplication::postEvent(parent,ce);
	prevTime=QTime::currentTime();
	partialLines=lines;
	
	queueLock->lock();
	job->status=Job::Finished_Job;
	queueLock->unlock();
	
	
// 	qDebug("Got article");
	//Cancel or finished?
	statusLock.lock();
	if ( cancel  ) {
		//delete the socket & empty the buffer...
		reset();
		
		cancel=false;
		statusLock.unlock();
		return false;
	} else {
		statusLock.unlock();
		return true;
	}
	
	
	
	
}

void NntpThreadSocket::closeConnection( )
{
// 	if (*status != NntpThreadSocket::Ready) {
// 		//Should never happen, don't even know if it's possible...
// 		qDebug("Error: trying to qui an active thread");
// 		return;
// 	}
	if (!isLoggedIn)
		return;
	
	cmd = "quit\r\n";
	error=NntpThreadSocket::No_Err;
	if (!m_sendCmd(cmd, NntpThreadSocket::quit));
// 		qDebug("Error sending quit command");
	reset();
	
	
}

bool NntpThreadSocket::getListOfGroups( )
{
	
    if (!m_connect()) {
		qDebug("getListOfGroups(): can't connect");
        return false;
	}
	
    error=NntpThreadSocket::No_Err;
    cmd = "list\r\n";
    
	if (!m_sendCmd(cmd, NntpThreadSocket::list))
		return false;	
	
	while (!(line[0] == '.') && !(line[1] == '\0')  ) {
		if (!waitLine())
			return false;
		
		
		
		while (m_readLine()) {
			if ( (line[0] == '.') && (line[1] == '\0') )
				break;
			else {
								
				
        		*curbytes += strlen(line);
				
				
				
        		// put the group in the group db...
				

				if (dbGroupPut(db, line, nHost->id) != 0) {
					qDebug("dbGroupPut() failed");
					
				}
					
				
			}
		
		
		}
	}
	//Update NewsGroup
	
		
	
	db->sync(0);
	if (cancel) {
		//delete the socket & empty the buffer...
		reset();
		return false;
	} else return true;
	
	
}

int NntpThreadSocket::dbGroupPut( Db * db, const char *line, int hostId )
{
	int ret;
	Dbt listkey, listdata;
	
	listdata.set_flags(DB_DBT_MALLOC);
	//build the key...
	QString s=line;
	QStringList fields=QStringList::split(' ', s, true);
	QString ngName=fields[0];
	int articles = fields[1].toInt() - fields[2].toInt();
	if (articles < 0)
		articles = 0;
// 	kdDebug() <<"Articles: " << articles << endl;
// 	QString desc=fields[1];
	const char *i= (const char *) ngName;
	listkey.set_data((void*)i);
	listkey.set_size(ngName.length());
// 	kdDebug() << "Articles on " << ngName << ": " << articles << endl;
	
// 	memcpy(keymem, i, ngName.length());
	
// 	key->set_size(ngName.length());
	ret=db->get(NULL, &listkey, &listdata, 0);
	if (ret == ENOMEM)
		qDebug("Memory error?? WTF??");
	if (ret == DB_NOTFOUND) {
		
		//Not found, create new group and insert into db
		Group *g=new Group(ngName, QString::null , hostId, articles);
// 		g->setArticles(hostId, articles);
		//save into db...
		char *p=g->data();
		
		//key is already built, build data
// 		memcpy(datamem, p, g->size());
// 		data->set_size(g->size());
// 		delete p;
		
		listdata.set_data(p);
		listdata.set_size(g->size());
		
		ret=db->put(NULL, &listkey, &listdata, 0);
		if (ret != 0)
			qDebug("Error inserting into groups db: %d", ret);
		delete p;
		return ret;
		
	} else if (ret == 0) {
		//found, update and resave
		Group *g = new Group((char*)listdata.get_data());
		free(listdata.get_data());
		g->addHost(hostId);
		g->setArticles(hostId, articles);
		char *p=g->data();
// 		memcpy(datamem, p, g->size());
// 		data->set_size(g->size());
		listdata.set_data(p);
		listdata.set_size(g->size());

		ret=db->put(NULL, &listkey, &listdata, 0);
		if (ret != 0)
			qDebug("Error updating group db: %d", ret);
		delete p;
		return ret;
	} else qDebug("WTF??, %d", ret);
		return -1;
	
}

void NntpThreadSocket::reset( )
{
	kes->close();
	delete kes;
	kes = new QSocketDevice(QSocketDevice::Stream);
	isLoggedIn=false;
// 	*status=NntpThreadSocket::Ready;
	watermark=buffer; //buffer emptyied :)
	kes->setBlocking(true);
	newsGroup="";
	
}

//New version of connect...won't say what I think about QSocketDevice :)

bool NntpThreadSocket::myConnect( const QHostAddress & addr, Q_UINT16 port )
{

	kes->setBlocking(false);
	int count=0;
	kes->connect(addr, port);
	
	pollfd pfd;
	pfd.fd=kes->socket();
	pfd.events=POLLOUT;
	int ret;

	while ( (ret=poll(&pfd, 1, 1000)) != 1 && !(cancel) ) {
		
		if ( ret == 0) {
			//timeout, increase count and check for timeout
			
			count ++;
			if (count >= timeout) {
				//Timeout, return false
				errorString="Timeout while connecting";
				error=NntpThreadSocket::Timeout_Err;
				reset();
				return false;
			}
		} else if (ret == -1) {
			//polling error, check and return false
			if ( (pfd.revents & POLLERR) == 1) {
				qDebug("Pollerr");
				errorString="Poll error";
				error=NntpThreadSocket::Comm_Err;
				
				
			} else if ( (pfd.revents & POLLHUP) == 1) {
				qDebug("Hung up");
				//set the error
				errorString="Socket hung up";
				error=NntpThreadSocket::Comm_Err;
			} else if ( (pfd.revents & POLLNVAL) == 1) {
				qDebug("Invalid request");
				errorString="Invalid request";
				error=NntpThreadSocket::Comm_Err;
					
			}
			reset();
			return false;
		} 
		
	}
	//exited loop, state changed or canceled?
	//Canceled?
	if (cancel) {
		statusLock.lock();
		reset();
		statusLock.unlock();
		return true;
	}
	//Ok, not canceled, check if we're really connected
	int err;
	socklen_t szInt=sizeof(int);
	ret=getsockopt(kes->socket(), SOL_SOCKET, SO_ERROR, &err, &szInt);
	if (ret != 0) {
		qDebug("Error getting socket options");
		errorString="Internal error reading socket";
		error=Comm_Err;
		reset();
		return false;
	}
	if (err != 0) {
		//Error!
		
		switch (err) {
			
			case ETIMEDOUT:
					//No error, it's a timeout
				errorString="Timeout while connecting";
				error=NntpThreadSocket::Timeout_Err;
				break;
			case EACCES:
			case EPERM:
				errorString="OS or firewall prohibited the connection";
				error=NntpThreadSocket::Comm_Err;
				break;
			case ECONNREFUSED:
				errorString="Connection refused";
				error=NntpThreadSocket::Comm_Err;
				break;
			case ENETUNREACH:
				errorString="Network failure while connecting";
				error=NntpThreadSocket::Comm_Err;
				break;
			default:
				errorString="Unknown error while connecting: " + QString::number(ret);
				error=NntpThreadSocket::Comm_Err;
				break;
		}
		reset();
		return false;
	}
	

//ok, ret is 0, no error, no cancel
	kes->setBlocking(true);
	return true;
	
		
	
	
}

//qId is now redundant....

Job *NntpThreadSocket::findFreeJob()  {
	
	
	
	QValueList<int>::iterator it;
	QMap<int, Part*>::iterator pit;
	QItem *item;
	Job *j;
	//For every item...
	queueLock->lock();
	for (it = threadQueue->begin(); it != threadQueue->end(); ++it) {
		//for every part of the item...
// 		qDebug("Thread %d: trying item %d", threadId, *it);
		item=(*queue)[*it];
// 		qDebug("item's part count: %d", item->parts.count());
		for (pit = item->parts.begin(); pit != item->parts.end(); ++pit) {
			//check every job of the item...
// 			qDebug("Trying part %d of item %d", pit.key(), *it);
			j=pit.data()->job;
			if ( (j->status==Job::Queued_Job) && (j->qId == qId) ) {
			
// 			if ((! (j->jobType==Job::UpdHead) || !(j->ng->updating)) && 
				if  (!(j->jobType==Job::GetList) || !(j->ag->isUpdating()) ) {
		
// 					qDebug("Job: %d", j->id);
					j->status=Job::Processing_Job;
					if (j->jobType==Job::UpdHead)
						j->ng->startUpdating();
					j->threadId=threadId;
					queueLock->unlock();
					return j; //Returns the job pointer...
					
				}
			}
		} 
	}
	queueLock->unlock();
// 	qDebug("thread %d: job not found", threadId);
	return 0;

}

void NntpThreadSocket::tCancel( )
{
	statusLock.lock();
	cancel=true;
	statusLock.unlock();
	
}

void NntpThreadSocket::tPause( )
{
	statusLock.lock();
	pause=true;
	statusLock.unlock();
}

void NntpThreadSocket::tResume( )
{
	if (running()) {
		qDebug("Thread running");
		return;
	}
	
	statusLock.lock();
	if (status != Delayed_Delete) {
		qDebug("Resuming thread");
		pause=false;
		status=Working;
		start();
	}
	statusLock.unlock();
	
}

void NntpThreadSocket::tStart( )
{
	//Start the thread...
	if (running())
		return;
	statusLock.lock();
	if (status == Ready) {
		status=Working;
		start(); //Hmmmmm....:-?
	}
	statusLock.unlock();
	
	
}

