/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "prefheader.h"
#include "globals.h"
#include <qcheckbox.h>
#include <qradiobutton.h>

PrefHeader::PrefHeader(QWidget* parent, const char* name, WFlags fl)
: PrefHeaderLayout(parent,name,fl)
{
	showFrom=Config().showFrom;
	fromCheck->setChecked(showFrom);
	
	showDetails=Config().showDetails;
	detailsCheck->setChecked(showDetails);
	
	
	showDate = Config().showDate;
	dateCheck->setChecked(showDate);
	
	allowExpansion=Config().allowExpansion;
	expandCheck->setChecked(allowExpansion);
	
	alwaysdb=Config().alwaysDoubleClick;
	viewCheck->setChecked(alwaysdb);
		
	remember=Config().keepListSettings;
	memCheck->setChecked(remember);
	
	headerOpt=Config().markOpt;
	if (headerOpt == Configuration::Ask)
		askBtn->setChecked(true);
	else if (headerOpt == Configuration::No)
		nullBtn->setChecked(true);
	else markBtn->setChecked(true);
	
	
}

PrefHeader::~PrefHeader()
{
}

/*$SPECIALIZATION$*/


#include "prefheader.moc"

