/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KLIBIDO_QUEUEPARTS_H_
#define _KLIBIDO_QUEUEPARTS_H_

#include <qthread.h>

#include "nntpthreadsocket.h"
#include <klistview.h>
#include "globals.h"
#include <qtimer.h>

//For UULib
#define PROTOTYPES
#include <uudeview.h>
#include "uudecoder.h"
#include "yydecoder.h"
 
#define DECODETHREADEVENT 64531
#define SAVEQTHREADEVENT 64534
#define SPEED_MEAN 5


#define RETRYCOUNT 5
//Stops the thread of xx seconds for timeoutErr...
static const int retryTimeouts[] = {1, 5, 10, 30, 60};



enum QItemType {UpdItem=0, ArtItem=1, PostItem=2};

class QPostItem;

class DecodeThreadEvent : public QCustomEvent {

	friend class QMgr;
	friend class NntpThreadSocket;
	

private:
	bool ok;
	QPostItem *item;
	QString error;
	QString fileName;
	bool diskErr;	
	
public:
	
	DecodeThreadEvent(bool b, QPostItem* i, bool de=false) : QCustomEvent(DECODETHREADEVENT) , ok(b), item(i), 
			diskErr(de) {};
	void setError(const char *e) {error=e;};
	void setFileName(QString fn) {fileName=fn;};
		
};



class DecoderThread: public QThread {
	protected:

		QValueList<QPostItem*> *items;
		bool overWrite; //if false, rename

		QMutex *listLock;
		//True = continue, false = stop (fatal error, i.e. disk full)
		virtual bool decode(QPostItem*)=0;
		QWidget *parent; //where to send decoding messages
		QPostItem* item;	

		
	public:
		DecoderThread(QWidget *, QMutex*, QValueList<QPostItem*>*);
		virtual void setOverWrite(bool o)=0;
		
	
};

class DecodeThread : virtual public DecoderThread {

	protected:
		virtual bool decode(QPostItem*);
	public:
		DecodeThread(QWidget *, QMutex*, QValueList<QPostItem*>*);
		void setOverWrite(bool o) {overWrite=o;}
		virtual void run();
		

		
		
};


class SelfDecodeThread : virtual public DecoderThread {
	protected:
		Decoder *decoder;
		Decoder* getDecoderForPost(QStringList);
		virtual bool decode(QPostItem*);
		QString destDir;
		int parts;
	public:
		SelfDecodeThread(QWidget *, QMutex*, QValueList<QPostItem*>*);
		virtual void run();
		void setOverWrite(bool o) {overWrite=o;}
};

class NntpThreadSocket;

class Thread  : public QObject {
	Q_OBJECT
		private:
				
			uint serverId;  
			uint threadId;
			
			uint retryCount;
			uint threadTimeout;
			NntpThreadSocket *nt;
			uint timeout;
			
			uint *threadBytes; //bytes info...
			uint prevBytes;		//Previous bytes, for speed...this will change
			uint priority;  //Probably :) obsolete
			QString name;
			QTimer *speedTimer;
			QTimer *idleTimer;
			QTimer *retryTimer;
			
			//Speed calculation
			QTime prevTime;
			QTime curTime;
			int speedBytes[SPEED_MEAN][2];
			int speedIndex;
			int interval;
			float bytes;
			void resetSpeed();
			
			

			//Autovalue, to be passed to the thread...
// 			QMutex statusLock;
			
			//Passed from the queueManager...
			QValueList<int> *threadQueue;
			QMap<int, QItem*> *queue;
			QMutex *queueLock;
			
		public:
			Thread(uint _serverId, uint _threadId, uint to, uint rc, QWidget *p);
			~Thread();
			void start();
			void started();
			void pause();
			void paused();
			void resume();
			bool stop();
			void threadCancel();
			void resetRetryCounter();
// 			uint getStatus() {return *status;};
// 			uint getControl() {return *control;};
// 			void setStatus(uint s) {status=s;};
// 			void setJob(Job *j);
			bool isActive() {return nt->running();};
			void error();
			void comError();
			void canceled();
			void kill();
// 			void lock() {statusLock.lock();};
// 			void unlock() {statusLock.unlock();};
			void wait() {nt->wait();};	
			void setQueue(QValueList<int> *tq, QMap<int, QItem*> *q, QMutex *qLock, int*po);
			
			
			
	private slots:
			void slotSpeedTimeout();
			void slotIdleTimeout();
			void slotRetryTimeout();
	signals:
			void sigThreadSpeedChanged(int, int, int);
			void sigThreadDisconnected(int, int);
			void sigThreadResumed();
			void sigThreadPaused(int, int, int);
			
	
			
					
	
		
};




/**
@author Alessandro Bonometti
*/

struct Part {
	int status;	//status of the part
	KListViewItem* listItem;	//the listViewItem that is showing the part
	QString desc;	//the description of the part
	int jobId; //JobId of the part...
	int qId; //Where this part is queued
	Job *job;  //Hmmmmm...
	
	
};
	

struct QSaveItem {
	
	//This should be enough to retrieve the binHeader from the Db...
	QString group;
	QString index;
	
	
	//Info about already saved parts
	QString rootFName;
	QString savePath;
	QString tmpDir;
	
	uint curPostLines;
	
	int id;
	int modPart;
	int modStatus;
	int type;
	enum QSI_Type { QSI_Add, QSI_Update, QSI_Delete};
	
	//partID/status of the parts of the post.
	QMap<int, int> partStatus;
	
};

class SaveQThreadEvent: public QCustomEvent
{
	friend class QMgr;
	private:
		int event;
		QString nzbIndex;
	public:
		enum SQT_Event {SQT_DelNZB, SQT_Error};
		SaveQThreadEvent(int e, QString index = QString::null) : QCustomEvent(SAVEQTHREADEVENT), event(e), nzbIndex(index) {}
	
};

class SaveQThread: public QThread
{
	protected:
		Dbt key, data;
		QMutex *saveQLock;
		QValueList<QSaveItem*> *saveQItems;
		QSaveItem *item;
		Db *saveQDb;
		QWidget *parent;
		bool writeSaveItem(QSaveItem *);
		QSaveItem* readSaveItem(int);
		bool processItem(QSaveItem *);
		bool updateItem(QSaveItem*);
		bool delSaveItem(int id);
		int saveItemSize(QSaveItem *);
		char* saveItemData(QSaveItem *);
		QSaveItem *loadSaveItem(char*);
		char* insert(QString s, char* p);
		char* retrieve(char* i,QString &s);
		
		
	public:
		virtual void run();
		SaveQThread(QValueList<QSaveItem*> *list, QMutex *lock, Db *qDb, QWidget *p = 0);
// 		~SaveQThread();
};


class QItem :public QObject{
	// Need to access the variables from the qItem's children
	Q_OBJECT
	friend class QMgr;
	friend class DecodeThread;
	friend class SelfDecodeThread;
	friend class NntpThreadSocket;
protected:
	enum PartStatus {Finished_Part=0, Processing_Part=1, Failed_Part=2, Queued_Part=3, Canceled_Part, Paused_Part, Requeue_Part};
	enum ItemStatus {Finished_Item=0, Processing_Item=1, Failed_Item=2, Queued_Item=3, Canceled_Item, Paused_Item};
	enum OnError { Continue, Finished, RequeMe };
	int qItemId; //id of this item
	int type;	//type of item
	int status;	//status of the whole item
	int partsToDo;
	int failedParts;
	int workingThreads;
	int totalParts;
	QMap<int, bool> queuePresence;
	QMap<int, Part*> parts;  //partId->part*
	

	KListViewItem *listItem;

signals:
	// OR: QMgr->addJob...hmmm...
	
	
public:
	
	virtual void addJobPart(int jobId, int partId, Part* part)=0;
	virtual void update(int partId,  int partial, int total,int)=0;
	virtual bool finished(int partId);
	virtual int error(int partId, QString &error)=0;
	virtual void comError(int partId)=0;
	virtual void canceled(int partId);
	virtual void paused(int partId);
	virtual void resumed(int partId);
	virtual void requeue(int partId);
	virtual void start(int);
	
	QItem(KListView *parent, int id, int _type, NewsGroup *_ng);
	QItem(KListView *parent, int id, int _type, BinHeader *bh, bool first);
	QItem(KListView *parent, int id, int _type);
	QItem(KListView *parent, int id, int _type, QString subj, bool first);
	
	


};

class QUpdItem: public QItem {
	private:
// 		Db* gdb;
		
	public:
		QUpdItem(KListView *parent, int id, NewsGroup *ng );
		~QUpdItem();
		// 		virtual int fillJob(ThreadMap tm, Job *job);
		virtual void update(int partId, int partial, int total, int);
		virtual void addJobPart(int jobId, int partId, Part* part);
		virtual bool finished(int partId);
		virtual int error(int partId, QString &error);
		
		virtual void comError(int partId);
		
		void startExpiring(int partId);
		void stopExpiring(int partId);
		void startUpdateDb(int partId);
		void stopUpdateDb(int partId);
		void downloadFinished(int partId);
		

};

class QListItem:public QItem {
	private:
		Db* groupsDb;
		
	public:
		QListItem(KListView *parent, int id, Db *gdb);
		~QListItem();
		virtual void addJobPart(int jobId, int partId, Part* part);
		virtual bool finished(int partId);
		virtual int error(int partId, QString &error);
		virtual void update(int, int,int,int);
		virtual void comError(int) {}
		
};


class QPostItem :public QItem {
	Q_OBJECT
	friend class QMgr;
	private:
		bool view;
		BinHeader *post;   //Do I need it?? Hmmmm...
		QString rootFName;
		QString savePath;
		uint totalPostLines;
		uint curPostLines;
		uint intervalPostLines;
		uint retryCount;
		uint partialLines;
		QTimer *etaTimer;
		int etaTimeout;
		bool overwriteExisting;
		bool deleteFailed;
		
		QTime prevTime, curTime;
// 		int etaCount;
		
	public:

		QPostItem(KListView *parent, int id, BinHeader *bh, QString rfn, QString _savePath, bool first, bool _view);
		QPostItem(KListView *parent, int id, QString subj, QString rfn, QString _savePath, bool first, bool _view);
		~QPostItem();
		virtual void update(int partId, int partial, int total, int);
		virtual void addJobPart(int jobId, int partId, Part* part);
		void addJobPartWithStatus(int jobId, int partId, Part *part, int status);
		virtual bool finished(int partId);
		virtual int error(int partId, QString &error);
		virtual void start(int);
		virtual void canceled(int partId);
		virtual void comError(int partId);
		void deletePost() {delete post;};
		bool over() {return overwriteExisting;};
		bool dFailed() {return deleteFailed;};
		void setTotalLines (uint tl) {totalPostLines=tl;}
		
		
		QString getFName() {return rootFName;};
		char *getSavePath() {return (char*) savePath.latin1();};
		void decodeFinished();
	signals:
		void decodeMe(QPostItem*);
			
				
	private slots:
		void slotEtaTimeout();
// 		QPostItem(int _qItemId, QMap <int, NntpHost> _servers, NewsGroup *_ng, BinHeader* _post);
	
	
};

#endif //_KLIBIDO_QUEUEPARTS_H
