/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "header.h"


uint Header::size() {

    return 8*sizeof(uint)+ m_from.length() + m_subj.length() + m_lines.length() + m_mid.length() + m_bytes.length() + m_date.length() + serverNum.count()*(2*sizeof(uint));

}

uchar* Header::insert(QString s, uchar* p) {
    int strlen=s.length();
    int suint = sizeof(strlen);
    memcpy(p, &strlen, suint);

    p+=suint;
    memcpy(p, (const char *)s, strlen);
    p+=strlen;
    return p;



}

Header::Header(NntpHost *h, QStringList field) {
    serverNum.insert(h->id, field[0].toInt());
    // 	cout << "Inserted: " << "id: " << h->id << ", " << "Num: " << field[0].toInt() << endl;
    m_subj=field[1];
    m_from=field[2];
    m_date=field[3];
    m_mid=field[4];
    m_bytes=field[6];
    m_lines=field[7];
}


uchar *Header::data() {



    uchar *p=new uchar[size()];
    uchar *i=&p[0];

    i=insert(m_subj, i);
    i=insert(m_from, i);
    i=insert(m_lines, i);
    i=insert(m_mid,i);
    i=insert(m_bytes,i);
    i=insert(m_date,i);


    //copy fixed length fields...no big deal
    int szInt=sizeof(uint);
    //status field

    memcpy(i, &status, szInt);
    i+=szInt;

    //how many items in the map?
    int mapItems=serverNum.count();
    memcpy(i, &mapItems , szInt);
    i+=szInt;

    //Couples serverid-article number (at least 1)
    int serverId, artNum;

    for (it = serverNum.begin() ; it !=serverNum.end(); ++it) {
        serverId=it.key();
        artNum=it.data();
        memcpy(i, &serverId, szInt);
        i+=szInt;
        memcpy(i, &artNum, szInt);
        i+=szInt;
    }





    return p;




}

uchar* Header::retrieve(uchar* i,QString &s) {

    int strlen;
    int ssize=sizeof(strlen);

    char *temp;
    memcpy(&strlen, i, ssize);

    i+=ssize;
    temp=new char[strlen+1];
    memcpy(temp, i, strlen);
    temp[strlen]='\0';
    s=temp;
    delete temp;
    i+=strlen;
    return i;



}


Header::Header(uchar *p) {


    uchar *pi =&p[0];


    // Variable-lenght fields

    pi=retrieve(pi,m_subj);
    pi=retrieve(pi,m_from);

    pi=retrieve(pi,m_lines);
    pi=retrieve(pi,m_mid);
    pi=retrieve(pi,m_bytes);
    pi=retrieve(pi,m_date);

    // Fixed-size fields:
    int szInt=sizeof(int);

    //status
    memcpy(&status, pi, szInt);
    pi+=szInt;

    uint mapItems, serverId, artNum;
    // mapItems
    memcpy(&mapItems, pi, szInt);
    pi+=szInt;


    for (uint i = 0; i < mapItems; i++) {
        memcpy(&serverId, pi, szInt);
        pi+=szInt;
        memcpy(&artNum, pi, szInt);
        pi+=szInt;
        serverNum.insert(serverId, artNum);
    }




}

Header::Header( QStringList field)
{
	if (field.count() != 9) {
		qDebug("Error parsing xover");
		qDebug("Article number: %s", (const char *) field[0]);
		qDebug("Filed 2: %s", (const char *) field[1]);
		qDebug("Filed 3: %s", (const char *) field[2]);
		qDebug("Filed 4: %s", (const char *) field[3]);
		qDebug("Filed 5: %s", (const char *) field[4]);
		
	}
				
		
	m_num=field[0].toInt();
	m_subj=field[1];
    m_from=field[2];
    m_date=field[3];
    m_mid=field[4];
    m_bytes=field[6];
    m_lines=field[7];
}

Header::Header( QString s)
{
	QStringList field=QStringList::split('\t', s, true);
	if (field.count() != 9) {
		qDebug("Error parsing xover: %s", (const char *) s);
		ok=false;
	} else ok=true;
	m_num=field[0].toInt();
	m_subj=field[1];
    m_from=field[2];
    m_date=field[3];
    m_mid=field[4];
    m_bytes=field[6];
    m_lines=field[7];
}

Header::Header(char *l) {
	QString s=l;
	QStringList field=QStringList::split('\t', s, true);
	if (field.count() != 9) {
		kdDebug() << "Error parsing xover:" << s << endl;
		kdDebug() << "String was: " << l <<endl;
		
		ok=false;
	} else ok=true;
	m_num=field[0].toInt();
	m_subj=field[1];
    m_from=field[2];
    m_date=field[3];
    m_mid=field[4];
    m_bytes=field[6];
    m_lines=field[7];
	
}





