/***************************************************************************
                          klineakconfig.cpp  -  description
                             -------------------
    begin                : Tue Apr  9 18:33:44 EDT 2002
    copyright            : (C) 2002 by Sheldon Lee Wen
    email                : tormak@rogers.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "klineakconfig.h"
#include <lineak/msgpasser.h>
#include <lineak/definitions.h>
#include <lineak/lineak_core_functions.h>
#include <lineak/configdirectives.h>
#include <lineak/pluginmanager.h>
#include <lineak/plugin_definitions.h>
#include <lineak/definitions.h>
#include <lineak/cdromctrl.h>
#include <lineak/displayctrl.h>
#include <lineak/saver.h>
#include <lineak/lcommand.h>

#include <map>
#include <vector>
#include <string>
#include <kstddirs.h>

using namespace std;
extern bool verbose;
extern KlineakConfig *klineakconfig;

KlineakConfig::KlineakConfig(QWidget *parent, const char *name) : KlineakConfigUI(parent, name)
{
   ApplyUsed=false;
   changeMade=false;
   selected_key=0;
   got_def = false;
   got_conf = false;
   changing_text_from_signal=false;
   //myEAK=&p.myEAK;
   lineakd = NULL;
   plugins = NULL;
   verbose = false;
   //myKbd = NULL;
   cout << "Starting!" << endl;
   QFile filename;
   QString parsefile = QString::null;
   parsefile = QDir::homeDirPath() + CONFFILE;
    
   cout << "Loading the plugin manager" << endl;      
   plugins = new PluginManager;
   vector<string> pluginlist = plugins->scanForPlugins();
   /** Load the plugins */
   plugins->loadPlugins(pluginlist);
   /** Define the list of macros we support */
   plugins->defineMacroLists();
   /** Define the configurate directives we support */
   plugins->defineDirectivesLists();
   /** Get a list of macros we support so that we can inform other classes */
   macrolist = plugins->getMacroList();
   /** Get a list of directives and their defaults that we support here */
   dnd = plugins->getDirectivesList();
   cout << "Setting dnd!" << endl;
   /** Add to the list of directives and defaults that we support implicitly. */
   dnd.addValue(_CD_KEYBOARD_TYPE, snull);
   dnd.addValue(_CD_USERCONFFILE, snull);
   dnd.addValue(_CD_CDROM_DEVICE, DEFAULT_CDROM_DEVICE);
   dnd.addValue(_CD_MIXER_DEVICE, DEFAULT_MIXER_DEVICE);
   dnd.addValue("Screensaver", snull);
   dnd.addValue("Display_plugin",DEFAULT_DISPLAY_PLUGIN);
   dnd.addValue("Display_font", DISPLAY_FONT);
   dnd.addValue("Display_color", DISPLAY_COLOR);
   dnd.addValue("Display_pos", DISPLAY_POS);
   dnd.addValue("Display_align", DISPLAY_ALIGN);
   dnd.addValue("Display_timeout", DISPLAY_TIMEOUT);
   dnd.addValue("Display_hoffset", DISPLAY_HOFFSET);
   dnd.addValue("Display_voffset", DISPLAY_VOFFSET);
   dnd.addValue("Display_soffset", DISPLAY_SOFFSET);
   dnd.addValue("keystate_numlock", snull);
   dnd.addValue("keystate_capslock", snull);
   dnd.addValue("keystate_scrolllock", snull);

   /** Set the macrolist for all LCommand objects */
   LCommand::setMacros(macrolist);
   
   //TODO define these properly so that signals are inherited.
   signal(SIGTERM, signalquit);
   signal(SIGABRT, signalquit);
   signal(SIGINT, signalquit);
   /* and one so we won't have to wait() for child processes ;) */
   //signal(SIGCLD,signalchild);
   /* and for a rehash when we catch SIGHUP */
   //signal(SIGHUP, signalrestart);
   /* everything went according to plan thisfar... some signal-handlers for cleaner exiting */
   /* and one so we won't have to wait() for child processes ;) */
   //signal(SIGCLD,SIG_IGN);
   signal(SIGCLD,signalchild);
   /* and for a rehash when we catch SIGHUP */
   signal(SIGHUP,signalhup);
   
   /** Set up the system tray applet */
   systemTrayApp = new Klineak(this);
   connect(systemTrayApp,SIGNAL(toggleApp()),this,SLOT(slotToggleApp()));
   //connect(this,SIGNAL(),this,SLOT(slotToggleApp()));
   connect(systemTrayApp,SIGNAL(cleanExit()),this,SLOT(quit()));

   QString homedir = QDir::homeDirPath() + LINEAKDIR;
   QDir lineakdir;
   QString picsdir = QDir::homeDirPath()  + PICSDIR;
  
   /** Test to see if the .lineak directory exists in the users home directory */
   lineakdir.setPath(homedir);
   if (!lineakdir.exists())
      lineakdir.mkdir(homedir);

   /** Test to see if the ~/.lineak/Pics/ directory exists in the users home directory */
   lineakdir.setPath(picsdir);
   if (!lineakdir.exists())
      lineakdir.mkdir(picsdir);

   /** Add the resource dirs */
   resources = KGlobal::dirs();
   // Add ROOTDIR to the prefix we will have KStandardDirs search for the image
   resources->addPrefix(ROOTDIR);
   // Add the local Pics directory to the Icon dir search path.
   resources->addResourceDir("icon", QString(QDir::homeDirPath()) + PICSDIR);
   KGlobal::dirs()->addResourceType("app_icon", QString(QDir::homeDirPath()) + PICSDIR);
   QStringList list = resources->resourceDirs("icon");
   
   QString userdeffile = QString("%1%2%3").arg(QDir::homeDirPath()).arg(LINEAKDIR).arg(DEFFILE);
   QString userconffile = QString("%1%2").arg(QDir::homeDirPath()).arg(CONFFILE);
   
   /** Setup a ConfigDirectives object w/ the required items. */
   //cout << "userdeffile = " << userdeffile << endl;
   //cout << "userconffile = " << userconffile << endl;
   
   dnd.addValue(_CD_USERDEFFILE, userdeffile.latin1());
   dnd.addValue(_CD_SYSDEFFILE, LINEAKKB_FILE);
   dnd.addValue(_CD_USERCONFFILE, userconffile.latin1());
   
   //cout << "Loading defs and configs" << endl;
      
   /** Parse the system definition file */
   /** TODO: Make a kde config file that lists all of the users def files, and load them all here. */
   //got_def = parsedef();
   //bool ret = parsedef(userdeffile);
   /** Parse the user definition file */
   //got_def = (got_def)?got_def:ret;
   if (!(got_def = parsedef())) {
       QMessageBox::information(this, "KLineakConfig", QString(
          "WARNING: KLineakConfig could parse your keyboard definition file!\n" ));
       quit();
   } 
   //cout << "printing myDef!" << endl;
   //cout << myDef;
   
   /* Make sure we have a config file. */ 
   filename.setName(parsefile);
   if (!filename.exists())
      createBasic(parsefile);
   cout << "Parsing the config files." << endl;
   /** Parse the users ~/.lineak/lineakd.conf file */
   if (!(got_conf = parseconf()))
      quit();
      
   cout << "Setting commands!" << endl;
   usleep(400000);
   myKbd.setCommands(myConfig);
   // Show the panel
   cout << "showing the system tray." << endl;
   systemTrayApp->show();
   // Show all the data in the gui widgets.
   cout << "Refreshing GUI data" << endl;
   refreshGUIdata();
   // Test and see if there are any lineakd processes running. If there are kill them or exit.
   
   int attempt = 0;
//   cout << "pid of lineakd = " << PControl::lineakdRunning() << endl;
//   if ((pid = p.lineakdRunning()) !=0) {
//   if ((pid = PControl::lineakdRunning()) !=0) {
   while (is_running("lineakd") != false && attempt < 10) {
	cout << "Killing lineakd" << endl;
   	stopLineakd();
	usleep(400000);
	attempt++;
   }  	
  cout << "starting lineakd\n";
  startLineakd();
}

KlineakConfig::~KlineakConfig() {
   plugins->unloadAllPlugins();
   delete(resources);
   delete(systemTrayApp);
   delete(plugins);
}
void KlineakConfig::slotToggleApp()
{
	if(isVisible())
		hide();
	else {
		show();
		setEnabled(true);
	}
}

bool KlineakConfig::lineakDefStart()
{
    // If it's not already running.....
    if (!klineakdef->isVisible()) {
		stopLineakd();
  		/** Parse the keyboard definitions file */
   		klineakdef->show();
   		//connect klineakdef's ok/apply or close button with lineakDefStop()
   		connect(klineakdef,SIGNAL(quitting()),this,SLOT(lineakDefStop()));
   		//connect klineakdef's ok/apply button to klineakconfig parsedef slot.
   		connect(klineakdef,SIGNAL(applying(QString)),this,SLOT(reparseDef(QString)));
   		// connect klineakdef's keyboardName signal to our setKeyboard slot
   		// connect(klineakdef,SIGNAL(keyboardName(QString)),this,SLOT(setKeyboard()));
   }
	return true;
}
/** Slot activated when KlineakDef exits. */
bool KlineakConfig::lineakDefStop()
{
   klineakdef->hide();
   startLineakd();
   return true;
}
/** Slot activated by KlineakDef's apply button. It is passed the name of the file to parse. If it is not null, then parse it. */
bool KlineakConfig::reparseDef(QString parsefile){
	cout << "reparsing" << endl;
 	if (parsefile != QString::null)
    	return (parsedef(parsefile));
   return false;
}
bool KlineakConfig::parsedef(QString parsefile) {
  QFile filename;
  
  cout << "parsing deffile" << endl;
  /** If parsefile is null, then set the default to the system lineakkb.def */
  if (parsefile == QString::null) {
     return (parsedeffile(dnd, myDef));
  }
  else {
     filename.setName(parsefile);
     if (!filename.exists()) {
        cerr << "The filename: " << parsefile << " that you want to parse does not exist!" << endl;
        return false;
     } else {
        //ConfigDirectives tmp = prefs;
	string file = "";
	if (parsefile == QString::null)
	   file = "";
	else
           file = parsefile.latin1();
	dnd.addValue(_CD_USERDEFFILE, file);
	/* parse .def files */
        if(!parsedeffile(dnd, myDef)) {
           return false;
        }
        if (got_conf) {
           changing_text_from_signal = true;
           /* refresh EAK types */
           refresh_kbtypes ();
           changing_text_from_signal = false;
        }
     }
  }
  
  return true;
}

bool KlineakConfig::parseconf(QString parsefile) {
  //QString homedir = QDir::homeDirPath();
  QString returnMsg;
  //QFile filename;

  cout << "parsing conffile\n";	
  //if (got_def) {
  //  cout << "got_def is true" << endl;
    //cout << myDef;
  //}
    
  /** First check and make sure that the conf file exists. */
  /** If parsefile is null, then set the default to the users ~/.lineak/lineakd.conf file. */
  /*
  if (parsefile == QString::null) {
     parsefile = homedir + CONFFILE;
     filename.setName(parsefile);
     if (!filename.exists())
        createBasic(parsefile);
  }
  */
  //cout << "Trying to parse the config file." << endl;
  /** Parse the .conf file. If there was some error, display it and return false. */
  if(!parseconffile(dnd, myConfig)) {
     QMessageBox::critical(this, "KLineakConfig", "Failed to parse the configuration file.");
     return false;
  }
  cout << "Do we have a def yet?" << endl;
  /** If we parsed a definition's file */
  if (got_def) {
     string kbdtxt = myConfig[_CD_KEYBOARD_TYPE];
     
     cout << "Looking for keyboard = " << kbdtxt << endl;
     
     //cout << myConfig << endl;
     if (myConfig.isEmpty())
        cout << "myConfig is empty!" << endl;
	   
     if (myDef.hasKeyboard(kbdtxt)) {
        cout << "returning the damn thing.";
        myKbd = myDef.getKeyboard(kbdtxt);
	cout << myKbd;
     }
     else {
        cout << "myDef reports that it does not have keyboard: " << kbdtxt << endl;
	cout << myDef;
	return false;
     }
     
     cout << "is myKbd empty?" << endl;
     if (myKbd.isEmpty()) {
        cout << "OH OH! it's an empty keyboard!" << endl;
	//cout << myKbd;
        QString homedir = QDir::homeDirPath(); //getenv("HOME");
        homedir+=LINEAKDIR;
        homedir+=DEFFILE;
       
        QMessageBox::information(this, "KLineakConfig",
           i18n("WARNING: KLineakConfig could not find any keys defined for your keyboard!\n"
                "You probably have a corrupt or incorrect keyboard definition file in either:\n"
                "%1\n"
                "or\n"
                "%2\n").arg(LINEAKKB_FILE).arg(homedir));
           quit();
     } else
        cout << "myKbd is not empty" << endl;
  }
  else {
     cerr << "Attepting to load the user .conf setting before we have keyboard data!" << endl;
     return false;
  }
  cout << "Returning from parseConf" << endl;
  return true;
}
/** Update the list of available keys in the list box when a new keyboard
	  is selected from the Keyboard Type combo box */
void KlineakConfig::updateAvailableKeys(const QString &keyboard) {
    string kbd = keyboard.latin1();
    cout << "myKbd.name = " << myKbd.name << endl;
    cout << "new kbd = " << kbd << endl;
    if (myKbd.model != keyboard ) {
       select_new_keyboard(keyboard);
    }
}
/** Update the list of keyboard in the Keyboard Types combo box
      when the user selects a new brand */
void KlineakConfig::updateKeyboardModels(const QString &itxt) {
   string inText = itxt.latin1();
   if (myKbd.brand != inText) {
      // Load the appropriate models.
      map<string,LKbd*> models = myDef.getModels((cbKeyboardBrand->currentText()).latin1());
      map<string,LKbd*>::iterator it = models.begin();
      
      // Clear the combo box.
      cbKeyboard->clear();
      // For each model of keyboard
      for(int m=0;it!=models.end();it++, m++)  {
         cbKeyboard->insertItem((it->second)->model);
         if(it->first == myKbd.model)
            cbKeyboard->setCurrentItem(m);
      }
      // We should now have a new keyboard in the Keyboard Type box, so update the list of keys.
      select_new_keyboard(cbKeyboard->currentText());
   }
}
/** Update the cdrom device text box */
void KlineakConfig::updateCDRom(const QString &inText) {
  string txt = inText.latin1();
  if (txt != myConfig[_CD_CDROM_DEVICE])
       myConfig[_CD_CDROM_DEVICE] = txt;
}
/** Update the mixer device text box */
void KlineakConfig::updateMixer(const QString &inText) {
  string txt = inText.latin1();
  if (txt != myConfig[_CD_MIXER_DEVICE])
       myConfig[_CD_MIXER_DEVICE] = txt;
}

// Update the keylist mappings when a radio action is selected
void KlineakConfig::updateKeyList(int index) {
  if (!radioAction->isOn())
        return;
  change_selectedkey_command(cbAction->currentText());
  changeMade=true;
}
// Update the keylist mappings when the text changes.
void KlineakConfig::updateKeyList(const QString& inText) {
  if (changing_text_from_signal)
        return;
  change_selectedkey_command(txtCommand->text());
  changeMade=true;
}

// When an item is selected in the keylist
void KlineakConfig::onKeyListSelect(QListBoxItem *box) {
  int index = lstAvailableKeys->currentItem();
  if (index != -1 ) {
  	changing_text_from_signal = true;
    refresh_keycommand(box);
    refresh_displayname(box);
    changing_text_from_signal = false;
    selected_key = lstAvailableKeys->currentItem();
  }
}
// When you click the Apply button
bool KlineakConfig::onApplyButtonClicked() {
  /* first time apply? -> backup conf file */
  if (!ApplyUsed) {
    QString returnMsg;
    ApplyUsed = true;
    // If there was some error message, display it.
    backup_conffile();
       
  }
  /* save the changes to a new conf file */
  if (!save_conffile()) {
  	QMessageBox::information(this,"KlineakConfig",i18n("ERROR: The Lineak configuration could not be saved."));	
   return false;
  }
  hide();
  /* rehash lineakd */
  hupLineakd();
  return true;
}
/** Hup the lineakd daemon.
		Return true if we hupped the daemon.
  		Return false if the daemon was not hupped */
bool KlineakConfig::hupLineakd() {
   msgPasser message;
   message.start();
   message.sendMessage(msgPasser::HUP,"hup");
   return (true);
}

/** Start the lineakd daemon.
		If lineakd is running standalone, kill it, and start under the control of klineakconfig.
		Return true if lineakd has been started by klineakconfig or if we started lineakd.
    	Return false if lineakd could not be started */
bool KlineakConfig::startLineakd() {
      /* If lineakd is not running */   		
    if (lineakd != NULL) {
    	stopLineakd();
     	delete (lineakd);
     }
    	
    lineakd = new KShellProcess();
    lineakd->clearArguments();
  	*lineakd << "lineakd";
	*lineakd << "-v";
 	lineakd->start(KProcess::DontCare,KProcess::NoCommunication);
 	if (lineakd->isRunning()) {
		cout << "Starting lineakd, pid is: " << lineakd->pid() << endl;
		/** At some point where I figure out how to get root priv's renice to -10 */
//		PControl pc;
//		pc.renice(lineakd->pid());
 		return true;
   }
 	else {
           QMessageBox::information(this, "KLineakConfig", QString(
        	i18n("WARNING: KLineakConfig could not start the easy access keyboard driver!\n")));
 			cerr << "Failed to start lineakd" << endl;
  		return false;
 	}
   return false;
}
/** Stop the lineakd daemon. If we killed it return true. Else if it could not be killed
		return false */
bool KlineakConfig::stopLineakd() {
   msgPasser message;
   message.start();
   message.sendMessage(msgPasser::EXIT,"exit");
   return (true);
}
// When the klineak quit button is clicked
void KlineakConfig::quit() {
//  int choice = KLPrefs::instance()->mLineakAtExit;
cout << "In Quit\n";
  if (ApplyUsed) {
     hupLineakd();
  }
  else {
    	if(changeMade) {
          switch( QMessageBox::warning( this, "KLineak",
                  i18n("Do you want to save your changes?\n"),
                  i18n("Apply"),
                  i18n("Quit"), 0, 0, 1 ) )  {
              case 0: // The user clicked the Apply button or pressed Enter
                  onApplyButtonClicked(); // Apply
 		  void showPreferences();
                  break;
              case 1: // The user clicked the Quit or pressed Escape
                  restore_conffile();
                  break;
          }
       }
  }
  cout << "In Quit: See if lineakd is running. Leave running or exit?\n";

  if (lineak_core_functions::is_running("lineakd")) {
     switch( KMessageBox::questionYesNo( this,  i18n(     //parent
                  "The lineakd daemon is still running.\n"
                  "Do you want to continue running lineakd in the background?\n"
                  "(If not, you will be unable to use your easy access keys.)\n\n"), //text
                  i18n("Leave lineakd running?"),  //caption
                  i18n("Run in background"),  //yes button
                  i18n("Stop lineakd"), //no button
                  "Lineakd At Exit"  ) ) {  // name of don't show again
     case KMessageBox::Yes : // The user clicked the "Run in background" button or pressed Enter
          lineakd->detach();
          break;
     case KMessageBox::No : // The user clicked the Quit or pressed Escape
          stopLineakd();
          break;
     }
  }
  cout << "In Quit: p.cleanexit()\n";

//  KLPrefs::instance()->writeConfig();
  //p.cleanexit(1);
  exit(1);
}
/* refresh *ALL* the data on the GUI (this is called on startup) */
bool  KlineakConfig::refreshGUIdata() {
  changing_text_from_signal = true;
  /* refresh EAK types */
  refresh_kbtypes ();
  /* refresh CD-ROM entry */
  refresh_cdromdev ();
  /* refresh keyboard image */
  refresh_kbimage ();
  /* refresh key list */
  refresh_keylist ();
  /* refresh command/action */
  refresh_specials ();
  refresh_keycommand (lstAvailableKeys->selectedItem());
  refresh_displayname(lstAvailableKeys->selectedItem());
  changing_text_from_signal = false;

  return (true);
}

/* refresh EAKeyboard types */
bool  KlineakConfig::refresh_kbtypes() {

    vector<string> brands = myDef.getBrands();
    vector<string>::iterator it2 = brands.begin();
    
    cbKeyboardBrand->clear();
    // Load the brands of Keyboards.
    for(int b=0;it2!=brands.end(); it2++, b++) {
       cbKeyboardBrand->insertItem(*it2);
       if (*it2 == myKbd.brand)
          cbKeyboardBrand->setCurrentItem(b);
    }
    
    cbKeyboard->clear();
    
    // Load the appropriate models.
    map<string,LKbd*> models = myDef.getModels((cbKeyboardBrand->currentText()).latin1());
    map<string,LKbd*>::iterator it = models.begin();
      
    // For each model of keyboard
    //for(int m=0;it!=p.bmmap[cbKeyboardBrand->currentText()].end();it++, m++)  {
    for(int m=0;it!=models.end();it++, m++)  {
       cbKeyboard->insertItem(it->second->model);
       if(it->second->model == myKbd.model && it->second->brand == myKbd.brand)
          cbKeyboard->setCurrentItem(m);
    }
    
   return (true);
}
/* only needed at startup */
bool  KlineakConfig::refresh_cdromdev() {
  txtCDRom->setText(myConfig[_CD_CDROM_DEVICE]);
  return (true);
}

/* refresh keyboard image */
bool  KlineakConfig::refresh_kbimage () {
   const QString pixmapname=myKbd.name;
   QPixmap tmp;
   QString localdir = QString(QDir::homeDirPath()) + PICSDIR;
   // If we don't get a valid picture for our keyboard from the system directory
   if ( load.iconPath(pixmapname,KIcon::User, true) == QString::null) {
      // Look in the users ~/.lineak/Pics/ directory for any file matching the keyboard name.
      QDir imgdir( localdir );
      imgdir.setFilter( QDir::Files );
       // Go through the list of files
       const QFileInfoList* files = imgdir.entryInfoList();
       QFileInfoListIterator it( *files );
       QFileInfo * fi;
       QString picname;
       // Go through the ~/.lineak/Pics directory and look at the picture files.
       while ( (fi = it.current()) != 0 ) {
       	if ( fi->fileName() == "." || fi->fileName() == ".." ) {
          		++it;
   				continue;
   			}
   			if ( fi->isFile() && fi->isReadable()) {
       		picname = fi->fileName();
           	if (picname.contains(pixmapname)) {
            		cout << "Found it! file = " << fi->filePath() << endl;
              	picname = fi->filePath();
           		break;
              }
       	}
   			++it;
       }  // end while
		if ( (tmp = QPixmap(picname)).isNull() )
   			tmp = load.loadIcon("noimage", KIcon::User);
    }
    else
    	tmp = load.loadIcon(pixmapname,KIcon::User);
//    cout << "Iconpath = " <<  load.iconPath(pixmapname,KIcon::User, true) << endl;
//  	pixPicture->setPixmap(load.loadIcon(pixmapname,KIcon::User));
	pixPicture->setPixmap(tmp);
  	return (true);
}

/* refresh the keylist when the user selected some other keyboard */
bool  KlineakConfig::refresh_keylist() {
  QString tmp;
  cout << "Refreshing key list" << endl;
  const map <string, LObject*> &objects = myKbd.getObjects();
  map <string, LObject*>::iterator it = const_cast<map <string, LObject*> &>(objects).begin();
  
  lstAvailableKeys->clear();
  for (; it!= objects.end(); it++) {
	tmp = it->second->getName();
	lstAvailableKeys->insertItem(tmp);
  }
  lstAvailableKeys->setSelected(0,true);
  selected_key = 0;
  return (true);
}

/* refresh the command bound to a key when it's selected */
bool  KlineakConfig::refresh_keycommand(QListBoxItem *box) {
  if (box != NULL) {
  
     string tmp = box->text().latin1();
     cout << "Setting command to: " << tmp << endl; 
     changing_text_from_signal = true;
     LObject *obj = myKbd.getObject(tmp);

     if (obj==NULL) {
	cerr << "Invalid key: " << tmp << endl;
	return (false);
     }
     LCommand &cmd = obj->getCommand();
     if (cmd.isMacro()) { // special action
	radioRun->setChecked(false);
	radioAction->setChecked(true);
	txtCommand->setText("");
	txtCommand->setEnabled(false);
	cbAction->setCurrentText(cmd.getCommand());
     } else {                                                        // system command
	radioAction->setChecked(false);
	radioRun->setChecked(true);
	txtCommand->setText(cmd.getCommand());
	txtCommand->setReadOnly(false);
     } 
  }
  changing_text_from_signal = false;
  return (true);
}
/* Set the display name text box to contain the right text. */
bool KlineakConfig::refresh_displayname(QListBoxItem *box) {
  string dpy;

  if (box != NULL) {
    string tmp = box->text().latin1();
    changing_text_from_signal = true;
    
    LObject *obj = myKbd.getObject(tmp);
    if (obj==NULL) {
	  cerr << "Invalid key: " << tmp << endl;
	  return(false);
    }
    //FIXME: Get what the current modifiers are so we are getting the right thing.
    dpy = obj->getCommandDisplayName();
    txtDisplayName->setText(dpy);
  }
  changing_text_from_signal = false;
  return (true);
}

/* refill special action menu (only needed on startup) */
bool  KlineakConfig::refresh_specials () {
   for ( vector<string>::iterator it=macrolist.begin(); it < macrolist.end(); it++) {
      cbAction->insertItem(*it);
   }

  return (true);
}

/* is a command a special action? */
bool  KlineakConfig::is_special_action (const QString &command) {
   string comm = command.latin1();
  
   for ( vector<string>::iterator it=macrolist.begin(); it < macrolist.end(); it++) {
      if ( comm.find(*it) == 0) {                        
         return true;
      }
   }
   return (false);
}

/* select a new keyboard */
void  KlineakConfig::select_new_keyboard(const QString &ndata) {
  myKbd.clear();
  myKbd = myDef.getKeyboard((cbKeyboardBrand->currentText()).latin1(), ndata.latin1());
  myKbd.setCommands(myConfig);
  cout << "SELECTED NEW KEYBOARD" << endl;
  cout << myKbd << endl;
  cout << "--END SELECTED NEW KEYBOARD--" << endl;

  changing_text_from_signal = true;
  refresh_keylist();
  refresh_keycommand(lstAvailableKeys->item(0)); /* refresh_keylist selects 1st key, hence index 0 */
  refresh_kbimage();
  changing_text_from_signal = false;
  selected_key = 0;
}

/* change the key command data to the users input */
void  KlineakConfig::change_key_command(LObject *thiskey, const QString &entrytext) {
  string entry = entrytext.latin1();
  LCommand command = thiskey->getCommand();
  unsigned int mods;
  /* Update our config file myConfig object and our lobject */
  /** Go through all of the keycommands in our config file. */
  vector<keycommand_info>& kcomm = myConfig.getKeycomm(thiskey->getName());
  /** For all of the keycommand_info structs for that key. Find the one that matches
   *  and update it. */
  cout << "Finding the right keycomm to update." << endl;
  cout << "kcomm.size() = " << kcomm.size() << endl;
  for (vector<keycommand_info>::size_type j = 0; j < kcomm.size(); j++) {
	  cout << "j = " << j << endl;
	  cout << "kcomm[j].command = " << kcomm[j].command.getCommand() << endl;
	  cout << "command = " << command.getCommand() << endl;
     if (kcomm[j].command.getCommand() == command.getCommand()) {
	     cout << "found right key command" << endl;
	mods = kcomm[j].modifiers;
        kcomm[j].command = LCommand(entry);
        thiskey->setCommand(LCommand(entry), mods);	
	cout << thiskey->getName() << " now bound to command " << thiskey->getCommand(mods).getCommand() << endl;
     }
  }
  cout << "change_key_command is done" << endl;
}

/* wrapper for change_key_command, lookups the selected key */
void  KlineakConfig::change_selectedkey_command(const QString &ientrytext) {
  // ientrytext is the command to set to.
  string entrytext = ientrytext.latin1();
  // key is the currently selected key
  string key = lstAvailableKeys->text(lstAvailableKeys->currentItem()).latin1();
  LObject *obj = myKbd.getObject(key);
  cout << "change_selectedkey_command: key = " << key << " entrytext = " << entrytext << endl;
  if (obj==NULL) {
    cerr << "Invalid selected key index: " << selected_key << endl;
    return;
  }
  if (obj->getCommand().getCommand() != entrytext ) {
	  cout << "doing change_key_command" << endl;
	change_key_command(obj, ientrytext);
  }
}

/* wrapper for change_key_displayname, looks up the selected key */
void  KlineakConfig::updateDisplayName(const QString& ientrytext) {
   string entrytext = ientrytext.latin1();
   string key = lstAvailableKeys->text(lstAvailableKeys->currentItem()).latin1();
   LObject *obj = myKbd.getObject(key);
   cout << "updateDisplayName: key = " << key << " entrytext = " << entrytext << endl;
   if (obj==NULL) {
	   cerr << "Invalid selected key index: " << selected_key << endl;
	   return;
   }
   if (obj->getCommandDisplayName() != entrytext ) {
	   change_key_displayname(obj,ientrytext);
   }
}

void  KlineakConfig::change_key_displayname(LObject *thiskey, const QString &entrytext) {
   string entry = entrytext.latin1();
   /* Update our config file myConfig object and our lobject */
   /** Go through all of the keycommands in our config file. */
   vector<keycommand_info>& kcomm = myConfig.getKeycomm(thiskey->getName());
   /** For all of the keycommand_info structs for that key. Find the one that matches
    * and update it. */
   //cout << "Looking for the right display name to change" << endl;
   for (vector<keycommand_info>::size_type j = 0; j < kcomm.size(); j++) {
	   //cout << "j = " << j << endl;
	   //cout << "thiskey->getCommandDisplayName() = " << thiskey->getCommandDisplayName() << endl;
	   //cout << "kcomm[j].display_name = " << kcomm[j].display_name << endl;
	   //cout << "thiskey->getCommand(kcomm[j].modifiers) = " << thiskey->getCommand(kcomm[j].modifiers) << endl;
	   //cout << "kcomm[j].command = " << kcomm[j].command << endl;
	   //cout << "kcomm[j].config_name = " << kcomm[j].config_name << endl;
	   //cout << "kcomm[j].parsed_name = " << kcomm[j].parsed_name << endl;

	  if ( thiskey->getCommandDisplayName() == kcomm[j].display_name &&
               thiskey->getCommand(kcomm[j].modifiers) == kcomm[j].command) 
	  {
	       //cout << "Found correct entry!" << endl;
	       kcomm[j].display_name = entry; 
	       /** Update the config_name with the proper display and modifiers */
	       kcomm[j].config_name = "[" + kcomm[j].display_name;
	       kcomm[j].config_name +=  "] ";
	       kcomm[j].config_name += kcomm[j].parsed_name;
	       if (thiskey->getModifierString(kcomm[j].modifiers) != "")
		       kcomm[j].config_name += "+" + thiskey->getModifierString(kcomm[j].modifiers);

	       //cout << "kcomm[j].config_name = " << kcomm[j].config_name << endl;
               thiskey->setCommandDisplayName(entry); 
	       //cout << "kcomm[j].display_name = " << kcomm[j].display_name << endl;
	       //cout << "thiskey->getCommandDisplayName() = " << thiskey->getCommandDisplayName() << endl;
	       //cout << "FIXME: Update kcomm[j].config_name to have the proper display name!!!!!" << endl;
	  }
   }
}

/** Present the user with a choice of supported keyboards and get the keyboard type back as a return value. */
void KlineakConfig::createBasic(const QString &filename){
  /** Get the first keyboard parsed from the .def file */
  map<string,LKbd*>::iterator it = myDef.getTable().begin();
  string type = it->first;
  dnd.addValue(_CD_USERCONFFILE, filename.latin1());
  dnd.addValue(_CD_KEYBOARD_TYPE,type);
  create_new_conf(dnd, myDef);
  cout << "Created a basic config file." << endl;
}
/** This member function set's KlineakConfig's definition widget. */
void KlineakConfig::setLineakDef(KlineakDef *def){
	klineakdef = def;	
}

/* backup the conf file so we can cancel the changes */
bool KlineakConfig::backup_conffile (void) {
   KURL source, dest;
   QString name;
   QString returnMsg;
   //cout << "Backup conffile\n";
   name = (myConfig[_CD_USERCONFFILE]).c_str();
   cout << name << " to " << name + ".backup" << endl;
   source.setPath(name);
   dest.setPath(name + ".backup");
   KIO::file_copy(source,dest, 0755, true, true, false);
  
  return true;
}

/* restore the conf file from backup */
bool KlineakConfig::restore_conffile (void) {

   KURL source, dest;
   QString name;
   name = (myConfig[_CD_USERCONFFILE]).c_str();
   source.setPath(name + ".backup");
   dest.setPath(name);
   KIO::file_copy(source,dest, 0755, true, true, false);

  return true;
}
bool KlineakConfig::save_conffile (void) {
   Saver tmp(myConfig.getFilename());
   cout << "Saving!" << endl;
   return (tmp.saveFile(myConfig));

}
void signalchild(int sig_num) {
  pid_t child;

  /*   If more than one child exits at approximately the same time, the signals */
  /*   may get merged. Handle this case correctly. */
  while ((child = waitpid(-1, NULL, WNOHANG)) > 0)
  {
     if (verbose)
        cout << "Catch CHLD signal -> pid " << child << " terminated" << endl;
  }
}
void signalhup(int sig_num) {
	klineakconfig->hupLineakd();
}
void signalquit(int sig_num) {
        klineakconfig->quit();
}
