/***************************************************************************
                          awardiota.h  -  description
                             -------------------
    begin                : mi jul 2 2003
    copyright            : (C) 2003 by Jaime Robles
    email                : jaime@kde.org
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
*  it under the terms of the GNU General Public License as published by     *
*  the Free Software Foundation; either version 2 of the License, or        *
*  (at your option) any later version.                                      *
 *                                                                            *
*  This program is distributed in the hope that it will be useful,          *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
*  GNU General Public License for more details.                             *
 *                                                                            *
*  You should have received a copy of the GNU General Public License        *
*  along with this program; if not, write to the Free Software              *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *****************************************************************************/
#ifndef GLOBAL_DATA
#define GLOBAL_DATA
const int ENTITIES = 340;
const int ZONES = 40;
const int BANDS = 15;
const int MODES = 30;
#endif

#ifndef AWARDIOTA_H
#define AWARDIOTA_H
#include <klocale.h>
#include "adif.h"

class AwardIOTA  {

public:

  AwardIOTA();


  ~AwardIOTA();

  void clear();
  void worked(const int tzone, const int tband, const int tmode);
  void workedString(const int tzone, const QString& tband, const QString& tmode);
  void notWorked(const int tzone, const int tband, const int tmode);
  void notWorkedString(const int tzone, const QString& tband, const QString& tmode);
  bool isWorked(const int tzone);
  bool isWorkedBand (const int tzone, const int tband);
  bool isWorkedMode (const int tzone, const int tmode);
  int howManyWorkedBand(const int tband);
  int howManyWorkedMode(const int tmode);
  int howManyWorked();


  void confirmed(const int tzone, const int band, const int tmode);
  bool isConfirmed(const int tzone);
  bool isConfirmedBand (const int tzone, const int tband);
  bool isConfirmedMode (const int tzone, const int tmode);
  void confirmedString(const int tzone, const QString& tband, const QString& tmode);
  int howManyConfirmedBand(const int tband);
  int howManyConfirmedMode(const int tmode);
  void notConfirmed(const int tzone, const int tband, const int tmode);
  void notConfirmedString(const int tzone, const QString& tband, const QString& tmode);
  int howManyConfirmed();

private:
  Adif adif;
  int iotaCountConfirmed; // How many ZONES confirmed
  int iotaCountWorked; // How many ZONES worked

  int i, j, k; // just index
  int iotab[ZONES][BANDS]; // -1 Not worked, 0 = worked, 1 = confirmed
  int iotam[ZONES][MODES]; // -1 Not worked, 0 = worked, 1 = confirmed
  bool iotaW[ZONES];
  bool iotaC[ZONES];
  QString sAux;
  bool aux;
  int iAux;

};

#endif


