/***************************************************************************
                          world.cpp  -  description
                             -------------------
    begin                : mar dic 17 2002
    copyright            : (C) 2002 by Jaime Robles
    email                : jaime@kde.org
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
*  it under the terms of the GNU General Public License as published by     *
*  the Free Software Foundation; either version 2 of the License, or        *
*  (at your option) any later version.                                      *
 *                                                                            *
*  This program is distributed in the hope that it will be useful,          *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
*  GNU General Public License for more details.                             *
 *                                                                            *
*  You should have received a copy of the GNU General Public License        *
*  along with this program; if not, write to the Free Software              *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *****************************************************************************/
#include <klocale.h>
//#include <kdebug.h>
//#include <ostream.h>
#include "world.h"
 
World::World(){

  created = false;
  number = 0;

  QStringList lines;
  World::klogDir = QDir::homeDirPath()+"/.klog/";  // We create the ~/.klog for the logs
  QFile file( klogDir+"cty.dat" );
  if ( file.open( IO_ReadOnly ) ) {
    QTextStream stream( &file );
    QString line;
    while ( !stream.eof() ) {
      number++;
      // Read a Line and get all data
      QString data = stream.readLine();
      // We split the line
      QStringList fields = QStringList::split(SEPARATOR1, data );
    entity.setNumb(number);
    entity.setEntity( fields[0].latin1() );
    entity.setPfx(fields[7].latin1());
    entity.setCqz(fields[1].toInt());
    entity.setLon(fields[5].toDouble());
    entity.setLat( fields[4].toDouble());
    entity.setContinent( fields[3].latin1());
    entity.setItuz( fields[2].toInt());
    entity.setTimeZone( fields[6].toInt());
    World::nmap[number] = entity;
      //I create another data stream to process all prefixes
      // and then split the line
      QString datab = stream.readLine();
      datab.remove(0,4);  //removing the spaces at the begining of the lines
      QStringList prefs = QStringList::split(SEPARATOR2, datab );
      //While the line does not have a ";"
      while( !(datab.contains(';') ) ){
        ij = (datab.contains(','));
        n = 0;
        while (n < ij){
            World::map[prefs[n]] = entity;
          //entity.addPrefix(prefs[n].latin1());
          n++;
        }//
        datab = stream.readLine();
        datab.remove(0,4);  //removing the spaces at the begining of the lines
        prefs = QStringList::split(SEPARATOR2, datab );
      }// Now we will process when there is ";"
      ij = (datab.contains(','));
      n = 0;
      while (n <= ij){  // Disminuir uno, poner solo <
        if (prefs[n].contains(';')){
          j = prefs[n].length() - 1;
          prefs[n].truncate(j);
//          entity.addPrefix(prefs[n].latin1());
        }else{
        }
        World::map[prefs[n]] = entity;
        n++;
      }

    }
  created = true;
  file.close();


  }else{ //There is no cty.dat
    //ADD A QMESSAGEBOX

  }


  
//  wnumber = 0;
};

World::~World(){
  
};


// We create the world reading from a file "cty.dat"
void World::create(){
  number = 0;

  QStringList lines;
  QFile file( "cty.dat" );
  if ( file.open( IO_ReadOnly ) ) {
    QTextStream stream( &file );
    QString line;
    while ( !stream.eof() ) {
      number++;
      // Read a Line and get all data
      QString data = stream.readLine();
      // We split the line
      QStringList fields = QStringList::split(SEPARATOR1, data );
//      QStringList prefs = QStringList::split(SEPARATOR2, data );
      // Now we have to read the Name/continent... of the Entity
      //
      // entity = fields[0].latin1()
      // cqz  = fields[1].toInt()
      // ituz = fields[2].toInt()
      // continent = fields[3].latin1()
      // lon = fields[4].toDouble()
      // lat = fields[5].toDouble()
      // UTC = fields[6].toInt()
      // MainPrf lon = fields[7].latin1()
    //Entity
//    entity = new Entity(number,fields[0].latin1(),
//    fields[7].latin1(), fields[1].toInt(), fields[4].toDouble(), fields[5].toDouble(),
//     fields[3].latin1(), fields[2].toInt(), fields[6].toInt());
    entity.setNumb(number);
    entity.setEntity( fields[0].latin1() );
    entity.setPfx(fields[7].latin1());
    entity.setCqz(fields[1].toInt());
    entity.setLon(fields[5].toDouble());
    entity.setLat( fields[4].toDouble());
    entity.setContinent( fields[3].latin1());
    entity.setItuz( fields[2].toInt());
    entity.setTimeZone( fields[6].toInt());
// The next line prints to the console country - Number
//Entity (const int tnumb, const QString& tentity, const QString& tpfx,
//const int tcqz, const double tlon, const double tlat, const QString& tcontinent,
//const int tituz,  const int ttimeZone)
      //I create another data stream to process all prefixes
      // and then split the line
      QString datab = stream.readLine();
      datab.remove(0,4);  //removing the spaces at the begining of the lines
      QStringList prefs = QStringList::split(SEPARATOR2, datab );
      //While the line does not have a ";"
      while( !(datab.contains(';') ) ){
        ij = (datab.contains(','));
        n = 0;
        while (n < ij){
          entity.addPrefix(prefs[n].latin1());
          n++;
        }//
        datab = stream.readLine();
        datab.remove(0,4);  //removing the spaces at the begining of the lines        
        prefs = QStringList::split(SEPARATOR2, datab );
      }// Now we will process when there is ";"
      ij = (datab.contains(','));
      n = 0;
      while (n <= ij){
        if (prefs[n].contains(';')){
          j = prefs[n].length() - 1;
          prefs[n].truncate(j);
          entity.addPrefix(prefs[n].latin1());
        }else{
          entity.addPrefix(prefs[n].latin1());
        }
        n++;
      }
      entities.append(entity);

    }                                     
  file.close();

  }else{ //There is no cty.dat



  }
};

// We obtain the Entity from a call
// It receives a string, get the prefix and send it to
//   bool Entity::findPrefix(const QString tprx)
// for each prefix till find the country in the list.
// Once we have find the country we return its number or
// "0" if we have not found it.

int World::findEntity(const QString string){

  // The first task is to isolate the prefix
  prefixa = string;
  prefixab = string;
  qrz = prefixa;      // For last checkins at last
  qrz2 = qrz;
  i = 0;
  if(( (prefixa.contains('/')) || (prefixa.contains('\\')) )){
    if (prefixa.contains('/')){
      ij = prefixa.find('/');
      if ( ij < ((prefixa.length())- ij)  ) { //Like in F/EA4TV
        prefixab = prefixa.left(ij);
        qrz2 = prefixab;        
      }else{// Like in EA4TV/F
         if (!((prefixa.upper()).endsWith("/P"))
            && !((prefixa.upper()).endsWith("/M"))
            && (!(prefixa.upper()).endsWith("/QRP"))
            && (!(prefixa.upper()).endsWith("/0"))
            && (!(prefixa.upper()).endsWith("/1"))
            && (!(prefixa.upper()).endsWith("/2"))
            && (!(prefixa.upper()).endsWith("/3"))
            && (!(prefixa.upper()).endsWith("/4"))
            && (!(prefixa.upper()).endsWith("/5"))
            && (!(prefixa.upper()).endsWith("/6"))
            && (!(prefixa.upper()).endsWith("/7"))
            && (!(prefixa.upper()).endsWith("/8"))
            && (!(prefixa.upper()).endsWith("/9")))
        //if( (prefixa.right( (prefixa.length())-ij-1) != "P") && (prefixa.right( (prefixa.length())-ij-1) != "QRP"))
        {
            prefixab = prefixa.right(prefixa.length()-(ij+1));
        }else
        {  // It is a EA4TV/P or EA4TV/QRP       
          //prefixab =  prefixa.left( (prefixa.length())-ij-1);
          prefixab =  prefixa.left(ij); 
          
        }
        qrz2 = prefixab;
      }
    }else{
      ij = prefixa.find("\\");
      if ( (ij) < (prefixa.length()-ij ) ) { //Like in F\EA4TV
        prefixab = prefixa.right(prefixa.length() - ij);
        qrz2 = prefixab;        
      }else{// Like in F\EA4TV
        prefixab =  prefixa.left(ij-1);
        qrz2 = prefixab;        
      }      
    }
  }
  prefixa = prefixab;

  i = giveEnt(prefixa); // Checking full calls like "4U1ITU" first
  if (i!=0)
    return i;
  //////////  Begin the "Normal" check
  if ((prefixa.at(1)).isDigit()){ // The second character is a number as in F5XX
    prefixa.truncate(2);
    i = giveEnt(prefixa);
    if ((i == 0) && ((prefixab.at(2)).isDigit()) ){ // Then is a P40A call...
      prefixa = prefixab;
      prefixa.truncate(1);
      i = giveEnt(prefixa);
    }else if ((i == 0) && (!(prefixab.at(2)).isDigit()) ){ // Then is a F call...
      prefixa = prefixab;
      prefixa.truncate(1);
      i = giveEnt(prefixa);
    } 
  }else if ((prefixa.at(2)).isDigit()){ // The third character is a number as in EA4T
    prefixa.truncate(3); // We will look for EA6, ZS8... prefixes
    i = giveEnt(prefixa);
    if (i == 0){
      prefixa = prefixab;
      prefixa.truncate(2);
      i = giveEnt(prefixa);
    }
    if (i == 0){ // Prefixes as VP2M
      prefixa=prefixab;
      prefixa.truncate(4);
      i = giveEnt(prefixa);
//      if (i!=0)
//        return i;
    }
  }else if ((prefixa.at(3)).isDigit()){ // The forth character is a number as in 3DA0SV
    prefixa.truncate(4); // We will look for 3DA0
    i = giveEnt(prefixa);
    if (i == 0){
      prefixa = prefixab;
      prefixa.truncate(3);
      i = giveEnt(prefixa);
    }
  }

  if (i == 0){ // I want to look for calls like RA3AA or NA3A
  // The real prefix is just one letter but the next char is NOT a number
  // so the first condition is not satistied.
    prefixa = prefixab;
    if ((prefixa.at(2)).isDigit()){
      prefixa.truncate(1);
      i = giveEnt(prefixa);
    }
  }
  if (i == 0){
    i = giveEnt(qrz);
  }
  if (i == 0){ // We have to test for calls as 5U when reading from a log file
    i = giveEnt(qrz2);
  }
  if (i == 0){  // We have to test for calls as KL7 when
                  // reading from a log file as we truncate -1 to look for KL
    qrz2.truncate(qrz2.length() -1);
    i = giveEnt(qrz2);
  }

  // We have to check for calls as 3XY1L when readinf from a file
  // but just if we have not find another Entity
  if (i == 0){
    if ( ((prefixa.at(3)).isDigit()) && !(prefixa.at(2).isDigit())){ // The forth character is a number as in 3DA0SV
      prefixa.truncate(2); // We will look for 3X
      i = giveEnt(prefixa);
      if (i == 0){
        prefixa.truncate(1); // Maybe it is a F like station
        i = giveEnt(prefixa);        
      }
    }
  }  
  return i; // "i" is the Entity number
};



Entity World::getEntByNumb(int num){
  i = num;
/***********************************************************
* We receive the number and we try to get the Entity returning *
* a pointer to it                                          *
************************************************************
*/
/*  Entities::iterator iter;
  for ( iter = entities.begin(); iter != entities.end(); ++iter ){
    if ( (*iter).getNumb() == num ){ // It IS the Entity
      return (*iter);
    }
  }
  //Entity not found
  return (*iter);
  */
  found = false;
   for ( it = map.begin(); it != map.end(); ++it ) {
    if ( (it.data().getNumb()) == i){
        return (it.data());
    }
   }
    it = map.end();
    return (it.data());
  
};


int World::giveEnt(const QString tqrz){

  qrz = tqrz;
  it = map.begin();
  it = map.find(qrz);
  if (map.find(qrz) != map.end())
    return it.data().getNumb();
  else
    return 0;
};

int World::howManyEntities(){
  it = map.end();
  return it.data().getNumb();
};

bool World::isWorldCreated(){return created;};
