#ifndef __PROPGLOB
#define __PROPGLOB

#include <qdialog.h>

class KLineEdit;

class QGroupBox;
class QLabel;
class QButtonGroup;
class QPushButton;
class QRadioButton;
class QCheckBox;
class QComboBox;

class MainWidget;
class NetWidget;

class PropGlob : public QDialog
{
    Q_OBJECT

public:
    PropGlob(MainWidget *, QString name, NetWidget *);

private slots:
    void undefChange(int);
    void invertedChange(int);
    void clockChange(int);
    void fontChange(int);
    void apply();

private:
    void done(int);

    MainWidget *parent;
    NetWidget *netw;

    QGroupBox *gb_dev;
    QLabel *lsize;
    KLineEdit *defsize;
    QLabel *ldelay;
    KLineEdit *defdelay;
    QCheckBox *cb_display_name;
    QCheckBox *cb_ext_width;
    QButtonGroup *bg_undef;
    QRadioButton *undef[2];
    QButtonGroup *bg_invert;
    QRadioButton *invert[2];
    QComboBox *cb_font_type;
    QComboBox *cb_font_size;
    QButtonGroup *bg_dev_symbols;
    QRadioButton *dev_symbol[2];

    QButtonGroup *bg_clock;
    QRadioButton *clock[7];
    QCheckBox *invert_trigger;

    QGroupBox *gb_sim;
    QLabel *lstepTime;
    KLineEdit *stepTime;
    QLabel *lburst;
    KLineEdit *burst;

    QButtonGroup *bg_ftype;
    QRadioButton *xml_ftype;
    QRadioButton *klogic_ftype;

    QPushButton *bApply;
    QPushButton *bCancel;
    QPushButton *bOK;

    int curr_clk;
    int curr_undef;
    int curr_invert;
};

#endif
