/*************************************************/
/* methods for class PropText                    */
/*                                               */
/* text property dialog                          */
/*                                               */
/* Andreas Rostin                                */
/* 02.10.99                                      */
/*************************************************/
#include <klineedit.h>

#include <qmessagebox.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qpushbutton.h>
 
#include <klogic.h>
#include <xdevice.h>
#include <xnet.h>
#include <propText.h>
#include "propText.moc"

PropText::PropText(QWidget *parent, const char *name, XDeviceNet *_dnet, XDevice *_dev)
	: QDialog(parent, name, TRUE, WStyle_DialogBorder)
{
    // main variable for this dialog:
    dev = _dev;
    dnet = _dnet;

    devtext = new KLineEdit((QWidget *)this, (const char *)NULL);
    devtext->setGeometry(10, 10, 220, 20);
    devtext->setCaption("(null)");
    devtext->setMaxLength(40);

    bCancel = new QPushButton(this);
    bCancel->setGeometry(130, 50, 60, 25);
    bCancel->setText(i18n("Cancel"));

    bOK = new QPushButton(this);
    bOK->setGeometry(50, 50, 60, 25);
    bOK->setDefault(true);
    bOK->setText(i18n("OK"));

    setCaption(name);
    setFixedSize(240, 95);
    devtext->setText(dev->getText());

    connect(bOK, SIGNAL(clicked()), SLOT(accept()));
    connect(bCancel, SIGNAL(clicked()), SLOT(reject()));
}

void PropText::done(int r)
{	QString text = devtext->text();

	if (r == Accepted) {
		if (qstrcmp(dev->getText(), text)) {
			dnet->setText(dev->getID(), (char *)(const char *)text);
			dev->setImage();
		}
	}
	QDialog::done(r);
}

