#ifndef __TOOL_CLASS
#define __TOOL_CLASS

#include <qstring.h>
#include "klogicList.h"

class Tool
{
public:
	static unsigned int pow2(int base);
	static int pow2complement(int base, int clearbit);
	static QString bitString(char byte, int len);

	static const int MAXPOW = 30;
	static unsigned int powTab[MAXPOW + 1];
};

// this class can be used to map integers to strings
class IDMap
{
public:
	IDMap() {}
 
	~IDMap() {
		while (maplist.First())
			maplist.First()->Destroy();
	}
 
	void init() {
		while (maplist.First())
			maplist.First()->Destroy();
	}

	// add int id mapping
	void fileID(int file_id, int iid) {
		maplist.Append(&dummy, file_id, iid);
	}

	// add string id mapping
	// if string can be converted to an integer, that one is used for mapping
	inline void fileID(QString sid, int iid) {
		bool res;
		int file_id;

		file_id = sid.toInt(&res);
		if (res == FALSE) file_id = -1;
		maplist.Append(&dummy, file_id, iid)->setText(sid);
	}

	// map int id's
	inline int mapID(int file_id) {
		KlogicList<QString> *searched = maplist.With(file_id);
		return searched->getID2();
	}

	// map a string to an id
	// if string can be converted to an integer, that one is used for mapping
	inline int mapID(QString sid) {
		KlogicList<QString> *searched;

		bool  res;
		int iid = sid.toInt(&res);
 
		if (res == FALSE) searched = maplist.With(sid);
		else searched = maplist.With(iid);
 
		if (searched) return searched->getID2();
		return -1;
	}
private:
	KlogicList<QString> maplist;
	QString dummy;
};

#endif
