#ifndef __XMLEXPORT__
#define __XMLEXPORT__

#include <qxml.h>
#include <xmlField.h>

class XDeviceNet;
class XDevice;
class XWire;
class XmlSymbolContainer;

/*******************************************/
/* XML Export Interface                    */
/*                                         */
/* Andreas Rostin 23.08.2001               */
/*                                         */
/* adding symbols:                         */
/* - add a static XmlSymbolContainer sXXX  */
/* - add an unique ID for that             */
/* - in xmlExport.cpp, instanciate them    */
/*   together                              */
/*******************************************/
class XmlObject: public XmlField
{
public:
	XmlObject(QString);
	XmlObject(QString, int, int, int);
	virtual ~XmlObject();

	// create an instance from the xml string definition
	// using the xmlImport classes
	XDevice * createInstance(XDeviceNet *, int, int);

	static void setSymbolSet(int idx);
	static int getSymbolSet();
	static bool symbolEquals(const QString&, int);
	static QString getSymbol(int);
	static int getID(const QString&);

	void setValid(bool);
	bool isValid();

	static const int SYMBOLSET_STRING = 0;
	static const int SYMBOLSET_NUMBER = 1;

public:
	static XmlSymbolContainer sFILE_TYPE;
	static const char * ATT_CIRCUIT;
	static const char * ATT_SUBCIRCUIT;
	static const char * ATT_LIBRARY;

	static XmlSymbolContainer sKLOGIC_MAIN;
	static XmlSymbolContainer sCIRCUIT;
	static XmlSymbolContainer sDEV_CONN;
	static XmlSymbolContainer sWIRE_CONN;
	static XmlSymbolContainer sWIRE;
	static XmlSymbolContainer sDEVICE;
	static XmlSymbolContainer sLIBDEV;

	static XmlSymbolContainer sPROGRAM_VERSION;
	static XmlSymbolContainer sCREATION_DATE;
	static XmlSymbolContainer sUPDATE_DATE;
	static XmlSymbolContainer sAUTHOR;
	static XmlSymbolContainer sCOMMENT;

	static XmlSymbolContainer sID;
	static XmlSymbolContainer sFUNCTION;
	static XmlSymbolContainer sDELAY;
	static XmlSymbolContainer sUNDEF;
	static XmlSymbolContainer sINV;
	static XmlSymbolContainer sCLK_TYPE;
	static XmlSymbolContainer sMASTER;
	static XmlSymbolContainer sOSC_ON;
	static XmlSymbolContainer sOSC_OFF;
	static XmlSymbolContainer sOSC_STEP;
	static XmlSymbolContainer sSTAT;
	static XmlSymbolContainer sSIZE;
	static XmlSymbolContainer sXPOS;
	static XmlSymbolContainer sYPOS;
	static XmlSymbolContainer sRAM;
	static XmlSymbolContainer sTEXT_DISP;
	static XmlSymbolContainer sTEXT;
	static XmlSymbolContainer sPUSH;
	static XmlSymbolContainer sWIDTH;

	static XmlSymbolContainer sOUT_EQU;
	static XmlSymbolContainer sOUT_ID;
	static XmlSymbolContainer sIN_NAME;
	static XmlSymbolContainer sIN_ID;
	static XmlSymbolContainer sINTERN;
	static XmlSymbolContainer sTRI;
	static XmlSymbolContainer sPOS;
	static XmlSymbolContainer sNAME;
	static XmlSymbolContainer sBUSTYPE;

	// main elements
	static const int FILE_TYPE = 1;
	static const int KLOGIC_MAIN = 2;
	static const int CIRCUIT = 3;
	static const int DEV_CONN = 4;
	static const int WIRE_CONN = 5;
	static const int WIRE = 6;
	static const int DEVICE = 7;
	static const int ID = 8;	// object reference tag or attribute
	static const int LIBDEV = 9;

	// childs of KLOGIC_MAIN
	static const int PROGRAM_VERSION = 20;
	static const int CREATION_DATE = 21;
	static const int UPDATE_DATE = 22;
	static const int AUTHOR = 23;
	static const int COMMENT = 25;

	// childs of wires

	// childs of devices, circuits and wires
	static const int FUNCTION = 40;
	static const int DELAY = 41;
	static const int UNDEF = 42;
	static const int INV = 43;
	static const int CLK_TYPE = 44;
	static const int MASTER = 45;
	static const int OSC_ON = 46;
	static const int OSC_OFF = 47;
	static const int OSC_STEP = 48;
	static const int STAT = 49;
	static const int SIZE = 50;
	static const int XPOS = 51;
	static const int YPOS = 52;
	static const int RAM = 53;
	static const int TEXT_DISP = 54;
	static const int TEXT = 55;
	static const int PUSH = 56;
	static const int WIDTH = 57;

	// childs of devices
	static const int OUT_EQU = 60;
	static const int OUT_ID = 61;
	static const int IN_NAME = 62;
	static const int IN_ID = 63;
	static const int INTERN = 64;
	static const int TRI = 65;
	static const int POS = 66;
	static const int NAME = 67;
	static const int BUSTYPE = 68;

protected:
	int dx, dy;
	bool _valid;
	static int sym;

private:
	virtual void createXML(bool);
};

/*******************************************/
/* XML representation of a circuit         */
/*                                         */
/* Andreas Rostin 24.08.2001               */
/*******************************************/
class XmlNet: public XmlObject
{
public:
	XmlNet(XDeviceNet *, bool, int, int, int);
	XmlNet();

private:
	virtual void createXML(bool selected);
	XDeviceNet *net;
};

/*******************************************/
/* XML representation of a connection      */
/*     between devices and wires           */
/*                                         */
/* Andreas Rostin 24.08.2001               */
/*******************************************/
class XmlDeviceConnection: public XmlObject
{
public:
	XmlDeviceConnection(XWire *, bool, int, int, int);

private:
	virtual void createXML(bool selected);
	void setField(XDevice *, QPoint, int);
	XWire *wire;
};

/*******************************************/
/* XML representation of a connection      */
/*            between wires                */
/*                                         */
/* Andreas Rostin 24.08.2001               */
/*******************************************/
class XmlWireConnection: public XmlObject
{
public:
	XmlWireConnection(XWire *, bool, int, int, int);

private:
	virtual void createXML(bool selected);
	XWire *wire;
};

/*******************************************/
/* XML representation of a XWire           */
/*                                         */
/* Andreas Rostin 23.08.2001               */
/*******************************************/
class XmlWire: public XmlObject
{
public:
	XmlWire(XWire *, bool, int, int, int);

private:
	virtual void createXML(bool selected);
	XWire *wire;
};

/*******************************************/
/* XML representation of a XDevice         */
/*                                         */
/* Andreas Rostin 23.08.2001               */
/*******************************************/
class XmlDevice: public XmlObject
{
public:
	XmlDevice(XDevice *, bool, int, int, int);
	XmlDevice();

private:
	virtual void createXML(bool selected);
	XDevice *dev;
};

#endif
