#ifndef __XNet_CLASS__
#define __XNet_CLASS__

class QString;
class QPoint;
class QPainter;
class QTextStream;

#include "value.h"
#include "tool.h"
#include "xdevice.h"

class XmlNet;
class Selection;
class XWire;

#define EXP_ALL		0
#define EXP_SELECTION	1

#define NO_SELECTION	0
#define SELECT_IT	1

/*********************************************
* a network of devices with their connections
* is a device itself
*********************************************/
class XDeviceNet: public XDevice
{
public:
	static int instance;

	XDeviceNet();
	XDeviceNet(XDeviceNet *, int, int);
	XDeviceNet(XDeviceNet *, int, int, int);
	~XDeviceNet();

	//***** net operations
	XDevice *containsDev(QPoint);		// check all devices for containing the point, returns first
	XDevice *containsDev(XDevice *);	// check all devices for containing the device, returns first
	XWire *containsWire(QPoint);		// check all connections for containing the point, returns first

	int checkCircuitNames();		// check if all names within this circuit are unique
	int unifyCircuitNames();		// make all names within this circuit unique
	bool hasImpossibleEquations();		// check if all equations are displayable
	void deleteNet(QPainter *);		// delete content of the net
	virtual XDeviceNet *devIsNet();		// get pointer of net from netdevice
	XDeviceNet *subNet(QString&);		// get pointer of net by name
	XDeviceNet *rootParent();		// get pointer of root net
	XDeviceNet *parent();			// get pointer of parent net
	int empty();				// 1 if net contains nothing
	// get list of equations describing the content of the circuit
	KlogicList<OutputInfo> * parseCircuit(const char *qualifier = (const char *)NULL, KlogicList<OutputInfo> *ls = (KlogicList<OutputInfo> *)NULL);
	void applyDefaults();			// apply device defaults to all devices
	void garbageCollection(QPainter *);	// remove useless wires/nodes
	void setUndef(int);			// set undefined value of all connected output-interface devices

	//***** select groups of objects contained in rect
	void selectDev(QRect, KlogicList<XDevice> *);
	void selectWire(QRect, KlogicList<XWire> *);
	void grabSelection(Selection *);

	//***** drawing methods
	void drawDev(QPaintDevice *, QPainter *, XDevice *);	// draw device and all wires of it
	void drawAll(QPaintDevice *, QPainter *);		// draw all devices and wires
	int drawStatus(QPaintDevice *, QPainter *);		// (simulation) draw actually changed devices and wires
	void forceOutputChange();

	//***** device methods
	XDevice * newDevice(int func, int x, int y, int import_size = -1);
	int setInput(char *Name, int anz, int imp[]);
	void deleteDevice(QPainter *, XDevice *);		// remove device properly
	void setText(int, const QString&);			// set new text for device with given id

	//***** connection methods
	int checkConnection(XWire *);				// check wire for connections
	int checkConnection(int, int, XWire *); 		// used as import-function!

	//***** wire methods
	XWire * newWire();					// for import purposes
	XWire * newWire(QPainter *, QPoint);
	XWire * getWire(int);					// for import purposes
	int removeNode(QPainter *, QPoint);
	int releaseWire(QPainter *, XWire *);			// final works for locked wire
	void deleteWire(XWire *);				// remove wire properly

	//***** calculation operations
	void flush();
	void Burst(int burst);					// this is the method to calculate a circuit!

	//***** import/export methods
	bool exportXML(XmlNet&);
	bool exportXML(QTextStream &, bool, int, int dx = 0, int dy = 0);
	bool exportNet(QTextStream &, bool, bool, int dx = 0, int dy = 0);
	void correctIO(int dev_id, int old_id);			// change named_xxx list from old save values to new ones

	KlogicList<XDevice> * devPointer();

private:
	//***** calculation operations
	bool exportXML(QTextStream *, XmlNet *, bool, int, int dx = 0, int dy = 0);

	static const int IF_INPUT = 0;
	static const int IF_OUTPUT = 1;
	void switchInterface(int);

	virtual void Calculate(int);
	virtual void Propagate(int);

	// list of all devices in the net
	KlogicList<XDevice> netdev;

	// list of all connections in the net
	KlogicList<XWire> netwire;

	// interface to the parent circuit
	KlogicList<XDevice> netin;
	KlogicList<XDevice> netout;

	// list of all sub-circuits in the net
	KlogicList<XDeviceNet> netnet;
	XDeviceNet *_parent;

	int wireOK(QPainter *,XWire *);		// check wire for a minimum of 2 points

public:
	// -----------------------
	// *** old file format ***
	// -----------------------
	// name mapping for import operation
	IDMap devmap;
	IDMap wiremap;

	QString exportInstance();
	QString exportDevices(int selonly, int dx = 0, int dy = 0);
	QString exportWires(int selonly, int dx = 0, int dy = 0);
	QString exportWireConn(int selonly, int dx = 0, int dy = 0);
	QString exportDevConn(int selonly, int dx = 0, int dy = 0);
	void initImport();
	bool importInstance(QString, int dx = 0, int dy = 0);
	bool importDevice(QString, int select, int dx = 0, int dy = 0);
	bool importWire(QString, int select, int dx = 0, int dy = 0);
	bool importWireConn(QString, int select, int dx = 0, int dy = 0);
	bool importDevConn(QString, int select, int dx = 0, int dy = 0);
	static int magic_version;
};

#endif

