#ifndef __XOBJECT_H
#define __XOBJECT_H

//*************************************************************************
//* screen object                                                         *
//*************************************************************************
class XObject
{
	//=====================================================================
	//== constructor/destructor/initializing                             ==
	//=====================================================================
	protected: 					XObject( int, int );

	//-- should be private: _initial_ positioning
	protected: 			void 	initPos( QPoint );

	//-- not needed anymore
	//-- only for compatibility with xdevice.cpp:557
	//-- only for compatibility with oldhandler.cpp:564
	protected: 			void 	initPos( int x, int y );

	//=====================================================================
	//== object movement                                                 ==
	//=====================================================================
	public: 			QRect 	getPos();
	protected:			QRect 	getOldPos();
	protected: 			bool 	setPos( QPoint );
	public: 			void 	addPos( int, int );

	//=====================================================================
	//== undo movement                                                   ==
	//=====================================================================
	public: 			void 	setOrigin();
	public: 			void 	toOrigin();
	public: 			bool 	isOrigin( QPoint );

	//=====================================================================
	//== vertical/horizontal image offset                                ==
	//=====================================================================
	public: 			int 	getVOffset();
	public: 			int 	getHOffset();
	protected:		 	void 	setVOffset( int );
	protected: 			void 	setHOffset( int );
	private: 			void 	setOffset( QPoint );

	//=====================================================================
	//== pixmap methods                                                  ==
	//=====================================================================
	protected:		 	void 	drawImage( QPaintDevice*, QPainter* );
	public: 			QPixmap* getImage();
	protected:		 	void 	setImage();
	protected:			void 	erase( QPainter* );

	//=====================================================================
	//== selection methods                                               ==
	//=====================================================================
	public: 			void 	select( bool );
	public: 			bool 	isSelected();

	//=====================================================================
	//==                                                                 ==
	//=====================================================================
	protected: 			bool 	contains( QPoint, int, int );
	protected:			bool 	contains( QRect );

	//=====================================================================
	//== class constants                                                 ==
	//=====================================================================
	//-- input/output region (x-pixel)
	protected: 	static const int 	IOREG 		= 4;

	//-- default vertical aligment of an image
	private: 	static const int 	VOFFSET 	= 3;

	//=====================================================================
	//== variables                                                       ==
	//=====================================================================
	private: 			QPoint 	origin;

	//-- positions on the screen
	private: 			QRect 	oldPos;
	private: 			QRect 	newPos;

	//-- a positive value indicating the difference between grabbed and 
	//-- true position, i.e. between mouse hotspot and top left of object
	private: 			QPoint 	m_ptDelta;

	//-- image of object
	private: 			QPixmap	img;

	//-- image offset
	private:			QPoint	m_ptOffset;

	//-- flag if object is selected or not
	private: 			bool 	m_bIsSelected;
};

#endif


