/***************************************************************************
 *   Copyright (C) 2007 by xes                                             *
 *   xes@xesnet.fr                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "confWindow.h"

confWindow::confWindow ( QString confFileName, QDialog *parent ) : QDialog ( parent )
{
	confPath = confFileName;

	//Initialisation de la fenetre
	setupUi ( this );
	setWindowTitle ( tr ( NAME_APP ) + tr ( "Config " ));
	txtExample->setText ( "Example text ..." );
	loadConfig();
	lblWarning->setVisible ( false );
}

confWindow::~confWindow()
{}

void	confWindow::loadConfig()
{
	QSettings settings ( confPath, QSettings::IniFormat );

	//Parametres GENERAUX
	spinTrans->setValue ( settings.value ( "opacity", DEFAULT_OPACITY ).toInt() );
	chkSelect->setChecked ( settings.value ( "select", DEFAULT_SELECT ).toBool() );
	chkDecor->setChecked ( settings.value ( "decor", DEFAULT_DECOR ).toBool() );
	chkTitle->setChecked ( settings.value ( "title", DEFAULT_TITLE ).toBool() );
	chkScrollBar->setChecked ( settings.value ( "scrollbar", DEFAULT_SCROLL ).toBool() );
	chkAnimWin->setChecked ( settings.value ( "eventWin", DEFAULT_EVENTWIN ).toBool() );
	spinTime->setValue ( settings.value ( "eventTime", DEFAULT_EVENTTIME ).toInt() );
#ifdef __linux__
	chkRoot->setChecked ( settings.value ( "root", DEFAULT_ROOT ).toBool() );
	if ( settings.value ( "appsu", DEFAULT_APPSU ).toString() == KDE_SU )
		radKdesu->setChecked ( true );
	else
		radGnomesu->setChecked ( true );
#else
	chkRoot->setEnabled ( false );
	radKdesu->setEnabled ( false );
	radGnomesu->setEnabled ( false );
#endif

	//Parametres de COULEURS
	QPalette pal = txtExample->palette();
	pal.setColor (QPalette::Text, settings.value ( "textcolor", DEFAULT_TEXT_COLOR ).value<QColor>() );
	txtExample->setPalette ( pal );
	
	backColorTop = settings.value ( "basecolor", DEFAULT_BACK_COLOR_TOP ).value<QColor>();
	backColorBottom = settings.value ( "basecolorGradient", DEFAULT_BACK_COLOR_BOTTOM ).value<QColor>();
	makeGradient();

	//Parametres de FONT
	txtExample->setFont ( settings.value ( "font", txtExample->font() ).value<QFont>() );

	//Remplissage de la liste de lgos
	QListWidgetItem *newItem;
	QString 		txtItem;
	int			num = 0;
	while ( 1 )
	{
		txtItem = settings.value ( LOG_FILE ( num ), NONE_VALUE ).toString();
		if ( txtItem == NONE_VALUE )
			break;
		newItem = new QListWidgetItem ( lstLogFiles );
		newItem->setText ( txtItem );
		lstLogFiles->addItem ( newItem );
		num++;
	}
}

void	confWindow::saveConfig()
{
	QSettings settings ( confPath, QSettings::IniFormat );

	//Deplacement des parametres des elements
	QListWidgetItem	*item;
	int				realNum = 0;
	int				num = 0;
	while ( ( item = lstLogFiles->item ( num ) ) )
	{
		if ( num != realNum )
		{
			bool activate = settings.value ( LOG_CONFIG ( num, "activate" ), DEFAULT_ACTIVATE ).toBool();
			int x = settings.value ( LOG_CONFIG ( num, "x" ), GEO_DEFAULT_X ).toInt();
			int y = settings.value ( LOG_CONFIG ( num, "y" ), GEO_DEFAULT_Y ).toInt();
			int width = settings.value ( LOG_CONFIG ( num, "width" ), GEO_DEFAULT_WIDTH ).toInt();
			int height = settings.value ( LOG_CONFIG ( num, "height" ), GEO_DEFAULT_HEIGHT ).toInt();
			settings.setValue ( LOG_CONFIG ( num, "activate" ), activate );
			settings.setValue ( LOG_CONFIG ( num, "x" ), x );
			settings.setValue ( LOG_CONFIG ( num, "y" ), y );
			settings.setValue ( LOG_CONFIG ( num, "width" ), width );
			settings.setValue ( LOG_CONFIG ( num, "height" ), height );
		}
		if ( item->isHidden() == false )
			realNum++;
		num++;
	}

	//Sauvegarde la lstLogFilese de fichiers log
	realNum = 0;
	num = 0;
	while ( ( item = lstLogFiles->item ( num ) ) )
	{
		if ( item->isHidden() == false )
		{
			settings.setValue ( LOG_FILE ( realNum ), item->text() );
			realNum++;
		}
		num++;
	}

	//Supprimer les elements en trop (Si la lstLogFilese a retreci)
	int	i;
	for ( i = realNum; i <= num; i++ )
	{
		settings.remove ( LOG_FILE ( i ) );
		settings.remove ( LOG_CONFIG_BASE ( i ) );
	}

	//Parametres GENERAUX
	settings.setValue ( "opacity", spinTrans->value() );
	settings.setValue ( "select", chkSelect->isChecked() );
	settings.setValue ( "decor", chkDecor->isChecked() );
	settings.setValue ( "title", chkTitle->isChecked() );
	settings.setValue ( "scrollbar", chkScrollBar->isChecked() );
	settings.setValue ( "root", chkRoot->isChecked() );
	settings.setValue ( "eventWin", chkAnimWin->isChecked() );
	settings.setValue ( "eventTime", spinTime->value() );
	if ( radKdesu->isChecked () )
		settings.setValue ( "appsu", KDE_SU );
	else
		settings.setValue ( "appsu", GNOME_SU );

	//Parametres de COULEURS
	settings.setValue ( "basecolor", backColorTop );
	settings.setValue ( "basecolorGradient", backColorBottom );
	settings.setValue ( "textcolor", txtExample->palette().color ( QPalette::Text ) );
	//Parametres de FONT
	settings.setValue ( "font", txtExample->font() );
}

void	confWindow::makeGradient()
{
	QPalette pal = txtExample->palette();
	QLinearGradient gradient ( 1, 1, 1, txtExample->geometry().height() );
	gradient.setColorAt ( 0, backColorTop );
	gradient.setColorAt ( 1, backColorBottom );
	pal.setBrush ( QPalette::Base, QBrush ( gradient ) );
	txtExample->setPalette ( pal );
}

void	confWindow::on_btnSave_clicked()
{
	saveConfig();
	close();
}

void	confWindow::on_btnCancel_clicked()
{
	close();
}

void	confWindow::on_btnAdd_clicked()
{
	//Verifie si le log est deja existant
	int				num = 0;
	QListWidgetItem	*item;
	while ( ( item = lstLogFiles->item ( num ) ) )
	{
		if ( ( item->isHidden() == false ) && ( item->text() == txtLogFile->text() ) )
		{
			QMessageBox::critical ( this, tr ( "Add" ), tr ( "This log exist !" ) );
			return;
		}
		num++;
	}

	//Ajoute le fichier log
	QListWidgetItem	*newItem = new QListWidgetItem ( lstLogFiles );
	newItem->setText ( txtLogFile->text() );
	lstLogFiles->addItem ( newItem );

	//Gestion du bouton del
	if ( btnDel->text() != tr ( "&Del" ) )
		btnDel->setText ( tr ( "&Del" ) );
	if ( ( lstLogFiles->currentItem() != 0 ) && ( lstLogFiles->currentItem()->isHidden() == false ) )
	{
		if ( btnDel->isEnabled() == false )
			btnDel->setEnabled ( true );
	}
	else
		if ( btnDel->isEnabled() == true )
			btnDel->setEnabled ( false );
}

void	confWindow::on_btnEdit_clicked()
{
	lstLogFiles->currentItem()->setText ( txtLogFile->text() );
}

void	confWindow::on_btnDel_clicked()
{
	if ( btnDel->text() == tr ( "&Del" ) )
	{
		btnDel->setText ( tr ( "&Undo" ) );
		lstLogFiles->currentItem()->setHidden ( true );
	}
	else
	{
		btnDel->setText ( tr ( "&Del" ) );
		lstLogFiles->currentItem()->setHidden ( false );
	}
	btnEdit->setEnabled ( !btnEdit->isEnabled() );
}

void confWindow::on_toolLogFile_clicked()
{
	QString	fileName = QFileDialog::getOpenFileName ( this, tr ( "Open File" ), txtLogFile->text (), tr ( "All Files (*)" ) );

	if ( !fileName.isEmpty() )
		txtLogFile->setText ( fileName );
}

void confWindow::on_btnBackColorTop_clicked()
{
	QColor color = QColorDialog::getColor ( backColorTop ) ;
	
	if ( color.isValid() )
	{
		backColorTop = color;
		makeGradient();
	}
}

void confWindow::on_btnBackColorBottom_clicked()
{
	QColor color = QColorDialog::getColor ( backColorBottom ) ;
	
	if ( color.isValid() )
	{
		backColorBottom = color;
		makeGradient();
	}
}

void confWindow::on_btnTextColor_clicked()
{
	QPalette palette = txtExample->palette();
	QColor color = QColorDialog::getColor ( palette.color ( QPalette::Text ) ) ;
	if ( color.isValid() )
	{
		palette.setColor ( QPalette::Text, color );
		txtExample->setPalette ( palette );
	}
}

void confWindow::on_btnFont_clicked()
{
	bool ok;

	QFont font = QFontDialog::getFont ( &ok , txtExample->font() );
	if ( ok )
		txtExample->setFont ( font );
}

void confWindow::on_chkDecor_stateChanged ()
{
	if ( chkDecor->isChecked() )
		chkTitle->setChecked ( false );
}

void confWindow::on_chkTitle_stateChanged ()
{
	if ( chkTitle->isChecked() )
		chkDecor->setChecked ( false );
}

void confWindow::on_chkRoot_stateChanged ()
{
	lblWarning->setVisible ( true );
	if ( chkRoot->isChecked() )
	{
		radKdesu->setEnabled ( true );
		radGnomesu->setEnabled ( true );
	}
	else
	{
		radKdesu->setEnabled ( false );
		radGnomesu->setEnabled ( false );
	}
}

void confWindow::on_radKdesu_toggled()
{
	lblWarning->setVisible ( true );
}

void confWindow::on_radGnomesu_toggled()
{
	lblWarning->setVisible ( true );
}

void	confWindow::on_lstLogFiles_currentItemChanged()
{
	if ( btnDel->text() != tr ( "&Del" ) )
		btnDel->setText ( tr ( "&Del" ) );
	if ( btnEdit->isEnabled() == false )
		btnEdit->setEnabled ( true );
	if ( btnDel->isEnabled() == false )
		btnDel->setEnabled ( true );
	txtLogFile->setText ( lstLogFiles->currentItem()->text() );
}
