/***************************************************************************
 *   Copyright (C) 2007 by xes                                             *
 *   xes@xesnet.fr                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>

#include "klogshow.h"
#include "ui_mainWindow.h"

class mainWindow: public QDialog, public Ui::mainWindow
{
		Q_OBJECT
	public:
		mainWindow ( QString confFileName, int num, QDialog *parent = 0 );
		~mainWindow();
		bool				isValid();
		int				getNum();
		QString			getFilePath();
	signals:
		void				resize();
	private slots:
		void				on_btnQuit_clicked();
		void				on_txtLog_textChanged ();
		void				this_rejected();
		void				this_resize();
		bool				fileWatch_fileChanged();
		void				timerBlink_timeout();
	private:
		void				loadConfig();
		void				saveConfig();
		void				make_gradient(bool reverse = false);

		QString			confPath;
		QString			filePath;
		int				numLog;
		bool				valid;
		QFile			*file;
		QFileSystemWatcher	*fileWatch;
		int				mouseX;
		int				mouseY;
		QTimer			*timerBlink;
		int				countBlink;
		QColor			colorBaseDefault;
		QColor			colorTextDefault;
		int				countMax;
		bool				eventWin;
		bool				eventEnable;
	protected:
		bool				eventFilter ( QObject * watched, QEvent * event );
		void				mousePressEvent ( QMouseEvent* event );
		void				mouseReleaseEvent ( QMouseEvent * event );
		void				mouseMoveEvent ( QMouseEvent * event );
};

#endif
