# You might want to change the next line, the rest should be ok
%define qtdir /usr/local/qt

Name:      kmatplot
URL:       http://kmatplot.sourceforge.net
Summary:   Science plotting tool
Version:   0.4
Release:   1
Copyright: GPL
Vendor:    kamil <kamildobk@poczta.onet.pl>
Packager:  kamil <kamildobk@poczta.onet.pl>
Group:     Applications/Engineering
Source:    kmatplot-0.4.tar.gz
BuildRoot: /var/tmp/%{name}-root


%description
KMatplot is an Origin-like tool to generate scientific plots either in two or three dimensions.
Source package contains also Scilab support.


%prep
rm -rf $RPM_BUILD_ROOT
%setup -q

%build
export QTDIR=%{qtdir}
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS -DNO_DEBUG -DNDEBUG" ./configure --prefix=/usr/local
make

%install
make DESTDIR=$RPM_BUILD_ROOT install-strip

cd $RPM_BUILD_ROOT

find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' > \
	$RPM_BUILD_DIR/file.list.%{name}
			 
find . -type f | sed -e 's,^\.,\%attr(-\,root\,root) ,' \
        -e '/\/config\//s|^|%config|' >> \
        $RPM_BUILD_DIR/file.list.%{name}
								 
find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >> \
        $RPM_BUILD_DIR/file.list.%{name}

grep "\.oct$" $RPM_BUILD_DIR/file.list.%{name} > \
	$RPM_BUILD_DIR/file.list.%{name}-octave

grep "\.py$" $RPM_BUILD_DIR/file.list.%{name} > \
	$RPM_BUILD_DIR/file.list.%{name}-python

grep "\.pth$" $RPM_BUILD_DIR/file.list.%{name} >> \
	$RPM_BUILD_DIR/file.list.%{name}-python

egrep -v "\.oct$|\.py$|\.pth$" $RPM_BUILD_DIR/file.list.%{name} > \
	$RPM_BUILD_DIR/file.list.%{name}-main

%clean
rm -rf $RPM_BUILD_ROOT $RPM_BUILD_DIR/files.list.%{name} $RPM_BUILD_ROOT $RPM_BUILD_DIR/files.list.%{name}-main $RPM_BUILD_ROOT $RPM_BUILD_DIR/files.list.%{name}-octave $RPM_BUILD_ROOT $RPM_BUILD_DIR/files.list.%{name}-python

%files -f ../file.list.%{name}-main

%package octave
Summary:   Functions to transfer data from Octave to KMatplot
Vendor:    kamil <kamildobk@poczta.onet.pl>
Group:     Applications/Engineering

%description octave
This package contains Octave support, so it is possible to make plots directly from
Octave using 'kplot', 'kimage', 'kmesh' and other functions. Those functions transfer data from
Octave to KMatplot through an Unix socket.

%files octave -f ../file.list.%{name}-octave

%package python
Requires:  Numeric
Summary:   Functions to transfer data from Python applications to KMatplot
Vendor:    Martin Wiechert <martin.wiechert@gmx.de>
Group:     Applications/Engineering

%description python
This package contains Python support, so it is possible to make plots directly from
Python using 'kplot', 'kimage', 'kmesh' and other functions. Those functions transfer data from
Numeric Python application to KMatplot through an Unix socket.

%files python -f ../file.list.%{name}-python

