/***************************************************************************
                                  ksattrbtn.h
                             -------------------
    begin                : Fri Jan 7 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildbk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSATTRIBBUTTON_H
#define KSATTRIBBUTTON_H

#include <qpushbutton.h>
#include "../widgets/qsgattr.h"

class QWidget;
class KSAttrPanel;

/**
  *@author Kamil Dobkowski
  */
class KSAttrBtn : public QPushButton
 {
	Q_OBJECT
   public:
	KSAttrBtn(QWidget *parent=0, const char *name=0);
	virtual ~KSAttrBtn();

   signals:
   	void attrChanged();
   	
   protected:
	virtual void prepare( KSAttrPanel *panel ) = 0;
	virtual void accept( KSAttrPanel *panel ) = 0;

   private slots:
	void slot_show_panel();
        //void slot_accept_value();

   private:
        KSAttrPanel *m_attr_panel;
 };

//-----------------------------------------------------------//

class KSFillBtn : public KSAttrBtn
 {
	Q_OBJECT
   public:
	KSFillBtn( QWidget *parent=0, const char *name=0);
	virtual ~KSFillBtn();
	void setDialogFill( const QSGFill &f );
	QSGFill dialogFill() const { return f; }

   protected:
	void drawButtonLabel ( QPainter * p );
	QSGFill f;
 	virtual void prepare( KSAttrPanel *panel );
	virtual void accept( KSAttrPanel *panel );

 };

//-----------------------------------------------------------//

class KSFontBtn : public KSAttrBtn
 {
	Q_OBJECT
   public:
	KSFontBtn( QWidget *parent=0, const char *name=0);
	virtual ~KSFontBtn();
	void setDialogFont( const QSGFont &f );
	QSGFont dialogFont() const { return f; }

   protected:
	void drawButtonLabel ( QPainter * p );
	QSGFont f;
 	virtual void prepare( KSAttrPanel *panel );
	virtual void accept( KSAttrPanel *panel );
 };

//-----------------------------------------------------------//

class KSLineBtn : public KSAttrBtn
 {
	Q_OBJECT
   public:
	KSLineBtn( QWidget *parent=0, const char *name=0);
	virtual ~KSLineBtn();
	void setDialogLine( const QSGLine &l );
	QSGLine dialogLine() const { return l; }

   protected:
	void drawButtonLabel ( QPainter * p );
	QSGLine l;
 	virtual void prepare( KSAttrPanel *panel );
	virtual void accept( KSAttrPanel *panel );
 };

//-----------------------------------------------------------//

class KSPointBtn : public KSAttrBtn
 {
	Q_OBJECT
  public:
	KSPointBtn(QWidget *parent=0, const char *name=0);
	virtual ~KSPointBtn();
	void setDialogPoint( const QSGPoint &p );
	QSGPoint dialogPoint() const { return p; }

   protected:
	void drawButtonLabel( QPainter *p );
	QSGPoint p;
 	virtual void prepare( KSAttrPanel *panel );
	virtual void accept( KSAttrPanel *panel );
  };

//-----------------------------------------------------------//

class KSArrowBtn : public KSAttrBtn
 {
	Q_OBJECT
  public:
	KSArrowBtn(QWidget *parent=0, bool origin=false, const char *name=0);
	virtual ~KSArrowBtn();
	void setDialogArrow( const QSGArrow &a );
	QSGArrow dialogArrow() const { return a; }
        void setOrigin( bool origin );
	bool isOrigin() const { return m_origin; }

   protected:
	void drawButtonLabel( QPainter *p );
	QSGArrow a;
	bool m_origin;
 	virtual void prepare( KSAttrPanel *panel );
	virtual void accept( KSAttrPanel *panel );
  };

#endif
