/***************************************************************************
                                 ksplotchannels.cpp                             
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include"kschannellist.h"
#include"../ksdataobjectfactory.h"
#include"../ksmatrix.h"

//-------------------------------------------------------------//

KSChannelList::KSChannelList( QWidget *parent, const char *name = 0 )
: QListView( parent, name )
  {
   m_show_all_channels = true;
   m_default_channel = -1;
   prev_selected_data = NULL;
   prev_selected_channel = -1;
   m_data = NULL;
   setSorting(-1);
   setAllColumnsShowFocus( true );
   setRootIsDecorated( true );
   setTreeStepSize( 10 );
   setMultiSelection(false);
   setVScrollBarMode( AlwaysOn );
   setHScrollBarMode( AlwaysOff );
   connect( this, SIGNAL(selectionChanged()), this, SLOT(slot_show_description()) );
  }

//-------------------------------------------------------------//

KSChannelList::~KSChannelList()
  {
   emit sigShowText( QString::null );
  }

//-------------------------------------------------------------//

void KSChannelList::setDataObject( QSData *data, bool showAllChannels, int defaultChannel, bool showRoot )
 {
  m_show_all_channels = showAllChannels;
  m_default_channel   = defaultChannel;
  m_show_root	      = showRoot;
  if ( (QSData *)m_data != data ) {
	if ( !m_data.isNull() )  {
		disconnect( m_data, SIGNAL(sigDataChanged(QSData*,int)), this, SLOT(slot_refresh_list(QSData*,int)) );
		disconnect( m_data, SIGNAL(sigChildListChanged()), this, SLOT(slot_refresh_contents()) );
		disconnect( m_data, SIGNAL(sigNameChanged(QSData*,const char*)), this, SLOT(slot_refresh_list(QSData*,const char*)) );		
		}
	m_data = data;
        if ( data ) {
		connect( m_data, SIGNAL(sigDataChanged(QSData*,int)), this, SLOT(slot_refresh_list(QSData*,int)) );
		connect( m_data, SIGNAL(sigChildListChanged()), this, SLOT(slot_refresh_contents()) );
		connect( m_data, SIGNAL(sigNameChanged(QSData*,const char*)), this, SLOT(slot_refresh_list(QSData*,const char*)) );
		}

	 slot_refresh_contents();	
	}
 }

//-------------------------------------------------------------//

void KSChannelList::select( QSData *dataObject, int channel )
 {
  KSChannelListItem *citem = first();
  while( citem ) {
	if ( citem->dataObject() == dataObject && citem->channel() == channel ) setSelected( citem, true );
	citem = citem->next();
	}
 }

//-------------------------------------------------------------//

void KSChannelList::slot_refresh_contents()
  {
   // try to select the same item after refreshing the contents
   prev_selected_data    = selected() ? selected()->dataObject() : NULL;
   prev_selected_channel = selected() ? selected()->channel() : -1;

   clear();
   if ( !m_data.isNull() ) {
	 if ( m_show_root ) add_qsdata_object_to_list( m_data );
	 for( int child_nr=0; child_nr<m_data->childCount(); child_nr++ )
		add_qsdata_object_to_list( m_data->child(child_nr) );	
	}

   slot_refresh_list(NULL,0);
  }

//-------------------------------------------------------------//

void KSChannelList::add_qsdata_object_to_list( QSData *data )
 {
  KSChannelListItem *parentItem = new KSChannelListItem( this, data, m_default_channel, KSDataObjectFactory::channelNameFactory(data,-1),KSDataObjectFactory::channelDescFactory(data,-1) );
  if ( m_show_all_channels )
  for( int channel=data->channelCount()-1; channel>=0; channel-- ) {
	 if ( parentItem ) {
	 	(void )new KSChannelListItem( parentItem, data, channel,
			                KSDataObjectFactory::channelNameFactory(data,channel),
				        QString::null,
				        KSDataObjectFactory::channelDescFactory(data,channel) );
		}
	}

  if ( parentItem ) setOpen( parentItem, true );
 }



//-------------------------------------------------------------//

void KSChannelList::slot_refresh_list(QSData*object, int channel)
  {
   KSChannelListItem *current = first();
   while( current ) {
	if ( current->m_data &&
             current->m_channel == m_default_channel ) current->setText( 1, current->m_data->objectName() );
	QString size;
	if ( current->m_data &&
             current->m_channel >= 0 &&
	     current->m_data->matrix(current->m_channel) )
	     size.sprintf("%dx%d",current->m_data->matrix(current->m_channel)->rows(),
				  current->m_data->matrix(current->m_channel)->cols() );
	
        current->setText( 2, size );
	if ( current->dataObject() &&
	     current->dataObject() == prev_selected_data &&
	     current->channel()    == prev_selected_channel ) {
					current->setSelected( TRUE );
					setCurrentItem( current );		
					triggerUpdate();
					}
	current = current->next();
	}

   prev_selected_data = NULL;
   prev_selected_channel = -1;
   emit sigDataChanged( object, channel );
  }

//-------------------------------------------------------------//

void KSChannelList::slot_refresh_list( QSData*object, const char *newName )
  {
   KSChannelListItem *current = first();
   while( current ) {
	if ( current->m_data == object &&
             current->m_channel == m_default_channel ) current->setText( 1, newName );	
	current = current->next();
	}
  }

//-------------------------------------------------------------//

void KSChannelList::slot_show_description()
  {
   KSChannelListItem *citem = selected();
   if ( citem && citem->dataObject() ) {
	 emit sigShowText( KSDataObjectFactory::channelDescFactory(citem->dataObject(), citem->channel()) );
	} else {
	 emit sigShowText( QString::null );
	}
  }




 /*
if ( m_show_root ) {
	parentItem = new KSChannelListItem( this, data, m_default_channel, KSDataObjectFactory::channelNameFactory(data,-1),KSDataObjectFactory::channelDescFactory(data,-1) );
	}
  if ( m_show_all_channels )
  for( int channel=data->channelCount()-1; channel>=0; channel-- ) {
	 if ( parentItem ) {
	 	(void )new KSChannelListItem( parentItem, data, channel,
			                KSDataObjectFactory::channelNameFactory(data,channel),
				        QString::null,
				        KSDataObjectFactory::channelDescFactory(data,channel) );
		} else {
	 	(void )new KSChannelListItem( this, data, channel,
			                KSDataObjectFactory::channelNameFactory(data,channel),
				        QString::null,
				        KSDataObjectFactory::channelDescFactory(data,channel) );		
		}

	}
*/





