/***************************************************************************
                          ksexportpicturedlg.cpp  -  description
                             -------------------
    begin                : Tue May 29 2001
    copyright            : (C) 2001 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksexportpicturedlg.h"
#include "../widgets/qsplotview.h"
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qprocess.h>
#include <qpaintdevicemetrics.h>
#include <qprinter.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qpicture.h>
#include <qregexp.h>
#include <qslider.h>
#include <qmultilineedit.h>
#include <qmessagebox.h>
#include <qapplication.h>
#include <qfile.h>
#include <qpainter.h>
#include <stdio.h> // tmpfile

QString KSExportPictureDlg::m_file_name;
int KSExportPictureDlg::m_file_format = 0;
double KSExportPictureDlg::m_file_dpi = 72.0;

int KSExportPictureDlg::m_pixmap_format = 0;
int KSExportPictureDlg::m_pixmap_quality = 75;
bool KSExportPictureDlg::m_pixmap_smooth = false;

int KSExportPictureDlg::m_metafile_format = 0;

bool KSExportPictureDlg::m_input_full_page = false;
double KSExportPictureDlg::m_input_x = 0.0;
double KSExportPictureDlg::m_input_y = 0.0;
double KSExportPictureDlg::m_input_width = 0.0;
double KSExportPictureDlg::m_input_height = 0.0;

int KSExportPictureDlg::m_user_gs_device = 0;
int KSExportPictureDlg::m_user_imagick_device = 0;
int KSExportPictureDlg::m_user_command = -1;
QStringList KSExportPictureDlg::m_user_commands;
QString KSExportPictureDlg::m_user_curr_command;

//---------------------------------------------------------------------------//

KSExportPictureDlg::KSExportPictureDlg(QSPlotView *view, const char *name )
: KSExportPictureDlgInterf(view,name,TRUE)
 {
  m_view = view;
  m_curr_process = NULL;
  m_curr_temp_file = NULL;

  fileName->setText(m_file_name);

  fileFormat->clear();
  fileFormat->insertItem( tr("Pixmap") );
  fileFormat->insertItem( tr("Qt metafile") );
  fileFormat->insertItem( tr("User's program") );
  fileFormat->setCurrentItem( m_file_format );
  fileDpi->setText( QString::number(m_file_dpi) );

  pixmapDepth->clear();
  pixmapDepth->insertItem( tr("Screen") );
  pixmapDepth->setEnabled( FALSE ); // not implemented
  pixmapFormat->clear();
  pixmapFormat->insertStringList( QImage::outputFormatList() );
  pixmapFormat->setCurrentItem( m_pixmap_format );
  pixmapSmooth->setChecked( m_pixmap_smooth );
  pixmapQuality->setValue( m_pixmap_quality );

  metafileFormat->setCurrentItem( m_metafile_format );

  inputX->setText( QString::number(m_input_x) );
  inputY->setText( QString::number(m_input_y) );
  inputWidth->setText( QString::number(m_input_width) );
  inputHeight->setText( QString::number(m_input_height) );
  inputFullPage->setChecked( m_input_full_page );

  if ( m_input_width == 0.0 || m_input_height == 0.0 ) {
	setFullPage( TRUE );
	setFullPage( FALSE );
	}

  if ( m_user_command == -1 ) {
	 // default comand in the edit field
         m_user_curr_command = "gs -q -dBATCH -dSAFER -dQUIET -dNOPAUSE  -g%3x%4 -sDEVICE=%6 -sOutputFile=%2 %1 ";
	 // commands in the drop-down menu
         m_user_commands.append( m_user_curr_command );
	 m_user_commands.append("pstoedit -f xfig %1 %2");
         m_user_commands.append("convert -antialias -page %3x%4 ps:%1 %7:%2");
         m_user_commands.append("convert -colors 256 -dither -page %3x%4 ps:%1 %7:%2");
         m_user_commands.append("cp %1 %2");
         m_user_command = 0;
	}	

  userCommand->clear();
  userCommand->insertStringList( m_user_commands );
  userCommand->setCurrentItem( m_user_command );
  userCommand->setEditText( m_user_curr_command );

  userGSDevice->setCurrentItem( m_user_gs_device );
  userIMagickDevice->setCurrentItem( m_user_imagick_device );
  changeImageSize( QString::null );
 }

//---------------------------------------------------------------------------//

KSExportPictureDlg::~KSExportPictureDlg()
 {
  clean_up();
 }

//---------------------------------------------------------------------------//

void KSExportPictureDlg::browseFilename()
 {
  QString result = QFileDialog::getSaveFileName(QDir::currentDirPath(),
                                        tr("*| All files (*)"),
					this, "export_picture",
					tr("Export to..."));
  if ( !result.isEmpty() ) fileName->setText( result );
 }

//---------------------------------------------------------------------------//

void KSExportPictureDlg::changeImageSize( const QString& )
 {
  double dpi = fileDpi->text().toDouble();
  double w =  inputWidth->text().toDouble();
  double h = inputHeight->text().toDouble();
  imageSize->setText( QString::number( QMAX((int )QSCoord::mmToPixels(w,dpi),1) ) +
		      " x " +
		      QString::number( QMAX((int )QSCoord::mmToPixels(h,dpi),1) ) +
                      tr(" pixels") );
 }

//---------------------------------------------------------------------------//

void KSExportPictureDlg::setFullPage( bool enabled )
 {
  if ( enabled ) {
 	if ( m_view->workbook()->printer() ) {
	 	QPaintDeviceMetrics pdm(m_view->workbook()->printer());
	 	inputX->setText(QString::number(0));
	 	inputY->setText(QString::number(0));
	 	inputWidth->setText(QString::number(pdm.widthMM()));
         	inputHeight->setText(QString::number(pdm.heightMM()));
        	}	
	 inputX->setEnabled( FALSE );
	 inputY->setEnabled( FALSE );
	 inputWidth->setEnabled( FALSE );
	 inputHeight->setEnabled( FALSE );
	} else {
	 inputX->setEnabled( TRUE );
	 inputY->setEnabled( TRUE );
	 inputWidth->setEnabled( TRUE );
	 inputHeight->setEnabled( TRUE );
	}
 }

//---------------------------------------------------------------------------//

void KSExportPictureDlg::exportPicture()
 {
  clean_up();

  if ( fileName->text().isEmpty() ) {
	QMessageBox::warning ( this, tr("Error"), tr("File name is empty !"), QMessageBox::Ok, 0, 0 );
	return;
	}

  // calculate the size of output
  enum OutputType { OutputPixmap=0, OutputMetafile=1, OutputProgram=2 } output_type;
  output_type = (OutputType )fileFormat->currentItem();

  double dpi  = fileDpi->text().toDouble();
  double x_mm = inputX->text().toDouble();
  double y_mm = inputY->text().toDouble();
  double w_mm = inputWidth->text().toDouble();
  double h_mm = inputHeight->text().toDouble();
  int w = QMAX( (int )QSCoord::mmToPixels(w_mm,dpi), 1 );
  int h = QMAX( (int )QSCoord::mmToPixels(h_mm,dpi), 1 );

  // prepare an output device
  QString format;
  QPaintDevice *output_device = NULL;

  userOutput->clear();
  userOutput->append(tr("Exporting ..."));
  qApp->processEvents();
  if ( output_type == OutputPixmap ) {
         if ( pixmapSmooth->isChecked() ) { w *= 2; h *= 2; dpi *= 2.0; }
         QPixmap *pixmap = new QPixmap( w, h );
         pixmap->fill( white );
	 output_device = pixmap;
	 format = QImage::outputFormatList()[pixmapFormat->currentItem()];
	}
  else
  if ( output_type == OutputMetafile ) {
	 output_device = new QPicture();
         format = QString::null;
	}
  else
  if ( output_type == OutputProgram ) {
	 m_curr_temp_file = new QFile( tmpnam(NULL) );

	 // create a temporary file
	 if ( !m_curr_temp_file->open(IO_WriteOnly) ) userOutput->append( tr("Can't open a temporary file ")+m_curr_temp_file->name() ); else m_curr_temp_file->close();
					
	 QPrinter *printer = new QPrinter();
         printer->setOutputToFile( TRUE );
	 printer->setOutputFileName( m_curr_temp_file->name() );// overwrite temp_file
 	 printer->setPageSize( m_view->workbook()->printer()->pageSize() );
         printer->setFullPage( TRUE );
         printer->setColorMode( QPrinter::Color );
	 printer->setNumCopies( 1 );
         output_device = printer;
	 format = QString::null;
	}

  // draw on a pixmap
  QSPage *curr_page = m_view->currentPage();
  if ( curr_page ) {
  	QPainter painter( output_device );
	// Try setting resolution in Qt3 instead of this
	// - check crop 0
	if ( output_type == OutputProgram ) {
  		painter.translate( 0, -int(h/dpi*(dpi-72.0)) );
		}
		
  	painter.translate( -(int )QSCoord::mmToPixels(x_mm,dpi),
		      	   -(int )QSCoord::mmToPixels(y_mm,dpi) );

	curr_page->paint( &painter, dpi, true );	
	}

  // generate output
  bool result = false;
  if (  output_type == OutputPixmap ) {
	 QPixmap *output = (QPixmap *)output_device;
	 QImage image = output->convertToImage();
	 if ( pixmapSmooth->isChecked() ) image = image.smoothScale( w/2, h/2 );
	 result = image.save( fileName->text(), format, pixmapQuality->value() ); 	
	 if ( !result ) userOutput->append(tr("Can't write image !"));
	}
  else
  if ( output_type == OutputMetafile ) {
	 QPicture *output = (QPicture *)output_device;
	 result = output->save(fileName->text(), ( metafileFormat->currentItem() ? "svg" : NULL ) );
	 if ( !result ) userOutput->append(tr("Can't write image !"));
        }
  else
  if ( output_type == OutputProgram ) {
	 QPrinter *output = (QPrinter *)output_device;
	 if ( output->aborted() ) {
		userOutput->append(tr("Printing to PS aborted !."));	
	 	} else {
		// substitute values
		QString command_line = userCommand->currentText();
                command_line = command_line.replace( QRegExp("%1"), m_curr_temp_file->name() );
         	command_line = command_line.replace( QRegExp("%2"), fileName->text()  );
	 	command_line = command_line.replace( QRegExp("%3"), QString::number(w) );
         	command_line = command_line.replace( QRegExp("%4"), QString::number(h) );
          	command_line = command_line.replace( QRegExp("%5"), QString::number(dpi) );
	 	command_line = command_line.replace( QRegExp("%6"), userGSDevice->currentText() );
                command_line = command_line.replace( QRegExp("%7"), userIMagickDevice->currentText() );
	 	command_line = command_line.stripWhiteSpace();	
		userOutput->append( tr("Executing:\n")+command_line );
                qApp->processEvents();

		// prepare argument list
                m_curr_process = new QProcess( QStringList::split( QRegExp("\\s+"), command_line ), this );
		connect( m_curr_process, SIGNAL(readyReadStdout()), this, SLOT(slotReceivedOutput()) );
		connect( m_curr_process, SIGNAL(readyReadStderr()), this, SLOT(slotReceivedOutput()) );
	        connect( m_curr_process, SIGNAL(processExited()), this, SLOT(slotProcessExited()) );
		result = m_curr_process->start();
		
		if ( !result ) { userOutput->append( tr("\nCould not run the program !") ); clean_up(); }			
		}
	}

  m_file_name = fileName->text();
  m_file_format = fileFormat->currentItem();
  m_file_dpi = fileDpi->text().toDouble();

  m_input_x = inputX->text().toDouble();
  m_input_y = inputY->text().toDouble();
  m_input_width = inputWidth->text().toDouble();
  m_input_height = inputHeight->text().toDouble();
  m_input_full_page = inputFullPage->isChecked();

  m_pixmap_format = pixmapFormat->currentItem();
  m_pixmap_quality = pixmapQuality->value();
  m_pixmap_smooth = pixmapSmooth->isChecked();

  m_metafile_format = metafileFormat->currentItem();

  m_user_gs_device = userGSDevice->currentItem();
  m_user_imagick_device = userIMagickDevice->currentItem();
  m_user_command = userCommand->currentItem();
  m_user_commands.clear();
  for ( int i=0; i<userCommand->count(); i++ ) m_user_commands.append( userCommand->text( i ) );
  m_user_curr_command = userCommand->currentText();

  delete output_device;
  if ( !result ) QMessageBox::warning ( this, tr("Error"), tr("Unknown error !"), QMessageBox::Ok, 0, 0 );

  userOutput->append(tr("Finished."));
  m_view->updateCanvas();
 }

//---------------------------------------------------------------------------//

void KSExportPictureDlg::slotReceivedOutput()
 {
  if ( m_curr_process ) {
	if ( m_curr_process->readStdout().size() ) userOutput->append(m_curr_process->readStdout());
	if ( m_curr_process->readStderr().size() ) userOutput->append(m_curr_process->readStderr());	
	}
  qApp->processEvents();
 }

//---------------------------------------------------------------------------//

void KSExportPictureDlg::slotProcessExited()
 {
  if ( m_curr_process && m_curr_process->normalExit() ) {
	userOutput->append( tr("\nExit code : ")+QString::number(m_curr_process->exitStatus()) );
	}  else {
	userOutput->append( tr("\nProgram died unexpectedly !") );
	}
  clean_up();
 }

//---------------------------------------------------------------------------//

void KSExportPictureDlg::clean_up()
 {
  if ( m_curr_process && m_curr_process->isRunning() ) m_curr_process->kill();	
  delete m_curr_process; m_curr_process = NULL;
  if ( m_curr_temp_file )  m_curr_temp_file->remove();
  delete m_curr_temp_file; m_curr_temp_file = NULL;
 }

/*
&& m_curr_process->normalExit()
else {
	userOutput->append( tr("\nProgram died unexpectedly !") );
	}
*/
//for( int i=0; i<(int )args.count(); i++ ) user_prog << args[i].stripWhiteSpace();
//		QStringList args = QStringList::split( QRegExp("\\s+"), command_line );
