/***************************************************************************
                                ksmpanels.h
                             -------------------
    copyright            : (C) 2001 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSMPANELS_H
#define KSMPANELS_H

#include "ksmpanelmatrixinterf.h"
#include "ksmpanelrefinterf.h"
#include "ksmpanelstringinterf.h"
#include "ksmpanelformulainterf.h"

#include"../ksmatrix.h"

class KSMatrixRef;
class KSMatrixColRef;
class KSMatrixString;
class KSMatrixFormula;
class KSChannelList;
class KSWorkbook;
class QSData;
class KSMatrixWorksheetCellRange;

//------------------------------------------------------------------------//

/**
  *@author Kamil Dobkowski
  */
class KSMPanelMatrix : public KSMPanelMatrixInterf {
    Q_OBJECT
  public:
	KSMPanelMatrix( KSWorkbook *workbook, KSMatrix *matrix, QWidget *parent );
	virtual ~KSMPanelMatrix();
        virtual bool isModified();
	virtual void updateContents();
	virtual QSMatrix *editedMatrix();
  public slots:
   	virtual void apply();	
  private:
	KSWorkbook *m_workbook;
	KSMatrix *m_matrix;
	QSData *m_data_object;
	int m_channel;
};

//------------------------------------------------------------------------//


class KSMPanelRef : public KSMPanelRefInterf {
	Q_OBJECT
   public:
	KSMPanelRef( KSWorkbook *workbook, KSMatrixWorksheetCellRange *matrix, QWidget *parent );
	virtual ~KSMPanelRef();
        virtual bool isModified();
	virtual void updateContents();
	virtual QSMatrix *editedMatrix();
  public slots:
   	virtual void apply();	
  protected:
	virtual void customEvent( QCustomEvent *e );
  private:
	KSWorkbook   *m_workbook;
	KSMatrixWorksheetCellRange  *m_matrix;
	QSData *m_data_object;
	int m_channel;
	KSChannelList *m_chan_list;
};

//------------------------------------------------------------------------//


class KSMPanelString : public KSMPanelStringInterf {
	Q_OBJECT
   public:
	KSMPanelString( KSWorkbook *workbook, KSMatrixString *matrix, QWidget *parent );
	virtual ~KSMPanelString();
        virtual bool isModified();
	virtual void updateContents();
 	virtual QSMatrix *editedMatrix();
  public slots:
   	virtual void apply();
  private:
	KSWorkbook *m_workbook;
	KSMatrixString  *m_matrix;
	QSData *m_data_object;
	int m_channel;
};

//------------------------------------------------------------------------//


class KSMPanelFormula : public KSMPanelFormulaInterf {
	Q_OBJECT
   public:
	KSMPanelFormula( KSWorkbook *workbook, KSMatrixFormula *matrix, QWidget *parent );
	virtual ~KSMPanelFormula();
        virtual bool isModified();
	virtual void updateContents();
 	virtual QSMatrix *editedMatrix();
  public slots:
   	virtual void apply();
  private:
	KSWorkbook *m_workbook;
	KSMatrixFormula *m_matrix;
	QSData *m_data_object;
	int m_channel;
};

#endif
